/*
 * Decompiled with CFR 0.152.
 */
package com.despegar.khronus.jclient;

import com.despegar.khronus.jclient.KhronusConfig;
import org.apache.http.HttpEntity;
import org.apache.http.client.HttpClient;
import org.apache.http.client.ResponseHandler;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.entity.EntityBuilder;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.conn.HttpClientConnectionManager;
import org.apache.http.entity.ContentType;
import org.apache.http.impl.client.BasicResponseHandler;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.impl.conn.PoolingHttpClientConnectionManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Sender {
    private static final Logger LOG = LoggerFactory.getLogger(Sender.class);
    private static final int socketTimeout = 3000;
    private static final int connectionRequestTimeout = 1000;
    private static final int connectTimeout = 1000;
    private final String[] hosts;
    private final HttpClient httpClient;

    public Sender(KhronusConfig config) {
        this.hosts = config.getHosts();
        PoolingHttpClientConnectionManager connManager = new PoolingHttpClientConnectionManager();
        connManager.setMaxTotal(config.getMaxConnections());
        HttpClientBuilder builder = HttpClients.custom().setConnectionManager((HttpClientConnectionManager)connManager);
        this.httpClient = builder.build();
        LOG.debug("Sender to send metrics created [Hosts: {}; MaxConnections: {}; socketTimeout: {}; connectionRequestTimeout: {}; connectTimeout: {}]", new Object[]{config.getHosts(), config.getMaxConnections(), 3000, 1000, 1000});
    }

    public void send(String json) {
        try {
            HttpPost httpPost = new HttpPost(String.format("http://%s/khronus/metrics", this.getHost()));
            httpPost.setEntity(this.getEntity(json));
            httpPost.setConfig(this.getDefaultConfig());
            this.httpClient.execute((HttpUriRequest)httpPost, (ResponseHandler)new BasicResponseHandler());
        }
        catch (Exception e) {
            LOG.error("Error sending metrics", (Throwable)e);
        }
    }

    private HttpEntity getEntity(String json) {
        return EntityBuilder.create().setText(json).setContentType(ContentType.APPLICATION_JSON).gzipCompress().build();
    }

    private RequestConfig getDefaultConfig() {
        return RequestConfig.custom().setSocketTimeout(3000).setConnectTimeout(1000).setConnectionRequestTimeout(1000).build();
    }

    private String getHost() {
        return this.hosts[0];
    }
}

