/*
 * Decompiled with CFR 0.152.
 */
package com.devsmart.microdb;

import com.devsmart.microdb.DBCallback;
import com.devsmart.microdb.MapDBDriver;
import com.devsmart.microdb.MicroDB;
import java.io.File;
import java.io.IOException;
import java.util.Map;
import org.mapdb.DB;
import org.mapdb.DBMaker;

public class DBBuilder {
    private DBCallback mCallback = new NullCallback();
    private int mSchemaVersion = 0;
    private Integer mCacheSize;
    private Map<String, MicroDB.Constructor> mConstructorMap;

    public static DBBuilder builder() {
        return new DBBuilder();
    }

    private DBBuilder() {
    }

    public DBBuilder callback(DBCallback cb) {
        this.mCallback = cb;
        return this;
    }

    public DBBuilder schemaVersion(int version) {
        this.mSchemaVersion = version;
        return this;
    }

    public DBBuilder cacheSize(int cacheSize) {
        this.mCacheSize = cacheSize;
        return this;
    }

    public DBBuilder constructorsMap(Map<String, MicroDB.Constructor> constructors) {
        this.mConstructorMap = constructors;
        return this;
    }

    public MicroDB build(File path) throws IOException {
        DBMaker mapdbBuilder = DBMaker.newFileDB((File)path);
        if (this.mCacheSize != null) {
            mapdbBuilder.cacheSize(this.mCacheSize.intValue());
        }
        DB db = mapdbBuilder.make();
        MapDBDriver driver = new MapDBDriver(db);
        return new MicroDB(driver, this.mSchemaVersion, this.mCallback, this.mConstructorMap);
    }

    public MicroDB buildMemoryDB() throws IOException {
        DB db = DBMaker.newMemoryDirectDB().transactionDisable().make();
        MapDBDriver driver = new MapDBDriver(db);
        return new MicroDB(driver, this.mSchemaVersion, this.mCallback, this.mConstructorMap);
    }

    static class NullCallback
    implements DBCallback {
        NullCallback() {
        }

        @Override
        public void onUpgrade(MicroDB db, int oldVersion, int newVersion) throws IOException {
        }
    }
}

