/*
 * Decompiled with CFR 0.152.
 */
package com.devsmart.microdb;

import com.devsmart.microdb.MicroDB;
import com.devsmart.ubjson.UBObject;
import com.devsmart.ubjson.UBValue;
import com.devsmart.ubjson.UBValueFactory;
import java.io.IOException;
import java.util.UUID;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DBObject {
    private static final Logger LOGGER = LoggerFactory.getLogger(DBObject.class);
    private UUID mId;
    private MicroDB mDB;
    protected boolean mDirty;

    protected void finalize() throws Throwable {
        try {
            if (this.mDB != null) {
                this.mDB.finalizing(this);
            }
        }
        finally {
            super.finalize();
        }
    }

    protected void init(MicroDB microDB) {
        this.mDB = microDB;
    }

    protected void setId(UUID id) {
        this.mId = id;
    }

    public void writeToUBObject(UBObject data) {
        if (this.mId != null) {
            data.put("id", (UBValue)UBValueFactory.createString((String)this.mId.toString()));
        }
    }

    public void readFromUBObject(UBObject data) {
        UBValue value = data.get((Object)"id");
        if (value != null && value.isString()) {
            this.mId = UUID.fromString(value.asString());
        }
    }

    protected void beforeWrite() {
    }

    protected void afterRead() {
    }

    public UUID getId() {
        return this.mId;
    }

    public void save() throws IOException {
        if (this.mDB != null && this.mId != null) {
            this.mDB.save(this);
        } else {
            LOGGER.warn("save object but DBObject does not reference a database: {}", (Object)this);
        }
    }

    public MicroDB getDB() {
        return this.mDB;
    }

    public void delete() throws IOException {
        if (this.mDB != null && this.mId != null) {
            this.mDB.delete(this);
        } else {
            LOGGER.warn("delete object but DBObject does not reference a database: {}", (Object)this);
        }
    }

    public void setDirty() {
        this.mDirty = true;
    }
}

