/*
 * Decompiled with CFR 0.152.
 */
package com.devsmart.microdb;

import com.devsmart.microdb.Cursor;
import com.devsmart.microdb.Driver;
import com.devsmart.microdb.Emitter;
import com.devsmart.microdb.MapFunction;
import com.devsmart.microdb.Row;
import com.devsmart.ubjson.UBObject;
import com.devsmart.ubjson.UBReader;
import com.devsmart.ubjson.UBValue;
import com.devsmart.ubjson.UBValueFactory;
import com.devsmart.ubjson.UBWriter;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.NavigableSet;
import java.util.Set;
import java.util.UUID;
import org.mapdb.Atomic;
import org.mapdb.BTreeMap;
import org.mapdb.Bind;
import org.mapdb.DB;
import org.mapdb.Fun;
import org.mapdb.Serializer;

public class MapDBDriver
implements Driver {
    final DB mMapDB;
    final Atomic.Var<UBObject> mMetadata;
    BTreeMap<UUID, UBValue> mObjects;
    private Map<String, IndexObject> mIndicies = new HashMap<String, IndexObject>();
    public static final Serializer<UBValue> SERIALIZER_UBVALUE = new UBValueSerializer();
    private static final UUID MAX_UUID = new UUID(Long.MAX_VALUE, Long.MAX_VALUE);
    private static final UUID MIN_UUID = new UUID(Long.MIN_VALUE, Long.MIN_VALUE);

    public MapDBDriver(DB mapdb) {
        Atomic.Var metadata;
        this.mMapDB = mapdb;
        this.mObjects = this.mMapDB.createTreeMap("objects").keySerializerWrap(Serializer.UUID).valueSerializer(SERIALIZER_UBVALUE).valuesOutsideNodesEnable().comparator(BTreeMap.COMPARABLE_COMPARATOR).makeOrGet();
        this.mMetadata = this.mMapDB.exists("metadata") ? this.mMapDB.getAtomicVar("metadata") : (metadata = this.mMapDB.createAtomicVar("metadata", (Object)UBValueFactory.createObject(), SERIALIZER_UBVALUE));
    }

    public DB getDB() {
        return this.mMapDB;
    }

    @Override
    public void close() {
        this.mMapDB.close();
    }

    @Override
    public UBObject getMeta() throws IOException {
        return ((UBObject)this.mMetadata.get()).asObject();
    }

    @Override
    public void saveMeta(UBObject obj) throws IOException {
        this.mMetadata.set((Object)obj);
    }

    @Override
    public UBValue get(UUID key) throws IOException {
        return (UBValue)this.mObjects.get((Object)key);
    }

    @Override
    public UUID genId() {
        UUID key = UUID.randomUUID();
        while (this.mObjects.containsKey((Object)key)) {
            key = UUID.randomUUID();
        }
        return key;
    }

    @Override
    public void insert(UUID id, UBValue value) throws IOException {
        this.mObjects.put((Object)id, (Object)value);
    }

    @Override
    public void update(UUID id, UBValue value) throws IOException {
        this.mObjects.put((Object)id, (Object)value);
    }

    @Override
    public void delete(UUID key) throws IOException {
        this.mObjects.remove((Object)key);
    }

    @Override
    public <T extends Comparable<T>> Cursor queryIndex(String indexName, T min, boolean minInclusive, T max, boolean maxInclusive) throws IOException {
        MapDBCursor retval = new MapDBCursor();
        retval.mDriver = this;
        NavigableSet index = this.mMapDB.getTreeSet(indexName);
        if (max != null && min != null) {
            retval.min = Fun.t2(min, (Object)(minInclusive ? MIN_UUID : MAX_UUID));
            retval.max = Fun.t2(max, (Object)(maxInclusive ? MAX_UUID : MIN_UUID));
            retval.index = index.subSet(retval.min, minInclusive, retval.max, maxInclusive);
        } else if (min != null && max == null) {
            retval.min = Fun.t2(min, (Object)(minInclusive ? MIN_UUID : MAX_UUID));
            retval.index = index.tailSet(retval.min, minInclusive);
        } else if (min == null && max != null) {
            retval.max = Fun.t2(max, (Object)(maxInclusive ? MAX_UUID : MIN_UUID));
            retval.index = index.headSet(retval.max, maxInclusive);
        } else {
            retval.index = index;
        }
        retval.seekToBegining();
        return retval;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T extends Comparable<T>> void addIndex(String indexName, MapFunction<T> mapFunction) throws IOException {
        Map<String, IndexObject> map = this.mIndicies;
        synchronized (map) {
            IndexObject<T> index = this.mIndicies.get(indexName);
            if (index == null) {
                index = new IndexObject<T>(indexName, mapFunction);
                this.mIndicies.put(indexName, index);
                index.install();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void recomputeIndex(String indexName) {
        Map<String, IndexObject> map = this.mIndicies;
        synchronized (map) {
            IndexObject index = this.mIndicies.get(indexName);
            if (index != null) {
                index.reindex();
            }
        }
    }

    @Override
    public void deleteIndex(String indexName) {
        this.mMapDB.delete(indexName);
    }

    @Override
    public long incrementLongField(String fieldName) {
        return this.mMapDB.getAtomicLong(fieldName).getAndIncrement();
    }

    @Override
    public void beginTransaction() throws IOException {
    }

    @Override
    public void commitTransaction() throws IOException {
        this.mMapDB.commit();
    }

    @Override
    public void rollbackTransaction() throws IOException {
        this.mMapDB.rollback();
    }

    private static class MapDBEmitter<T extends Comparable<T>>
    implements Emitter<T> {
        ArrayList<T> mKeys = new ArrayList(3);

        private MapDBEmitter() {
        }

        public void clear() {
            this.mKeys.clear();
        }

        @Override
        public void emit(T key) {
            this.mKeys.add(key);
        }

        public T[] getKeys() {
            if (this.mKeys.isEmpty()) {
                return null;
            }
            Comparable[] retval = new Comparable[this.mKeys.size()];
            retval = this.mKeys.toArray(retval);
            return retval;
        }
    }

    private class IndexObject<T extends Comparable<T>> {
        public final String name;
        MapFunction<T> mapFunction;
        private Bind.MapListener mListener;

        public IndexObject(String name, MapFunction<T> mapFunction) {
            this.name = name;
            this.mapFunction = mapFunction;
        }

        void install() {
            if (this.mListener != null) {
                MapDBDriver.this.mObjects.modificationListenerRemove(this.mListener);
            }
            NavigableSet index = MapDBDriver.this.mMapDB.createTreeSet(this.name).makeOrGet();
            Fun.Function2<T[], UUID, UBValue> microDBMapFunction = new Fun.Function2<T[], UUID, UBValue>(){
                final MapDBEmitter<T> mEmitter = new MapDBEmitter();

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public T[] run(UUID uuid, UBValue ubValue) {
                    MapDBEmitter mapDBEmitter = this.mEmitter;
                    synchronized (mapDBEmitter) {
                        this.mEmitter.clear();
                        IndexObject.this.mapFunction.map(ubValue, this.mEmitter);
                        return this.mEmitter.getKeys();
                    }
                }
            };
            this.mListener = this.createIndexListener((Bind.MapWithModificationListener)MapDBDriver.this.mObjects, index, (Fun.Function2)microDBMapFunction);
            MapDBDriver.this.mObjects.modificationListenerAdd(this.mListener);
        }

        void reindex() {
            NavigableSet index = MapDBDriver.this.mMapDB.createTreeSet(this.name).makeOrGet();
            index.clear();
            Fun.Function2<T[], UUID, UBValue> fun = this.createMapDBFunction();
            if (index.isEmpty()) {
                for (Map.Entry e : MapDBDriver.this.mObjects.entrySet()) {
                    Comparable[] k2 = (Comparable[])fun.run(e.getKey(), e.getValue());
                    if (k2 == null) continue;
                    for (Comparable k22 : k2) {
                        index.add(Fun.t2((Object)k22, e.getKey()));
                    }
                }
            }
        }

        private Fun.Function2<T[], UUID, UBValue> createMapDBFunction() {
            return new Fun.Function2<T[], UUID, UBValue>(){
                final MapDBEmitter<T> mEmitter = new MapDBEmitter();

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public T[] run(UUID uuid, UBValue ubValue) {
                    MapDBEmitter mapDBEmitter = this.mEmitter;
                    synchronized (mapDBEmitter) {
                        this.mEmitter.clear();
                        IndexObject.this.mapFunction.map(ubValue, this.mEmitter);
                        return this.mEmitter.getKeys();
                    }
                }
            };
        }

        private <K, V, K2> Bind.MapListener<K, V> createIndexListener(Bind.MapWithModificationListener<K, V> map, final Set<Fun.Tuple2<K2, K>> secondary, final Fun.Function2<K2[], K, V> fun) {
            return new Bind.MapListener<K, V>(){

                public void update(K key, V oldVal, V newVal) {
                    block11: {
                        block12: {
                            block10: {
                                if (newVal != null) break block10;
                                Object[] k2 = (Object[])fun.run(key, oldVal);
                                if (k2 == null) break block11;
                                for (Object k22 : k2) {
                                    secondary.remove(Fun.t2((Object)k22, key));
                                }
                                break block11;
                            }
                            if (oldVal != null) break block12;
                            Object[] k2 = (Object[])fun.run(key, newVal);
                            if (k2 == null) break block11;
                            for (Object k22 : k2) {
                                secondary.add(Fun.t2((Object)k22, key));
                            }
                            break block11;
                        }
                        Object[] oldk = (Object[])fun.run(key, oldVal);
                        Object[] newk = (Object[])fun.run(key, newVal);
                        if (oldk == null) {
                            if (newk != null) {
                                for (Object k22 : newk) {
                                    secondary.add(Fun.t2((Object)k22, key));
                                }
                            }
                            return;
                        }
                        if (newk == null) {
                            for (Object k22 : oldk) {
                                secondary.remove(Fun.t2((Object)k22, key));
                            }
                            return;
                        }
                        HashSet hashes = new HashSet();
                        Collections.addAll(hashes, oldk);
                        for (Object k2 : newk) {
                            if (hashes.contains(k2)) continue;
                            secondary.add(Fun.t2((Object)k2, key));
                        }
                        for (Object k2 : newk) {
                            hashes.remove(k2);
                        }
                        for (Object k2 : hashes) {
                            secondary.remove(Fun.t2(k2, key));
                        }
                    }
                }
            };
        }
    }

    private static class MapDBRow<T extends Comparable<T>>
    implements Row {
        private final MapDBDriver mDriver;
        final Fun.Tuple2<T, UUID> mTuple;
        UBValue mValue;

        public MapDBRow(MapDBDriver driver, Fun.Tuple2<T, UUID> tuple) {
            this.mDriver = driver;
            this.mTuple = tuple;
        }

        @Override
        public UUID getPrimaryKey() {
            return (UUID)this.mTuple.b;
        }

        @Override
        public T getSecondaryKey() {
            return (T)((Comparable)this.mTuple.a);
        }

        @Override
        public UBValue getValue() {
            if (this.mValue == null) {
                try {
                    this.mValue = this.mDriver.get(this.getPrimaryKey());
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            return this.mValue;
        }
    }

    private static class MapDBCursor<T extends Comparable<T>>
    implements Cursor {
        MapDBDriver mDriver;
        NavigableSet<Fun.Tuple2<T, UUID>> index;
        Fun.Tuple2<T, UUID> min;
        Fun.Tuple2<T, UUID> max;
        private Fun.Tuple2<T, UUID> mCurrentValue;
        private int mPosition;

        private MapDBCursor() {
        }

        @Override
        public void seekToBegining() {
            if (!this.index.isEmpty()) {
                this.mCurrentValue = (Fun.Tuple2)this.index.first();
                this.mPosition = 0;
            }
        }

        @Override
        public void seekToEnd() {
            this.mCurrentValue = (Fun.Tuple2)this.index.last();
            this.mPosition = this.getCount();
        }

        @Override
        public int getPosition() {
            return this.mPosition;
        }

        @Override
        public boolean moveToPosition(int pos) {
            int currentPos;
            while ((currentPos = this.getPosition()) != pos) {
                if (currentPos < pos) {
                    this.next();
                    continue;
                }
                this.prev();
            }
            return true;
        }

        @Override
        public boolean next() {
            this.mCurrentValue = this.index.higher(this.mCurrentValue);
            ++this.mPosition;
            return this.mCurrentValue != null;
        }

        @Override
        public boolean prev() {
            this.mCurrentValue = this.index.lower(this.mCurrentValue);
            --this.mPosition;
            return this.mCurrentValue != null;
        }

        @Override
        public Row get() {
            if (this.mCurrentValue == null) {
                return null;
            }
            return new MapDBRow<T>(this.mDriver, this.mCurrentValue);
        }

        @Override
        public int getCount() {
            return this.index.size();
        }
    }

    public static class UBValueSerializer
    implements Serializer<UBValue>,
    Serializable {
        public void serialize(DataOutput out, UBValue value) throws IOException {
            ByteArrayOutputStream bout = new ByteArrayOutputStream();
            UBWriter writer = new UBWriter((OutputStream)bout);
            writer.write(value);
            writer.close();
            byte[] buff = bout.toByteArray();
            out.writeInt(buff.length);
            out.write(buff);
        }

        public UBValue deserialize(DataInput in, int available) throws IOException {
            int size = in.readInt();
            byte[] buff = new byte[size];
            in.readFully(buff);
            UBReader reader = new UBReader((InputStream)new ByteArrayInputStream(buff));
            UBValue retval = reader.read();
            reader.close();
            return retval;
        }

        public int fixedSize() {
            return -1;
        }
    }
}

