/*
 * Decompiled with CFR 0.152.
 */
package com.devsmart.microdb;

import com.devsmart.microdb.ChangeListener;
import com.devsmart.microdb.Cursor;
import com.devsmart.microdb.DBCallback;
import com.devsmart.microdb.DBObject;
import com.devsmart.microdb.Driver;
import com.devsmart.microdb.Emitter;
import com.devsmart.microdb.MapFunction;
import com.devsmart.microdb.Row;
import com.devsmart.ubjson.UBObject;
import com.devsmart.ubjson.UBValue;
import com.devsmart.ubjson.UBValueFactory;
import com.google.common.base.Charsets;
import com.google.common.base.Throwables;
import java.io.IOException;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Queue;
import java.util.UUID;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.atomic.AtomicBoolean;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MicroDB {
    private static final Logger logger = LoggerFactory.getLogger(MicroDB.class);
    private Driver mDriver;
    private int mSchemaVersion;
    private DBCallback mCallback;
    private final HashMap<UUID, WeakReference<DBObject>> mLiveObjects = new HashMap();
    private final WriteQueue mWriteQueue = new WriteQueue();
    private ArrayList<ChangeListener> mChangeListeners = new ArrayList();
    private Map<String, Constructor> mConstructorMap;
    private AtomicBoolean mAutoSave = new AtomicBoolean(true);
    static final MapFunction<String> INDEX_OBJECT_TYPE = new MapFunction<String>(){

        @Override
        public void map(UBValue value, Emitter<String> emitter) {
            UBObject obj;
            UBValue typevar;
            if (value != null && value.isObject() && (typevar = (obj = value.asObject()).get((Object)"type")) != null && typevar.isString()) {
                emitter.emit(typevar.asString());
            }
        }
    };
    private static final String METAKEY_DBVERSION = "schema_version";
    private static final String METAKEY_INSTANCE = "instance";

    protected void finalize() throws Throwable {
        this.mWriteQueue.enqueue(this.createShutdownOperation());
        super.finalize();
    }

    public void shutdown() {
        this.mWriteQueue.enqueue(this.createShutdownOperation());
        try {
            this.mWriteQueue.mWriteThread.join();
        }
        catch (InterruptedException e) {
            logger.warn("", (Throwable)e);
        }
    }

    void enqueueOperation(Operation op) {
        this.mWriteQueue.enqueue(op);
    }

    private Operation createShutdownOperation() {
        return new Operation(OperationType.Shutdown){

            @Override
            void doIt() throws IOException {
            }
        };
    }

    private Operation createNoOp() {
        return new Operation(OperationType.NoOp){

            @Override
            void doIt() throws IOException {
            }
        };
    }

    private Operation createInsertOperation(final DBObject obj) {
        return new Operation(OperationType.Write){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            void doIt() throws IOException {
                UUID id;
                UBObject data = UBValueFactory.createObject();
                DBObject dBObject = obj;
                synchronized (dBObject) {
                    id = obj.getId();
                    obj.beforeWrite();
                    obj.writeToUBObject(data);
                    obj.mDirty = false;
                }
                MicroDB.this.mDriver.insert(id, (UBValue)data);
                for (ChangeListener listener : MicroDB.this.mChangeListeners) {
                    listener.onAfterInsert(MicroDB.this.mDriver, id, (UBValue)data);
                }
            }
        };
    }

    private Operation createWriteObject(final DBObject obj) {
        return new Operation(OperationType.Write){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            void doIt() throws IOException {
                UUID id;
                UBObject data = UBValueFactory.createObject();
                DBObject dBObject = obj;
                synchronized (dBObject) {
                    id = obj.getId();
                    obj.beforeWrite();
                    obj.writeToUBObject(data);
                    obj.mDirty = false;
                }
                for (ChangeListener listener : MicroDB.this.mChangeListeners) {
                    listener.onBeforeUpdate(MicroDB.this.mDriver, id, (UBValue)data);
                }
                MicroDB.this.mDriver.update(id, (UBValue)data);
            }
        };
    }

    private Operation createSaveOperation(final UUID id, final UBValue data) {
        return new Operation(OperationType.Write){

            @Override
            void doIt() throws IOException {
                MicroDB.this.mDriver.update(id, data);
            }
        };
    }

    private Operation createDeleteOperation(final DBObject obj) {
        return new Operation(OperationType.Write){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            void doIt() throws IOException {
                UUID id;
                DBObject dBObject = obj;
                synchronized (dBObject) {
                    id = obj.getId();
                    obj.mDirty = false;
                }
                for (ChangeListener listener : MicroDB.this.mChangeListeners) {
                    listener.onBeforeDelete(MicroDB.this.mDriver, id);
                }
                MicroDB.this.mDriver.delete(id);
            }
        };
    }

    private Operation createCommitOperation() {
        return new Operation(OperationType.Write){

            @Override
            void doIt() throws IOException {
                MicroDB.this.mDriver.commitTransaction();
            }
        };
    }

    public Driver getDriver() {
        return this.mDriver;
    }

    MicroDB(Driver driver, int schemaVersion, DBCallback cb, Map<String, Constructor> constructorMap) throws IOException {
        this.mDriver = driver;
        this.mSchemaVersion = schemaVersion;
        this.mCallback = cb;
        this.mConstructorMap = constructorMap;
        this.mWriteQueue.start();
        this.init();
    }

    private void init() throws IOException {
        this.mDriver.addIndex("type", INDEX_OBJECT_TYPE);
        UBObject metaObj = this.mDriver.getMeta();
        if (!metaObj.containsKey((Object)METAKEY_INSTANCE)) {
            this.mDriver.beginTransaction();
            metaObj.put(METAKEY_INSTANCE, (UBValue)UBValueFactory.createString((String)UUID.randomUUID().toString()));
            metaObj.put(METAKEY_DBVERSION, UBValueFactory.createInt((long)this.mSchemaVersion));
            this.mDriver.saveMeta(metaObj);
            this.mDriver.commitTransaction();
            this.mDriver.beginTransaction();
            this.mCallback.onUpgrade(this, -1, this.mSchemaVersion);
            this.mDriver.commitTransaction();
        } else {
            int currentVersion = metaObj.get((Object)METAKEY_DBVERSION).asInt();
            if (currentVersion < this.mSchemaVersion) {
                this.mDriver.beginTransaction();
                this.mCallback.onUpgrade(this, currentVersion, this.mSchemaVersion);
                metaObj.put(METAKEY_DBVERSION, UBValueFactory.createInt((long)this.mSchemaVersion));
                this.mDriver.saveMeta(metaObj);
                this.mDriver.commitTransaction();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void finalizing(DBObject obj) {
        if (this.mAutoSave.get() && obj.mDirty) {
            this.mWriteQueue.enqueue(this.createWriteObject(obj));
        }
        MicroDB microDB = this;
        synchronized (microDB) {
            this.mLiveObjects.remove(obj.getId());
        }
    }

    public synchronized void close() throws IOException {
        this.flush();
        this.mLiveObjects.clear();
        this.mDriver.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void flush() {
        MicroDB microDB = this;
        synchronized (microDB) {
            for (WeakReference<DBObject> ref : this.mLiveObjects.values()) {
                DBObject obj = (DBObject)ref.get();
                if (obj == null) continue;
                DBObject dBObject = obj;
                synchronized (dBObject) {
                    if (obj.mDirty) {
                        this.mWriteQueue.enqueue(this.createWriteObject(obj));
                    }
                }
            }
        }
        this.sync();
    }

    public synchronized <T extends DBObject> T insert(Class<T> classType) {
        try {
            T retval = this.create(classType);
            UUID key = this.mDriver.genId();
            ((DBObject)retval).setId(key);
            UBObject data = UBValueFactory.createObject();
            ((DBObject)retval).writeToUBObject(data);
            for (ChangeListener l : this.mChangeListeners) {
                l.onBeforeInsert(this.mDriver, (UBValue)data);
            }
            ((DBObject)retval).readFromUBObject(data);
            ((DBObject)retval).setDirty();
            this.mWriteQueue.enqueue(this.createInsertOperation((DBObject)retval));
            this.mLiveObjects.put(key, new WeakReference<T>(retval));
            return retval;
        }
        catch (Exception e) {
            throw new RuntimeException("", e);
        }
    }

    public <T extends DBObject> T create(Class<T> classType) {
        try {
            DBObject retval = (DBObject)classType.newInstance();
            retval.init(this);
            return (T)retval;
        }
        catch (Exception e) {
            Throwables.propagate((Throwable)e);
            return null;
        }
    }

    public synchronized <T extends DBObject> T get(UUID id) {
        try {
            DBObject retval;
            DBObject cached;
            WeakReference<DBObject> ref = this.mLiveObjects.get(id);
            if (ref != null && (cached = (DBObject)ref.get()) != null) {
                retval = cached;
            } else {
                UBValue data = this.mDriver.get(id);
                if (data == null) {
                    return null;
                }
                if (!data.isObject()) {
                    throw new RuntimeException("database entry with id: " + id + " is not an object");
                }
                String dataType = data.asObject().get((Object)"type").asString();
                retval = this.mConstructorMap.get(dataType).build();
                retval.init(this);
                retval.setId(id);
                retval.readFromUBObject(data.asObject());
                retval.afterRead();
                this.mLiveObjects.put(id, new WeakReference<DBObject>(retval));
            }
            return (T)retval;
        }
        catch (Exception e) {
            throw new RuntimeException("", e);
        }
    }

    public synchronized <T extends DBObject> T get(UUID id, T shell) {
        try {
            DBObject retval;
            DBObject cached;
            WeakReference<DBObject> ref = this.mLiveObjects.get(id);
            if (ref != null && (cached = (DBObject)ref.get()) != null) {
                retval = cached;
            } else {
                UBValue data = this.mDriver.get(id);
                if (data == null) {
                    return null;
                }
                if (!data.isObject()) {
                    throw new RuntimeException("database entry with id: " + id + " is not an object");
                }
                shell.init(this);
                shell.setId(id);
                shell.readFromUBObject(data.asObject());
                shell.afterRead();
                retval = shell;
                this.mLiveObjects.put(id, new WeakReference<DBObject>(retval));
            }
            return (T)retval;
        }
        catch (Exception e) {
            throw new RuntimeException("", e);
        }
    }

    public UBValue get(String key) throws IOException {
        UUID id = UUID.nameUUIDFromBytes(key.getBytes(Charsets.UTF_8));
        return this.mDriver.get(id);
    }

    public Operation save(DBObject obj) {
        this.checkValid(obj);
        Operation op = this.createWriteObject(obj);
        this.mWriteQueue.enqueue(op);
        return op;
    }

    public Operation save(String key, UBValue data) {
        UUID id = UUID.nameUUIDFromBytes(key.getBytes(Charsets.UTF_8));
        Operation op = this.createSaveOperation(id, data);
        this.mWriteQueue.enqueue(op);
        return op;
    }

    private void checkValid(DBObject obj) {
        if (obj == null || obj.getDB() != this || obj.getId() == null) {
            throw new RuntimeException("DBObject is invalid. DBObjects must be created with MicroDB.insert() method");
        }
    }

    public synchronized Operation delete(DBObject obj) {
        this.checkValid(obj);
        Operation op = this.createDeleteOperation(obj);
        this.mWriteQueue.enqueue(op);
        this.mLiveObjects.remove(obj.getId());
        return op;
    }

    public Operation commit() {
        Operation op = this.createCommitOperation();
        this.mWriteQueue.enqueue(op);
        return op;
    }

    public void waitForCompletion(Operation op) {
        this.mWriteQueue.kick();
        op.waitForCompletion();
    }

    public void sync() {
        Operation op = this.createCommitOperation();
        this.mWriteQueue.enqueue(op);
        this.waitForCompletion(op);
    }

    public <T extends Comparable<T>> void addIndex(String indexName, MapFunction<T> mapFunction) throws IOException {
        this.mDriver.addIndex(indexName, mapFunction);
    }

    public void addChangeListener(ChangeListener listener) {
        this.mChangeListeners.add(listener);
    }

    public <T extends Comparable<T>> Cursor queryIndex(String indexName, T min, boolean minInclusive, T max, boolean maxInclusive) throws IOException {
        return this.mDriver.queryIndex(indexName, min, minInclusive, max, maxInclusive);
    }

    public <T extends DBObject> Iterable<T> getAllOfType(final Class<T> classType) throws IOException {
        final String className = classType.getSimpleName();
        return new Iterable<T>(){

            @Override
            public Iterator<T> iterator() {
                try {
                    Cursor cursor = MicroDB.this.queryIndex("type", className, true, className, true);
                    return new RowIterator(cursor, MicroDB.this, classType);
                }
                catch (IOException e) {
                    Throwables.propagate((Throwable)e);
                    return null;
                }
            }
        };
    }

    private static class RowIterator<T extends DBObject>
    implements Iterator<T> {
        private final MicroDB mDB;
        private final Class<T> mClassType;
        private Cursor mCursor;
        private Row mCurrentRow;

        public RowIterator(Cursor cursor, MicroDB db, Class<T> classType) {
            this.mCursor = cursor;
            this.mDB = db;
            this.mClassType = classType;
            this.mCurrentRow = this.mCursor.get();
        }

        @Override
        public boolean hasNext() {
            return this.mCurrentRow != null;
        }

        @Override
        public T next() {
            try {
                UUID objId = this.mCurrentRow.getPrimaryKey();
                DBObject retval = this.mDB.get(objId, (DBObject)this.mClassType.newInstance());
                this.mCursor.next();
                this.mCurrentRow = this.mCursor.get();
                return (T)retval;
            }
            catch (Exception e) {
                Throwables.propagate((Throwable)e);
                return null;
            }
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("remove not implemented");
        }
    }

    public static interface Constructor<T extends DBObject> {
        public T build();
    }

    private class WriteQueue
    implements Runnable {
        private static final long DEFAULT_WAIT = 2000L;
        private final Queue<Operation> mOperationQueue = new ConcurrentLinkedQueue<Operation>();
        private Thread mWriteThread = new Thread((Runnable)this, "MicroDB Write Thread");

        private WriteQueue() {
        }

        /*
         * Unable to fully structure code
         */
        @Override
        public void run() {
            block8: while (true) lbl-1000:
            // 6 sources

            {
                if ((op = this.mOperationQueue.poll()) == null) {
                    this.waitForNextCommand();
                    continue;
                }
                try {
                    switch (10.$SwitchMap$com$devsmart$microdb$MicroDB$OperationType[op.mCommandType.ordinal()]) {
                        case 1: {
                            op.run();
                            ** break;
                        }
                        case 2: {
                            ** break;
                        }
                        case 3: {
                            MicroDB.access$200().info("Write Thread exiting");
                            return;
                        }
                        ** default:
lbl16:
                        // 1 sources

                        continue block8;
                    }
                }
                finally {
                    op.complete();
                    continue;
                }
                break;
            }
        }

        private synchronized void waitForNextCommand() {
            try {
                this.wait(2000L);
            }
            catch (InterruptedException e) {
                logger.warn("unexpected interrupt", (Throwable)e);
            }
        }

        public void start() {
            this.mWriteThread.start();
        }

        public void enqueue(Operation op) {
            this.mOperationQueue.offer(op);
        }

        public synchronized void kick() {
            this.notify();
        }
    }

    static abstract class Operation
    implements Runnable {
        public final OperationType mCommandType;
        private Exception mException;
        private boolean mCompleted = false;

        Operation(OperationType type) {
            this.mCommandType = type;
        }

        synchronized void complete() {
            this.mCompleted = true;
            this.notifyAll();
        }

        public synchronized void waitForCompletion() {
            while (!this.mCompleted) {
                try {
                    this.wait(1000L);
                }
                catch (InterruptedException e) {
                    logger.warn("", (Throwable)e);
                }
            }
            if (this.mException != null) {
                Throwables.propagate((Throwable)this.mException);
            }
        }

        abstract void doIt() throws IOException;

        @Override
        public void run() {
            try {
                this.doIt();
            }
            catch (Exception e) {
                logger.error("uncaught exception while performing write operation", (Throwable)e);
                this.mException = e;
            }
        }
    }

    public static enum OperationType {
        Write,
        NoOp,
        Shutdown;

    }
}

