/*
 * Decompiled with CFR 0.152.
 */
package com.devsmart.microdb;

import com.devsmart.microdb.DBObject;
import com.devsmart.microdb.MicroDB;
import com.devsmart.ubjson.UBObject;
import com.devsmart.ubjson.UBString;
import com.devsmart.ubjson.UBValue;
import com.devsmart.ubjson.UBValueFactory;
import java.util.UUID;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Utils {
    private static final Logger LOGGER = LoggerFactory.getLogger(Utils.class);

    public static UBValue writeDBObj(MicroDB db, DBObject obj) {
        if (obj == null) {
            return UBValueFactory.createNull();
        }
        if (db != null && obj.getDB() == db && obj.getId() != null) {
            return UBValueFactory.createString((String)obj.getId().toString());
        }
        obj.beforeWrite();
        UBObject data = UBValueFactory.createObject();
        obj.writeToUBObject(data);
        return data;
    }

    public static <T extends DBObject> T readDBObj(MicroDB db, UBValue value, T shell) {
        if (value == null || value.isNull() || shell == null) {
            return null;
        }
        if (db != null && value.isString()) {
            UUID id = UUID.fromString(value.asString());
            return db.get(id, shell);
        }
        if (value.isObject()) {
            shell.readFromUBObject(value.asObject());
            shell.afterRead();
            return shell;
        }
        LOGGER.warn("value is not an object or a string id");
        return null;
    }

    public static UBValue createArrayOrNull(MicroDB db, DBObject[] input) {
        if (input == null) {
            return UBValueFactory.createNull();
        }
        UBValue[] output = new UBValue[input.length];
        for (int i = 0; i < input.length; ++i) {
            output[i] = Utils.writeDBObj(db, input[i]);
        }
        return UBValueFactory.createArray((UBValue[])output);
    }

    public static boolean isValidObject(UBValue value, UBString ... types) {
        if (value != null && value.isObject()) {
            UBValue typeStr = value.asObject().get((Object)"type");
            if (typeStr == null || !typeStr.isString()) {
                return false;
            }
            for (int i = 0; i < types.length; ++i) {
                if (!types[i].equals((Object)typeStr)) continue;
                return true;
            }
        }
        return false;
    }
}

