/*
 * Decompiled with CFR 0.152.
 */
package com.devsmart.microdb;

import com.devsmart.microdb.ChangeListener;
import com.devsmart.microdb.Driver;
import com.devsmart.microdb.MapDBDriver;
import com.devsmart.microdb.MicroDB;
import com.devsmart.microdb.version.Change;
import com.devsmart.microdb.version.Commit;
import com.devsmart.ubjson.UBObject;
import com.devsmart.ubjson.UBValue;
import com.devsmart.ubjson.UBValueFactory;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.UUID;
import org.mapdb.Atomic;
import org.mapdb.BTreeKeySerializer;
import org.mapdb.BTreeMap;
import org.mapdb.Fun;
import org.mapdb.Serializer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VersionManager {
    private static final Logger logger = LoggerFactory.getLogger(VersionManager.class);
    private final MicroDB mMicroDB;
    private final MapDBDriver mMapDBDriver;
    private final Atomic.Var<UBObject> mMetadata;
    private final BTreeMap<Fun.Tuple2<UUID, UUID>, Change> mDiffs;
    private final BTreeMap<UUID, Commit> mCommits;
    private Commit mCurrentVersion;
    private ChangeListener mChangeListener = new ChangeListener(){

        @Override
        public void onAfterInsert(Driver driver, UUID key, UBValue value) {
            VersionManager.this.addInsertChange(VersionManager.this.mCurrentVersion.getId(), key, value);
        }

        @Override
        public void onBeforeInsert(Driver driver, UBValue value) {
        }

        @Override
        public void onBeforeDelete(Driver driver, UUID key) {
            VersionManager.this.addDeleteChange(VersionManager.this.mCurrentVersion.getId(), key);
        }

        @Override
        public void onBeforeUpdate(Driver driver, UUID key, UBValue newValue) {
            VersionManager.this.addInsertChange(VersionManager.this.mCurrentVersion.getId(), key, newValue);
        }
    };

    public VersionManager(MicroDB microDB, MapDBDriver mapdbdriver) {
        this.mMicroDB = microDB;
        this.mMapDBDriver = mapdbdriver;
        this.mMetadata = this.mMapDBDriver.mMetadata;
        this.mDiffs = this.mMapDBDriver.mMapDB.createTreeMap("diffs").keySerializer((BTreeKeySerializer)new BTreeKeySerializer.Tuple2KeySerializer(Fun.COMPARATOR, Serializer.UUID, Serializer.UUID)).valueSerializer(Change.SERIALIZER).makeOrGet();
        this.mCommits = this.mMapDBDriver.mMapDB.createTreeMap("commits").keySerializerWrap(Serializer.UUID).valueSerializer(Commit.SERIALIZER).makeOrGet();
        UBObject metadata = (UBObject)this.mMetadata.get();
        UBValue currentVersionStr = metadata.get((Object)"currentVersion");
        if (currentVersionStr == null || !currentVersionStr.isString()) {
            this.mCurrentVersion = Commit.newRoot();
            this.mCommits.put((Object)this.mCurrentVersion.getId(), (Object)this.mCurrentVersion);
            metadata.put("currentVersion", (UBValue)UBValueFactory.createString((String)this.mCurrentVersion.toString()));
            this.mMetadata.set((Object)metadata);
        } else {
            UUID commitId = UUID.fromString(currentVersionStr.asString());
            this.mCurrentVersion = (Commit)this.mCommits.get((Object)commitId);
        }
        if (this.mCurrentVersion == null) {
            throw new RuntimeException("currentVersion is null");
        }
        microDB.addChangeListener(this.mChangeListener);
    }

    public void addInsertChange(UUID patch, UUID objId, UBValue newValue) {
        this.mDiffs.put((Object)Fun.t2((Object)patch, (Object)objId), (Object)Change.createInsertChange(objId, newValue));
    }

    public void addDeleteChange(UUID patch, UUID objId) {
        Fun.Tuple2 key = Fun.t2((Object)patch, (Object)objId);
        if (this.mDiffs.remove((Object)key) == null) {
            this.mDiffs.put((Object)key, (Object)Change.createDeleteChange(objId));
        }
    }

    public UUID commit() {
        final UUID newCommitId = UUID.randomUUID();
        this.mMicroDB.enqueueOperation(new MicroDB.Operation(MicroDB.OperationType.Write){

            @Override
            void doIt() throws IOException {
                logger.info("commit");
                VersionManager.this.mCurrentVersion = Commit.withParentAndId(VersionManager.this.mCurrentVersion, newCommitId);
                VersionManager.this.mCommits.put((Object)VersionManager.this.mCurrentVersion.getId(), (Object)VersionManager.this.mCurrentVersion);
                VersionManager.this.setHEAD(VersionManager.this.mCurrentVersion.getId());
            }
        });
        return newCommitId;
    }

    private void setHEAD(UUID commitID) {
        logger.info("HEAD is now: " + commitID);
        UBObject metadata = (UBObject)this.mMetadata.get();
        metadata.put("currentVersion", (UBValue)UBValueFactory.createString((String)commitID.toString()));
        this.mMetadata.set((Object)metadata);
    }

    public boolean isDirty() {
        UUID currentVersion = this.mCurrentVersion.getId();
        Fun.Tuple2 key = (Fun.Tuple2)this.mDiffs.ceilingKey((Object)Fun.t2((Object)currentVersion, (Object)null));
        if (key != null) {
            return ((UUID)key.a).equals(currentVersion);
        }
        return false;
    }

    public Commit getHead() {
        return this.mCurrentVersion;
    }

    public Iterable<Change> getChanges(UUID commit) {
        return this.mDiffs.subMap((Fun.Tuple2)Fun.t2((Object)commit, null), (Fun.Tuple2)Fun.t2((Object)commit, (Object)Fun.HI())).values();
    }

    public void addChanges(UUID commit, Iterable<Change> changes) {
        logger.info("adding diff for " + commit);
        for (Change c : changes) {
            Fun.Tuple2 key = Fun.t2((Object)commit, (Object)c.getObjId());
            this.mDiffs.put((Object)key, (Object)c);
        }
    }

    public void addCommit(Commit commit) {
        this.mCommits.put((Object)commit.getId(), (Object)commit);
    }

    public void moveTo(final UUID dest) throws IOException {
        this.mMicroDB.enqueueOperation(new MicroDB.Operation(MicroDB.OperationType.Write){

            @Override
            void doIt() throws IOException {
                Commit commit;
                logger.info("begining move to dest");
                if (VersionManager.this.isDirty()) {
                    logger.error("cannot move to " + dest + ". Dirty HEAD");
                    return;
                }
                UUID head = VersionManager.this.getHead().getId();
                ArrayList<Commit> commits = new ArrayList<Commit>();
                UUID currentCommit = dest;
                while ((commit = (Commit)VersionManager.this.mCommits.get((Object)currentCommit)) != null && !commit.getId().equals(head)) {
                    commits.add(commit);
                    currentCommit = commit.getParent();
                }
                if (commit == null || !commit.getId().equals(head)) {
                    logger.error("no commit path to " + dest + " found");
                    return;
                }
                for (int i = commits.size() - 1; i >= 0; --i) {
                    commit = (Commit)commits.get(i);
                    logger.info("applying commit " + commit);
                    for (Change c : VersionManager.this.getChanges(commit.getId())) {
                        c.apply(VersionManager.this.mMapDBDriver);
                    }
                }
                assert (commit.getId().equals(dest));
                VersionManager.this.mCurrentVersion = commit;
                VersionManager.this.setHEAD(commit.getId());
            }
        });
    }

    private static class DiffKey
    implements Comparable<DiffKey> {
        public static final Serializer<DiffKey> SERIALIZER = new DiffKeySerializer();
        public final UUID patchId;
        public final UUID objKey;

        public DiffKey(UUID patchId, UUID objId) {
            this.patchId = patchId;
            this.objKey = objId;
        }

        @Override
        public int compareTo(DiffKey o) {
            int retval = this.patchId.compareTo(o.patchId);
            if (retval == 0) {
                if (this.objKey != null && o.objKey != null) {
                    retval = this.objKey.compareTo(o.objKey);
                } else if (this.objKey == null && o.objKey == null) {
                    retval = 0;
                } else if (this.objKey == null) {
                    retval = -1;
                } else {
                    return 1;
                }
            }
            return retval;
        }

        public static class DiffKeySerializer
        implements Serializer<DiffKey>,
        Serializable {
            public void serialize(DataOutput out, DiffKey value) throws IOException {
                Serializer.UUID.serialize(out, (Object)value.patchId);
                Serializer.UUID.serialize(out, (Object)value.objKey);
            }

            public DiffKey deserialize(DataInput in, int available) throws IOException {
                UUID patchId = (UUID)Serializer.UUID.deserialize(in, available);
                UUID objKey = (UUID)Serializer.UUID.deserialize(in, available);
                return new DiffKey(patchId, objKey);
            }

            public int fixedSize() {
                return 32;
            }
        }
    }
}

