/*
 * Decompiled with CFR 0.152.
 */
package com.devsmart.microdb.version;

import com.devsmart.microdb.Driver;
import com.devsmart.microdb.MapDBDriver;
import com.devsmart.ubjson.UBObject;
import com.devsmart.ubjson.UBValue;
import com.devsmart.ubjson.UBValueFactory;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.io.Serializable;
import java.util.UUID;
import org.mapdb.Serializer;

public class Change {
    public static final byte TYPE_INSERT = 0;
    public static final byte TYPE_DELETE = 1;
    public static final Serializer<Change> SERIALIZER = new ChangeSerializer();
    private byte mType;
    private UUID mObjId;
    private UBValue mValue;

    public static Change createDeleteChange(UUID key) {
        Change retval = new Change();
        retval.mType = 1;
        retval.mObjId = key;
        retval.mValue = UBValueFactory.createNull();
        return retval;
    }

    public static Change createInsertChange(UUID key, UBValue newValue) {
        Change retval = new Change();
        retval.mType = 0;
        retval.mObjId = key;
        retval.mValue = newValue;
        return retval;
    }

    public static Change parse(UBObject obj) {
        Change retval = new Change();
        retval.mType = obj.get((Object)"t").asByte();
        retval.mObjId = UUID.fromString(obj.get((Object)"k").asString());
        retval.mValue = obj.get((Object)"v");
        return retval;
    }

    public byte getType() {
        return this.mType;
    }

    public UUID getObjId() {
        return this.mObjId;
    }

    public UBValue getObjValue() {
        return this.mValue;
    }

    public void apply(Driver driver) throws IOException {
        switch (this.mType) {
            case 1: {
                driver.delete(this.mObjId);
                break;
            }
            case 0: {
                driver.update(this.mObjId, this.mValue);
                break;
            }
            default: {
                throw new RuntimeException("unknown change type: " + this.mType);
            }
        }
    }

    public String toString() {
        String retval = (this.mType == 0 ? "+" : "-") + this.mObjId.toString().substring(0, 5);
        return retval;
    }

    public static final class ChangeSerializer
    implements Serializer<Change>,
    Serializable {
        public void serialize(DataOutput out, Change value) throws IOException {
            out.writeByte(value.mType);
            Serializer.UUID.serialize(out, (Object)value.mObjId);
            MapDBDriver.SERIALIZER_UBVALUE.serialize(out, (Object)value.mValue);
        }

        public Change deserialize(DataInput in, int available) throws IOException {
            Change retval = new Change();
            retval.mType = in.readByte();
            retval.mObjId = (UUID)Serializer.UUID.deserialize(in, available);
            retval.mValue = (UBValue)MapDBDriver.SERIALIZER_UBVALUE.deserialize(in, available);
            return retval;
        }

        public int fixedSize() {
            return -1;
        }
    }
}

