/*
 * Decompiled with CFR 0.152.
 */
package com.devsmart.microdb.version;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.io.Serializable;
import java.util.Date;
import java.util.UUID;
import org.mapdb.Serializer;

public class Commit {
    private UUID mId;
    private UUID mParent;
    private Date mDate;
    private String mMessage;
    public static final Serializer<Commit> SERIALIZER = new CommitSerializer();

    private Commit() {
    }

    public static Commit newRoot() {
        Commit retval = new Commit();
        retval.mId = new UUID(0L, 0L);
        retval.mParent = new UUID(0L, 0L);
        retval.mDate = new Date();
        return retval;
    }

    public static Commit withParent(Commit parent) {
        return Commit.withParent(parent.getId());
    }

    public static Commit withParent(UUID parent) {
        return Commit.withParentAndId(parent, UUID.randomUUID());
    }

    public static Commit withParentAndId(Commit parent, UUID commitId) {
        return Commit.withParentAndId(parent.getId(), commitId);
    }

    public static Commit withParentAndId(UUID parent, UUID commitId) {
        Commit retval = new Commit();
        retval.mId = commitId;
        retval.mParent = parent;
        retval.mDate = new Date();
        return retval;
    }

    public UUID getParent() {
        return this.mParent;
    }

    public UUID getId() {
        return this.mId;
    }

    public static class CommitSerializer
    implements Serializer<Commit>,
    Serializable {
        public void serialize(DataOutput out, Commit value) throws IOException {
            Serializer.UUID.serialize(out, (Object)value.mId);
            Serializer.UUID.serialize(out, (Object)value.mParent);
        }

        public Commit deserialize(DataInput in, int available) throws IOException {
            Commit retval = new Commit();
            retval.mId = (UUID)Serializer.UUID.deserialize(in, available);
            retval.mParent = (UUID)Serializer.UUID.deserialize(in, available);
            return retval;
        }

        public int fixedSize() {
            return -1;
        }
    }
}

