/*
 * Decompiled with CFR 0.152.
 */
package com.devcycle.sdk.server.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import io.swagger.v3.oas.annotations.media.Schema;

public class User {
    @Schema(required=true, description="Unique id to identify the user")
    @JsonProperty(value="user_id")
    private String userId;
    @Schema(description="User's email used to identify the user on the dashboard / target audiences")
    private String email;
    @Schema(description="User's name used to identify the user on the dashboard / target audiences")
    private String name;
    @Schema(description="User's language in ISO 639-1 format")
    private String language;
    @Schema(description="User's country in ISO 3166 alpha-2 format")
    private String country;
    @Schema(description="App Version of the running application")
    private String appVersion;
    @Schema(description="App Build number of the running application")
    private String appBuild;
    @Schema(description="User's custom data to target the user with, data will be logged to DevCycle for use in dashboard.")
    private Object customData;
    @Schema(description="User's custom data to target the user with, data will not be logged to DevCycle only used for feature bucketing.")
    private Object privateCustomData;
    @Schema(description="Date the user was created, Unix epoch timestamp format")
    private Long createdDate;
    @Schema(description="Date the user was last seen, Unix epoch timestamp format")
    private Long lastSeenDate;
    @Schema(description="Platform the Client SDK is running on")
    private String platform;
    @Schema(description="Version of the platform the Client SDK is running on")
    private String platformVersion;
    @Schema(description="User's device model")
    private String deviceModel;
    @Schema(description="DevCycle SDK type")
    private SdkTypeEnum sdkType;
    @Schema(description="DevCycle SDK Version")
    private String sdkVersion;

    User(String userId, String email, String name, String language, String country, String appVersion, String appBuild, Object customData, Object privateCustomData, Long createdDate, Long lastSeenDate, String platform, String platformVersion, String deviceModel, SdkTypeEnum sdkType, String sdkVersion) {
        this.userId = userId;
        this.email = email;
        this.name = name;
        this.language = language;
        this.country = country;
        this.appVersion = appVersion;
        this.appBuild = appBuild;
        this.customData = customData;
        this.privateCustomData = privateCustomData;
        this.createdDate = createdDate;
        this.lastSeenDate = lastSeenDate;
        this.platform = platform;
        this.platformVersion = platformVersion;
        this.deviceModel = deviceModel;
        this.sdkType = sdkType;
        this.sdkVersion = sdkVersion;
    }

    public static UserBuilder builder() {
        return new UserBuilder();
    }

    public String getUserId() {
        return this.userId;
    }

    public String getEmail() {
        return this.email;
    }

    public String getName() {
        return this.name;
    }

    public String getLanguage() {
        return this.language;
    }

    public String getCountry() {
        return this.country;
    }

    public String getAppVersion() {
        return this.appVersion;
    }

    public String getAppBuild() {
        return this.appBuild;
    }

    public Object getCustomData() {
        return this.customData;
    }

    public Object getPrivateCustomData() {
        return this.privateCustomData;
    }

    public Long getCreatedDate() {
        return this.createdDate;
    }

    public Long getLastSeenDate() {
        return this.lastSeenDate;
    }

    public String getPlatform() {
        return this.platform;
    }

    public String getPlatformVersion() {
        return this.platformVersion;
    }

    public String getDeviceModel() {
        return this.deviceModel;
    }

    public SdkTypeEnum getSdkType() {
        return this.sdkType;
    }

    public String getSdkVersion() {
        return this.sdkVersion;
    }

    @JsonProperty(value="user_id")
    public void setUserId(String userId) {
        this.userId = userId;
    }

    public void setEmail(String email) {
        this.email = email;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setLanguage(String language) {
        this.language = language;
    }

    public void setCountry(String country) {
        this.country = country;
    }

    public void setAppVersion(String appVersion) {
        this.appVersion = appVersion;
    }

    public void setAppBuild(String appBuild) {
        this.appBuild = appBuild;
    }

    public void setCustomData(Object customData) {
        this.customData = customData;
    }

    public void setPrivateCustomData(Object privateCustomData) {
        this.privateCustomData = privateCustomData;
    }

    public void setCreatedDate(Long createdDate) {
        this.createdDate = createdDate;
    }

    public void setLastSeenDate(Long lastSeenDate) {
        this.lastSeenDate = lastSeenDate;
    }

    public void setPlatform(String platform) {
        this.platform = platform;
    }

    public void setPlatformVersion(String platformVersion) {
        this.platformVersion = platformVersion;
    }

    public void setDeviceModel(String deviceModel) {
        this.deviceModel = deviceModel;
    }

    public void setSdkType(SdkTypeEnum sdkType) {
        this.sdkType = sdkType;
    }

    public void setSdkVersion(String sdkVersion) {
        this.sdkVersion = sdkVersion;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof User)) {
            return false;
        }
        User other = (User)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Long this$createdDate = this.getCreatedDate();
        Long other$createdDate = other.getCreatedDate();
        if (this$createdDate == null ? other$createdDate != null : !((Object)this$createdDate).equals(other$createdDate)) {
            return false;
        }
        Long this$lastSeenDate = this.getLastSeenDate();
        Long other$lastSeenDate = other.getLastSeenDate();
        if (this$lastSeenDate == null ? other$lastSeenDate != null : !((Object)this$lastSeenDate).equals(other$lastSeenDate)) {
            return false;
        }
        String this$userId = this.getUserId();
        String other$userId = other.getUserId();
        if (this$userId == null ? other$userId != null : !this$userId.equals(other$userId)) {
            return false;
        }
        String this$email = this.getEmail();
        String other$email = other.getEmail();
        if (this$email == null ? other$email != null : !this$email.equals(other$email)) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        String this$language = this.getLanguage();
        String other$language = other.getLanguage();
        if (this$language == null ? other$language != null : !this$language.equals(other$language)) {
            return false;
        }
        String this$country = this.getCountry();
        String other$country = other.getCountry();
        if (this$country == null ? other$country != null : !this$country.equals(other$country)) {
            return false;
        }
        String this$appVersion = this.getAppVersion();
        String other$appVersion = other.getAppVersion();
        if (this$appVersion == null ? other$appVersion != null : !this$appVersion.equals(other$appVersion)) {
            return false;
        }
        String this$appBuild = this.getAppBuild();
        String other$appBuild = other.getAppBuild();
        if (this$appBuild == null ? other$appBuild != null : !this$appBuild.equals(other$appBuild)) {
            return false;
        }
        Object this$customData = this.getCustomData();
        Object other$customData = other.getCustomData();
        if (this$customData == null ? other$customData != null : !this$customData.equals(other$customData)) {
            return false;
        }
        Object this$privateCustomData = this.getPrivateCustomData();
        Object other$privateCustomData = other.getPrivateCustomData();
        if (this$privateCustomData == null ? other$privateCustomData != null : !this$privateCustomData.equals(other$privateCustomData)) {
            return false;
        }
        String this$platform = this.getPlatform();
        String other$platform = other.getPlatform();
        if (this$platform == null ? other$platform != null : !this$platform.equals(other$platform)) {
            return false;
        }
        String this$platformVersion = this.getPlatformVersion();
        String other$platformVersion = other.getPlatformVersion();
        if (this$platformVersion == null ? other$platformVersion != null : !this$platformVersion.equals(other$platformVersion)) {
            return false;
        }
        String this$deviceModel = this.getDeviceModel();
        String other$deviceModel = other.getDeviceModel();
        if (this$deviceModel == null ? other$deviceModel != null : !this$deviceModel.equals(other$deviceModel)) {
            return false;
        }
        SdkTypeEnum this$sdkType = this.getSdkType();
        SdkTypeEnum other$sdkType = other.getSdkType();
        if (this$sdkType == null ? other$sdkType != null : !((Object)((Object)this$sdkType)).equals((Object)other$sdkType)) {
            return false;
        }
        String this$sdkVersion = this.getSdkVersion();
        String other$sdkVersion = other.getSdkVersion();
        return !(this$sdkVersion == null ? other$sdkVersion != null : !this$sdkVersion.equals(other$sdkVersion));
    }

    protected boolean canEqual(Object other) {
        return other instanceof User;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Long $createdDate = this.getCreatedDate();
        result = result * 59 + ($createdDate == null ? 43 : ((Object)$createdDate).hashCode());
        Long $lastSeenDate = this.getLastSeenDate();
        result = result * 59 + ($lastSeenDate == null ? 43 : ((Object)$lastSeenDate).hashCode());
        String $userId = this.getUserId();
        result = result * 59 + ($userId == null ? 43 : $userId.hashCode());
        String $email = this.getEmail();
        result = result * 59 + ($email == null ? 43 : $email.hashCode());
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        String $language = this.getLanguage();
        result = result * 59 + ($language == null ? 43 : $language.hashCode());
        String $country = this.getCountry();
        result = result * 59 + ($country == null ? 43 : $country.hashCode());
        String $appVersion = this.getAppVersion();
        result = result * 59 + ($appVersion == null ? 43 : $appVersion.hashCode());
        String $appBuild = this.getAppBuild();
        result = result * 59 + ($appBuild == null ? 43 : $appBuild.hashCode());
        Object $customData = this.getCustomData();
        result = result * 59 + ($customData == null ? 43 : $customData.hashCode());
        Object $privateCustomData = this.getPrivateCustomData();
        result = result * 59 + ($privateCustomData == null ? 43 : $privateCustomData.hashCode());
        String $platform = this.getPlatform();
        result = result * 59 + ($platform == null ? 43 : $platform.hashCode());
        String $platformVersion = this.getPlatformVersion();
        result = result * 59 + ($platformVersion == null ? 43 : $platformVersion.hashCode());
        String $deviceModel = this.getDeviceModel();
        result = result * 59 + ($deviceModel == null ? 43 : $deviceModel.hashCode());
        SdkTypeEnum $sdkType = this.getSdkType();
        result = result * 59 + ($sdkType == null ? 43 : ((Object)((Object)$sdkType)).hashCode());
        String $sdkVersion = this.getSdkVersion();
        result = result * 59 + ($sdkVersion == null ? 43 : $sdkVersion.hashCode());
        return result;
    }

    public String toString() {
        return "User(userId=" + this.getUserId() + ", email=" + this.getEmail() + ", name=" + this.getName() + ", language=" + this.getLanguage() + ", country=" + this.getCountry() + ", appVersion=" + this.getAppVersion() + ", appBuild=" + this.getAppBuild() + ", customData=" + this.getCustomData() + ", privateCustomData=" + this.getPrivateCustomData() + ", createdDate=" + this.getCreatedDate() + ", lastSeenDate=" + this.getLastSeenDate() + ", platform=" + this.getPlatform() + ", platformVersion=" + this.getPlatformVersion() + ", deviceModel=" + this.getDeviceModel() + ", sdkType=" + (Object)((Object)this.getSdkType()) + ", sdkVersion=" + this.getSdkVersion() + ")";
    }

    public static class UserBuilder {
        private String userId;
        private String email;
        private String name;
        private String language;
        private String country;
        private String appVersion;
        private String appBuild;
        private Object customData;
        private Object privateCustomData;
        private Long createdDate;
        private Long lastSeenDate;
        private String platform;
        private String platformVersion;
        private String deviceModel;
        private SdkTypeEnum sdkType;
        private String sdkVersion;

        UserBuilder() {
        }

        @JsonProperty(value="user_id")
        public UserBuilder userId(String userId) {
            this.userId = userId;
            return this;
        }

        public UserBuilder email(String email) {
            this.email = email;
            return this;
        }

        public UserBuilder name(String name) {
            this.name = name;
            return this;
        }

        public UserBuilder language(String language) {
            this.language = language;
            return this;
        }

        public UserBuilder country(String country) {
            this.country = country;
            return this;
        }

        public UserBuilder appVersion(String appVersion) {
            this.appVersion = appVersion;
            return this;
        }

        public UserBuilder appBuild(String appBuild) {
            this.appBuild = appBuild;
            return this;
        }

        public UserBuilder customData(Object customData) {
            this.customData = customData;
            return this;
        }

        public UserBuilder privateCustomData(Object privateCustomData) {
            this.privateCustomData = privateCustomData;
            return this;
        }

        public UserBuilder createdDate(Long createdDate) {
            this.createdDate = createdDate;
            return this;
        }

        public UserBuilder lastSeenDate(Long lastSeenDate) {
            this.lastSeenDate = lastSeenDate;
            return this;
        }

        public UserBuilder platform(String platform) {
            this.platform = platform;
            return this;
        }

        public UserBuilder platformVersion(String platformVersion) {
            this.platformVersion = platformVersion;
            return this;
        }

        public UserBuilder deviceModel(String deviceModel) {
            this.deviceModel = deviceModel;
            return this;
        }

        public UserBuilder sdkType(SdkTypeEnum sdkType) {
            this.sdkType = sdkType;
            return this;
        }

        public UserBuilder sdkVersion(String sdkVersion) {
            this.sdkVersion = sdkVersion;
            return this;
        }

        public User build() {
            return new User(this.userId, this.email, this.name, this.language, this.country, this.appVersion, this.appBuild, this.customData, this.privateCustomData, this.createdDate, this.lastSeenDate, this.platform, this.platformVersion, this.deviceModel, this.sdkType, this.sdkVersion);
        }

        public String toString() {
            return "User.UserBuilder(userId=" + this.userId + ", email=" + this.email + ", name=" + this.name + ", language=" + this.language + ", country=" + this.country + ", appVersion=" + this.appVersion + ", appBuild=" + this.appBuild + ", customData=" + this.customData + ", privateCustomData=" + this.privateCustomData + ", createdDate=" + this.createdDate + ", lastSeenDate=" + this.lastSeenDate + ", platform=" + this.platform + ", platformVersion=" + this.platformVersion + ", deviceModel=" + this.deviceModel + ", sdkType=" + (Object)((Object)this.sdkType) + ", sdkVersion=" + this.sdkVersion + ")";
        }
    }

    public static enum SdkTypeEnum {
        API("api"),
        SERVER("server");

        private final String value;

        private SdkTypeEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static SdkTypeEnum fromValue(String text) {
            for (SdkTypeEnum b : SdkTypeEnum.values()) {
                if (!String.valueOf(b.value).equals(text)) continue;
                return b;
            }
            return null;
        }
    }
}

