/*
 * Decompiled with CFR 0.152.
 */
package com.devcycle.sdk.server.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import io.swagger.v3.oas.annotations.media.Schema;

public class Variable {
    @Schema(required=true, description="unique database id")
    @JsonProperty(value="_id")
    private String id;
    @Schema(required=true, description="Unique key by Project, can be used in the SDK / API to reference by 'key' rather than _id.")
    private String key;
    @Schema(required=true, description="Variable value can be a string, number, boolean, or JSON")
    private Object value;
    @Schema(required=true, description="Variable type")
    private TypeEnum type;

    public static VariableBuilder builder() {
        return new VariableBuilder();
    }

    public String getId() {
        return this.id;
    }

    public String getKey() {
        return this.key;
    }

    public Object getValue() {
        return this.value;
    }

    public TypeEnum getType() {
        return this.type;
    }

    @JsonProperty(value="_id")
    public void setId(String id) {
        this.id = id;
    }

    public void setKey(String key) {
        this.key = key;
    }

    public void setValue(Object value) {
        this.value = value;
    }

    public void setType(TypeEnum type) {
        this.type = type;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Variable)) {
            return false;
        }
        Variable other = (Variable)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$id = this.getId();
        String other$id = other.getId();
        if (this$id == null ? other$id != null : !this$id.equals(other$id)) {
            return false;
        }
        String this$key = this.getKey();
        String other$key = other.getKey();
        if (this$key == null ? other$key != null : !this$key.equals(other$key)) {
            return false;
        }
        Object this$value = this.getValue();
        Object other$value = other.getValue();
        if (this$value == null ? other$value != null : !this$value.equals(other$value)) {
            return false;
        }
        TypeEnum this$type = this.getType();
        TypeEnum other$type = other.getType();
        return !(this$type == null ? other$type != null : !((Object)((Object)this$type)).equals((Object)other$type));
    }

    protected boolean canEqual(Object other) {
        return other instanceof Variable;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $id = this.getId();
        result = result * 59 + ($id == null ? 43 : $id.hashCode());
        String $key = this.getKey();
        result = result * 59 + ($key == null ? 43 : $key.hashCode());
        Object $value = this.getValue();
        result = result * 59 + ($value == null ? 43 : $value.hashCode());
        TypeEnum $type = this.getType();
        result = result * 59 + ($type == null ? 43 : ((Object)((Object)$type)).hashCode());
        return result;
    }

    public String toString() {
        return "Variable(id=" + this.getId() + ", key=" + this.getKey() + ", value=" + this.getValue() + ", type=" + (Object)((Object)this.getType()) + ")";
    }

    public Variable(String id, String key, Object value, TypeEnum type) {
        this.id = id;
        this.key = key;
        this.value = value;
        this.type = type;
    }

    public Variable() {
    }

    public static class VariableBuilder {
        private String id;
        private String key;
        private Object value;
        private TypeEnum type;

        VariableBuilder() {
        }

        @JsonProperty(value="_id")
        public VariableBuilder id(String id) {
            this.id = id;
            return this;
        }

        public VariableBuilder key(String key) {
            this.key = key;
            return this;
        }

        public VariableBuilder value(Object value) {
            this.value = value;
            return this;
        }

        public VariableBuilder type(TypeEnum type) {
            this.type = type;
            return this;
        }

        public Variable build() {
            return new Variable(this.id, this.key, this.value, this.type);
        }

        public String toString() {
            return "Variable.VariableBuilder(id=" + this.id + ", key=" + this.key + ", value=" + this.value + ", type=" + (Object)((Object)this.type) + ")";
        }
    }

    public static enum TypeEnum {
        STRING("String"),
        BOOLEAN("Boolean"),
        NUMBER("Number"),
        JSON("JSON");

        private final String value;

        private TypeEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static TypeEnum fromValue(String text) {
            for (TypeEnum b : TypeEnum.values()) {
                if (!String.valueOf(b.value).equals(text)) continue;
                return b;
            }
            return null;
        }
    }
}

