/*
 * Decompiled with CFR 0.152.
 */
package com.devcycle.sdk.server.api;

import com.devcycle.sdk.server.api.DVCApi;
import com.devcycle.sdk.server.api.DVCApiClient;
import com.devcycle.sdk.server.exception.DVCException;
import com.devcycle.sdk.server.model.DVCOptions;
import com.devcycle.sdk.server.model.DVCResponse;
import com.devcycle.sdk.server.model.ErrorResponse;
import com.devcycle.sdk.server.model.Event;
import com.devcycle.sdk.server.model.Feature;
import com.devcycle.sdk.server.model.HttpResponseCode;
import com.devcycle.sdk.server.model.User;
import com.devcycle.sdk.server.model.UserAndEvents;
import com.devcycle.sdk.server.model.Variable;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import retrofit2.Call;
import retrofit2.Response;

public final class DVCClient {
    private final DVCApi api;
    private final DVCOptions dvcOptions;
    private static final String DEFAULT_PLATFORM = "Java";
    private static final String DEFAULT_PLATFORM_VERSION = System.getProperty("java.version");
    private static final User.SdkTypeEnum DEFAULT_SDK_TYPE = User.SdkTypeEnum.SERVER;
    private final String DEFAULT_SDK_VERSION;
    private static final ObjectMapper OBJECT_MAPPER = new ObjectMapper();

    public DVCClient(String serverKey) {
        this(serverKey, DVCOptions.builder().build());
    }

    public DVCClient(String serverKey, DVCOptions dvcOptions) {
        this.api = new DVCApiClient(serverKey).initialize();
        this.dvcOptions = dvcOptions;
        OBJECT_MAPPER.setSerializationInclusion(JsonInclude.Include.NON_NULL);
        this.DEFAULT_SDK_VERSION = "1.0.6";
    }

    public Map<String, Feature> allFeatures(User user) throws DVCException {
        this.validateUser(user);
        this.addDefaults(user);
        Call<Map<String, Feature>> response = this.api.getFeatures(user, this.dvcOptions.getEnableEdgeDB());
        return this.getResponse(response);
    }

    public <T> Variable<T> variable(User user, String key, T defaultValue) {
        Variable variable;
        this.validateUser(user);
        if (key == null || key.equals("")) {
            throw new IllegalArgumentException("key cannot be null or empty");
        }
        if (defaultValue == null) {
            throw new IllegalArgumentException("defaultValue cannot be null");
        }
        this.addDefaults(user);
        try {
            Call<Variable> response = this.api.getVariableByKey(user, key, this.dvcOptions.getEnableEdgeDB());
            variable = this.getResponse(response);
        }
        catch (Exception exception) {
            variable = Variable.builder().key(key).value(defaultValue).isDefaulted(true).reasonUsingDefaultValue(exception.getMessage()).build();
        }
        return variable;
    }

    public Map<String, Variable> allVariables(User user) throws DVCException {
        this.validateUser(user);
        this.addDefaults(user);
        Call<Map<String, Variable>> response = this.api.getVariables(user, this.dvcOptions.getEnableEdgeDB());
        return this.getResponse(response);
    }

    public DVCResponse track(User user, Event event) throws DVCException {
        this.validateUser(user);
        this.addDefaults(user);
        UserAndEvents userAndEvents = UserAndEvents.builder().user(user).events(Collections.singletonList(event)).build();
        Call<DVCResponse> response = this.api.track(userAndEvents, this.dvcOptions.getEnableEdgeDB());
        return this.getResponse(response);
    }

    private <T> T getResponse(Call<T> call) throws DVCException {
        Response response;
        ErrorResponse errorResponse = ErrorResponse.builder().build();
        try {
            response = call.execute();
        }
        catch (IOException e) {
            errorResponse.setMessage(e.getMessage());
            throw new DVCException(HttpResponseCode.byCode(500), errorResponse);
        }
        HttpResponseCode httpResponseCode = HttpResponseCode.byCode(response.code());
        errorResponse.setMessage("Unknown error");
        if (response.errorBody() != null) {
            try {
                errorResponse = (ErrorResponse)OBJECT_MAPPER.readValue(response.errorBody().string(), ErrorResponse.class);
            }
            catch (IOException e) {
                errorResponse.setMessage(e.getMessage());
                throw new DVCException(httpResponseCode, errorResponse);
            }
            throw new DVCException(httpResponseCode, errorResponse);
        }
        if (response.body() == null) {
            throw new DVCException(httpResponseCode, errorResponse);
        }
        if (response.isSuccessful()) {
            return (T)response.body();
        }
        if (httpResponseCode == HttpResponseCode.UNAUTHORIZED) {
            errorResponse.setMessage("API Key is unauthorized");
        } else if (!response.message().equals("")) {
            try {
                errorResponse = (ErrorResponse)OBJECT_MAPPER.readValue(response.message(), ErrorResponse.class);
            }
            catch (JsonProcessingException e) {
                errorResponse.setMessage(e.getMessage());
                throw new DVCException(httpResponseCode, errorResponse);
            }
        }
        throw new DVCException(httpResponseCode, errorResponse);
    }

    private void addDefaults(User user) {
        if (Objects.isNull(user.getPlatform()) || Objects.equals(user.getPlatform(), "")) {
            user.setPlatform(DEFAULT_PLATFORM);
        }
        if (Objects.isNull(user.getPlatformVersion()) || Objects.equals(user.getPlatformVersion(), "")) {
            user.setPlatformVersion(DEFAULT_PLATFORM_VERSION);
        }
        if (Objects.isNull((Object)user.getSdkType())) {
            user.setSdkType(DEFAULT_SDK_TYPE);
        }
        if (Objects.isNull(user.getSdkVersion()) || Objects.equals(user.getSdkVersion(), "")) {
            user.setSdkVersion(this.DEFAULT_SDK_VERSION);
        }
    }

    private void validateUser(User user) {
        if (user == null) {
            throw new IllegalArgumentException("User cannot be null");
        }
        if (user.getUserId().equals("")) {
            throw new IllegalArgumentException("userId cannot be empty");
        }
    }
}

