/*
 * Decompiled with CFR 0.152.
 */
package com.devcycle.sdk.server.model;

import io.swagger.v3.oas.annotations.media.Schema;
import java.math.BigDecimal;

public class Event {
    @Schema(required=true, description="Custom event type")
    private String type;
    @Schema(description="Custom event target / subject of event. Contextual to event type")
    private String target;
    @Schema(description="Unix epoch time the event occurred according to client")
    private Long date;
    @Schema(description="Value for numerical events. Contextual to event type")
    private BigDecimal value;
    @Schema(description="Extra JSON metadata for event. Contextual to event type")
    private Object metaData;

    public static EventBuilder builder() {
        return new EventBuilder();
    }

    public String getType() {
        return this.type;
    }

    public String getTarget() {
        return this.target;
    }

    public Long getDate() {
        return this.date;
    }

    public BigDecimal getValue() {
        return this.value;
    }

    public Object getMetaData() {
        return this.metaData;
    }

    public void setType(String type) {
        this.type = type;
    }

    public void setTarget(String target) {
        this.target = target;
    }

    public void setDate(Long date) {
        this.date = date;
    }

    public void setValue(BigDecimal value) {
        this.value = value;
    }

    public void setMetaData(Object metaData) {
        this.metaData = metaData;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Event)) {
            return false;
        }
        Event other = (Event)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Long this$date = this.getDate();
        Long other$date = other.getDate();
        if (this$date == null ? other$date != null : !((Object)this$date).equals(other$date)) {
            return false;
        }
        String this$type = this.getType();
        String other$type = other.getType();
        if (this$type == null ? other$type != null : !this$type.equals(other$type)) {
            return false;
        }
        String this$target = this.getTarget();
        String other$target = other.getTarget();
        if (this$target == null ? other$target != null : !this$target.equals(other$target)) {
            return false;
        }
        BigDecimal this$value = this.getValue();
        BigDecimal other$value = other.getValue();
        if (this$value == null ? other$value != null : !((Object)this$value).equals(other$value)) {
            return false;
        }
        Object this$metaData = this.getMetaData();
        Object other$metaData = other.getMetaData();
        return !(this$metaData == null ? other$metaData != null : !this$metaData.equals(other$metaData));
    }

    protected boolean canEqual(Object other) {
        return other instanceof Event;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Long $date = this.getDate();
        result = result * 59 + ($date == null ? 43 : ((Object)$date).hashCode());
        String $type = this.getType();
        result = result * 59 + ($type == null ? 43 : $type.hashCode());
        String $target = this.getTarget();
        result = result * 59 + ($target == null ? 43 : $target.hashCode());
        BigDecimal $value = this.getValue();
        result = result * 59 + ($value == null ? 43 : ((Object)$value).hashCode());
        Object $metaData = this.getMetaData();
        result = result * 59 + ($metaData == null ? 43 : $metaData.hashCode());
        return result;
    }

    public String toString() {
        return "Event(type=" + this.getType() + ", target=" + this.getTarget() + ", date=" + this.getDate() + ", value=" + this.getValue() + ", metaData=" + this.getMetaData() + ")";
    }

    public Event(String type, String target, Long date, BigDecimal value, Object metaData) {
        this.type = type;
        this.target = target;
        this.date = date;
        this.value = value;
        this.metaData = metaData;
    }

    public Event() {
    }

    public static class EventBuilder {
        private String type;
        private String target;
        private Long date;
        private BigDecimal value;
        private Object metaData;

        EventBuilder() {
        }

        public EventBuilder type(String type) {
            this.type = type;
            return this;
        }

        public EventBuilder target(String target) {
            this.target = target;
            return this;
        }

        public EventBuilder date(Long date) {
            this.date = date;
            return this;
        }

        public EventBuilder value(BigDecimal value) {
            this.value = value;
            return this;
        }

        public EventBuilder metaData(Object metaData) {
            this.metaData = metaData;
            return this;
        }

        public Event build() {
            return new Event(this.type, this.target, this.date, this.value, this.metaData);
        }

        public String toString() {
            return "Event.EventBuilder(type=" + this.type + ", target=" + this.target + ", date=" + this.date + ", value=" + this.value + ", metaData=" + this.metaData + ")";
        }
    }
}

