/*
 * Decompiled with CFR 0.152.
 */
package com.devcycle.sdk.server.cloud.api;

import com.devcycle.sdk.server.cloud.api.DVCCloudApiClient;
import com.devcycle.sdk.server.cloud.model.DVCCloudOptions;
import com.devcycle.sdk.server.common.api.IDVCApi;
import com.devcycle.sdk.server.common.exception.DVCException;
import com.devcycle.sdk.server.common.model.DVCResponse;
import com.devcycle.sdk.server.common.model.ErrorResponse;
import com.devcycle.sdk.server.common.model.Event;
import com.devcycle.sdk.server.common.model.Feature;
import com.devcycle.sdk.server.common.model.HttpResponseCode;
import com.devcycle.sdk.server.common.model.User;
import com.devcycle.sdk.server.common.model.UserAndEvents;
import com.devcycle.sdk.server.common.model.Variable;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.util.Collections;
import java.util.Map;
import retrofit2.Call;
import retrofit2.Response;

public final class DVCCloudClient {
    private final IDVCApi api;
    private final DVCCloudOptions dvcOptions;
    private static final ObjectMapper OBJECT_MAPPER = new ObjectMapper();

    public DVCCloudClient(String serverKey) {
        this(serverKey, DVCCloudOptions.builder().build());
    }

    public DVCCloudClient(String serverKey, DVCCloudOptions options) {
        this.dvcOptions = options;
        this.api = new DVCCloudApiClient(serverKey, options).initialize();
        OBJECT_MAPPER.setSerializationInclusion(JsonInclude.Include.NON_NULL);
    }

    public Map<String, Feature> allFeatures(User user) throws DVCException {
        this.validateUser(user);
        Call<Map<String, Feature>> response = this.api.getFeatures(user, this.dvcOptions.getEnableEdgeDB());
        return this.getResponse(response);
    }

    public <T> Variable<T> variable(User user, String key, T defaultValue) {
        Variable variable;
        this.validateUser(user);
        if (key == null || key.equals("")) {
            throw new IllegalArgumentException("key cannot be null or empty");
        }
        if (defaultValue == null) {
            throw new IllegalArgumentException("defaultValue cannot be null");
        }
        try {
            Call<Variable> response = this.api.getVariableByKey(user, key, this.dvcOptions.getEnableEdgeDB());
            variable = this.getResponse(response);
        }
        catch (Exception exception) {
            variable = Variable.builder().key(key).value(defaultValue).isDefaulted(true).reasonUsingDefaultValue(exception.getMessage()).build();
        }
        return variable;
    }

    public Map<String, Variable> allVariables(User user) throws DVCException {
        this.validateUser(user);
        Call<Map<String, Variable>> response = this.api.getVariables(user, this.dvcOptions.getEnableEdgeDB());
        return this.getResponse(response);
    }

    public DVCResponse track(User user, Event event) throws DVCException {
        this.validateUser(user);
        UserAndEvents userAndEvents = UserAndEvents.builder().user(user).events(Collections.singletonList(event)).build();
        Call<DVCResponse> response = this.api.track(userAndEvents, this.dvcOptions.getEnableEdgeDB());
        return this.getResponse(response);
    }

    private <T> T getResponse(Call<T> call) throws DVCException {
        Response response;
        ErrorResponse errorResponse = ErrorResponse.builder().build();
        try {
            response = call.execute();
        }
        catch (IOException e) {
            errorResponse.setMessage(e.getMessage());
            throw new DVCException(HttpResponseCode.byCode(500), errorResponse);
        }
        HttpResponseCode httpResponseCode = HttpResponseCode.byCode(response.code());
        errorResponse.setMessage("Unknown error");
        if (response.errorBody() != null) {
            try {
                errorResponse = (ErrorResponse)OBJECT_MAPPER.readValue(response.errorBody().string(), ErrorResponse.class);
            }
            catch (IOException e) {
                errorResponse.setMessage(e.getMessage());
                throw new DVCException(httpResponseCode, errorResponse);
            }
            throw new DVCException(httpResponseCode, errorResponse);
        }
        if (response.body() == null) {
            throw new DVCException(httpResponseCode, errorResponse);
        }
        if (response.isSuccessful()) {
            return (T)response.body();
        }
        if (httpResponseCode == HttpResponseCode.UNAUTHORIZED) {
            errorResponse.setMessage("API Key is unauthorized");
        } else if (!response.message().equals("")) {
            try {
                errorResponse = (ErrorResponse)OBJECT_MAPPER.readValue(response.message(), ErrorResponse.class);
            }
            catch (JsonProcessingException e) {
                errorResponse.setMessage(e.getMessage());
                throw new DVCException(httpResponseCode, errorResponse);
            }
        }
        throw new DVCException(httpResponseCode, errorResponse);
    }

    private void validateUser(User user) {
        if (user == null) {
            throw new IllegalArgumentException("User cannot be null");
        }
        if (user.getUserId().equals("")) {
            throw new IllegalArgumentException("userId cannot be empty");
        }
    }
}

