/*
 * Decompiled with CFR 0.152.
 */
package com.devcycle.sdk.server.local.api;

import com.devcycle.sdk.server.common.model.Event;
import com.devcycle.sdk.server.common.model.Feature;
import com.devcycle.sdk.server.common.model.PlatformData;
import com.devcycle.sdk.server.common.model.User;
import com.devcycle.sdk.server.common.model.Variable;
import com.devcycle.sdk.server.local.bucketing.LocalBucketing;
import com.devcycle.sdk.server.local.managers.EnvironmentConfigManager;
import com.devcycle.sdk.server.local.managers.EventQueueManager;
import com.devcycle.sdk.server.local.model.BucketedUserConfig;
import com.devcycle.sdk.server.local.model.DVCLocalOptions;
import com.fasterxml.jackson.core.JsonProcessingException;
import java.util.Collections;
import java.util.Map;

public final class DVCLocalClient {
    private static LocalBucketing localBucketing = new LocalBucketing();
    private EnvironmentConfigManager configManager;
    private final String serverKey;
    private EventQueueManager eventQueueManager;

    public DVCLocalClient(String serverKey) {
        this(serverKey, DVCLocalOptions.builder().build());
    }

    public DVCLocalClient(String serverKey, DVCLocalOptions dvcOptions) {
        localBucketing.setPlatformData(PlatformData.builder().build().toString());
        this.configManager = new EnvironmentConfigManager(serverKey, localBucketing, dvcOptions);
        this.serverKey = serverKey;
        try {
            this.eventQueueManager = new EventQueueManager(serverKey, localBucketing, dvcOptions);
        }
        catch (Exception e) {
            System.out.printf("Error creating event queue due to error: %s%n", e.getMessage());
        }
    }

    public Map<String, Feature> allFeatures(User user) {
        this.validateUser(user);
        BucketedUserConfig bucketedUserConfig = null;
        try {
            bucketedUserConfig = localBucketing.generateBucketedConfig(this.serverKey, user);
        }
        catch (JsonProcessingException e) {
            System.out.printf("Unable to parse JSON for allFeatures due to error: %s%n", e.getMessage());
            return Collections.emptyMap();
        }
        return bucketedUserConfig.features;
    }

    public <T> Variable<T> variable(User user, String key, T defaultValue) {
        this.validateUser(user);
        if (key == null || key.equals("")) {
            throw new IllegalArgumentException("key cannot be null or empty");
        }
        if (defaultValue == null) {
            throw new IllegalArgumentException("defaultValue cannot be null");
        }
        if (!this.configManager.isConfigInitialized()) {
            System.out.println("Variable called before DVCClient has initialized, returning default value");
        }
        Variable defaultVariable = Variable.builder().key(key).value(defaultValue).isDefaulted(true).reasonUsingDefaultValue("Variable not found").build();
        try {
            BucketedUserConfig bucketedUserConfig = localBucketing.generateBucketedConfig(this.serverKey, user);
            if (bucketedUserConfig.variables.containsKey(key)) {
                Variable variable = bucketedUserConfig.variables.get(key);
                variable.setIsDefaulted(false);
                this.eventQueueManager.queueAggregateEvent(Event.builder().type("aggVariableEvaluated").target(key).build(), bucketedUserConfig);
                return variable;
            }
            this.eventQueueManager.queueAggregateEvent(Event.builder().type("aggVariableDefaulted").target(key).build(), bucketedUserConfig);
            return defaultVariable;
        }
        catch (Exception e) {
            System.out.printf("Unable to parse JSON for Variable %s due to error: %s", key, e.toString());
            try {
                this.eventQueueManager.queueAggregateEvent(Event.builder().type("aggVariableDefaulted").target(key).build(), null);
            }
            catch (Exception e2) {
                System.out.printf("Unable to parse aggVariableDefaulted event for Variable %s due to error: %s", key, e2.toString());
            }
            return defaultVariable;
        }
    }

    public Map<String, Variable> allVariables(User user) {
        this.validateUser(user);
        BucketedUserConfig bucketedUserConfig = null;
        try {
            bucketedUserConfig = localBucketing.generateBucketedConfig(this.serverKey, user);
        }
        catch (JsonProcessingException e) {
            System.out.printf("Unable to parse JSON for allVariables due to error: %s%n", e.getMessage());
            return Collections.emptyMap();
        }
        return bucketedUserConfig.variables;
    }

    public void track(User user, Event event) {
        this.validateUser(user);
        try {
            this.eventQueueManager.queueEvent(user, event);
        }
        catch (Exception e) {
            System.out.printf("Failed to queue event due to error: %s%n", e.getMessage());
        }
    }

    private void validateUser(User user) {
        if (user == null) {
            throw new IllegalArgumentException("User cannot be null");
        }
        if (user.getUserId().equals("")) {
            throw new IllegalArgumentException("userId cannot be empty");
        }
    }
}

