/*
 * Decompiled with CFR 0.152.
 */
package com.devcycle.sdk.server.local.api;

import com.devcycle.sdk.server.common.api.IDVCApi;
import com.devcycle.sdk.server.common.interceptor.AuthorizationHeaderInterceptor;
import com.devcycle.sdk.server.local.model.DVCLocalOptions;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.Objects;
import okhttp3.Interceptor;
import okhttp3.OkHttpClient;
import retrofit2.Converter;
import retrofit2.Retrofit;
import retrofit2.converter.jackson.JacksonConverterFactory;

public final class DVCLocalEventsApiClient {
    private final OkHttpClient.Builder okBuilder;
    private final Retrofit.Builder adapterBuilder;
    private static final ObjectMapper OBJECT_MAPPER = new ObjectMapper();
    private static final String EVENTS_API_URL = "https://events.devcycle.com/";
    private String eventsApiUrl;

    private DVCLocalEventsApiClient(DVCLocalOptions options) {
        OBJECT_MAPPER.setSerializationInclusion(JsonInclude.Include.NON_NULL);
        this.okBuilder = new OkHttpClient.Builder();
        String eventsApiUrlFromOptions = options.getEventsApiBaseUrl();
        String url = this.eventsApiUrl = this.checkIfStringNullOrEmpty(eventsApiUrlFromOptions) != false ? EVENTS_API_URL : eventsApiUrlFromOptions;
        this.adapterBuilder = new Retrofit.Builder().baseUrl(url).addConverterFactory((Converter.Factory)JacksonConverterFactory.create());
    }

    public DVCLocalEventsApiClient(String serverKey, DVCLocalOptions options) {
        this(options);
        this.okBuilder.addInterceptor((Interceptor)new AuthorizationHeaderInterceptor(serverKey));
    }

    public IDVCApi initialize() {
        return (IDVCApi)this.adapterBuilder.client(this.okBuilder.build()).build().create(IDVCApi.class);
    }

    private Boolean checkIfStringNullOrEmpty(String stringToCheck) {
        return Objects.isNull(stringToCheck) || Objects.equals(stringToCheck, "");
    }
}

