/*
 * Decompiled with CFR 0.152.
 */
package com.devcycle.sdk.server.local.bucketing;

import com.devcycle.sdk.server.common.model.User;
import com.devcycle.sdk.server.local.model.BucketedUserConfig;
import com.devcycle.sdk.server.local.model.FlushPayload;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import io.github.kawamuray.wasmtime.Engine;
import io.github.kawamuray.wasmtime.Extern;
import io.github.kawamuray.wasmtime.Func;
import io.github.kawamuray.wasmtime.Linker;
import io.github.kawamuray.wasmtime.Memory;
import io.github.kawamuray.wasmtime.Module;
import io.github.kawamuray.wasmtime.Store;
import io.github.kawamuray.wasmtime.WasmFunctions;
import io.github.kawamuray.wasmtime.WasmValType;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import java.util.TimeZone;
import java.util.concurrent.atomic.AtomicReference;

public class LocalBucketing {
    Store<Void> store;
    Linker linker;
    AtomicReference<Memory> memRef;
    private static final ObjectMapper OBJECT_MAPPER = new ObjectMapper();
    private Set<Integer> pinnedAddresses;
    private HashMap<String, Integer> sdkKeyAddresses;

    public LocalBucketing() {
        OBJECT_MAPPER.setSerializationInclusion(JsonInclude.Include.NON_NULL);
        this.pinnedAddresses = new HashSet<Integer>();
        this.sdkKeyAddresses = new HashMap();
        this.store = Store.withoutData();
        this.linker = new Linker(this.store.engine());
        this.memRef = new AtomicReference();
        InputStream wasmInput = this.getClass().getClassLoader().getResourceAsStream("bucketing-lib.release.wasm");
        Module module = null;
        try {
            module = Module.fromBinary((Engine)this.store.engine(), (byte[])wasmInput.readAllBytes());
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        this.setImportsOnLinker();
        this.linker.module(this.store, "", module);
        Memory mem = ((Extern)this.linker.get(this.store, "", "memory").get()).memory();
        this.memRef.set(mem);
    }

    private Collection<Extern> setImportsOnLinker() {
        Func dateNowFn = WasmFunctions.wrap(this.store, (WasmValType)WasmValType.F64, () -> System.currentTimeMillis());
        this.linker.define("env", "Date.now", Extern.fromFunc((Func)dateNowFn));
        Func consoleLogFn = WasmFunctions.wrap(this.store, (WasmValType)WasmValType.I32, addr -> {
            String message = this.readWasmString((int)addr);
            System.out.println(message);
        });
        this.linker.define("env", "console.log", Extern.fromFunc((Func)consoleLogFn));
        Func abortFn = WasmFunctions.wrap(this.store, (WasmValType)WasmValType.I32, (WasmValType)WasmValType.I32, (WasmValType)WasmValType.I32, (WasmValType)WasmValType.I32, (messagePtr, filenamePtr, linenum, colnum) -> {
            String message = this.readWasmString((int)messagePtr);
            String fileName = this.readWasmString((int)filenamePtr);
            throw new RuntimeException("Exception in " + fileName + ":" + linenum + " : " + colnum + " " + message);
        });
        this.linker.define("env", "abort", Extern.fromFunc((Func)abortFn));
        Func seedFn = WasmFunctions.wrap(this.store, (WasmValType)WasmValType.F64, () -> (double)System.currentTimeMillis() * Math.random());
        this.linker.define("env", "seed", Extern.fromFunc((Func)seedFn));
        return Arrays.asList(Extern.fromFunc((Func)dateNowFn), Extern.fromFunc((Func)consoleLogFn), Extern.fromFunc((Func)abortFn));
    }

    private int newWasmString(String param) {
        int objectIdString = 1;
        Func __newPtr = ((Extern)this.linker.get(this.store, "", "__new").get()).func();
        WasmFunctions.Function2 __new = WasmFunctions.func(this.store, (Func)__newPtr, (WasmValType)WasmValType.I32, (WasmValType)WasmValType.I32, (WasmValType)WasmValType.I32);
        byte[] paramBytes = param.getBytes(StandardCharsets.UTF_8);
        int paramAddress = (Integer)__new.call((Object)(paramBytes.length * 2), (Object)objectIdString);
        ByteBuffer buf = this.memRef.get().buffer(this.store);
        for (int i = 0; i < paramBytes.length; ++i) {
            buf.put(paramAddress + i * 2, paramBytes[i]);
        }
        return paramAddress;
    }

    private String readWasmString(int startAddress) {
        ByteBuffer buf = this.memRef.get().buffer(this.store);
        byte[] headerBytes = new byte[]{buf.get(startAddress - 1), buf.get(startAddress - 2), buf.get(startAddress - 3), buf.get(startAddress - 4)};
        long stringLength = LocalBucketing.getUnsignedInt(headerBytes);
        String result = "";
        int i = 0;
        while ((long)i < stringLength) {
            result = result + (char)buf.get(startAddress + i);
            i += 2;
        }
        return result;
    }

    private static long getUnsignedInt(byte[] data) {
        long result = 0L;
        for (int i = 0; i < data.length; ++i) {
            result = (result << 8) + (long)(data[i] & 0xFF);
        }
        return result;
    }

    public void storeConfig(String sdkKey, String config) {
        this.unpinAll();
        int sdkKeyAddress = this.getSDKKeyAddress(sdkKey);
        int configAddress = this.newWasmString(config);
        Func setConfigDataPtr = ((Extern)this.linker.get(this.store, "", "setConfigData").get()).func();
        WasmFunctions.Consumer2 fn = WasmFunctions.consumer(this.store, (Func)setConfigDataPtr, (WasmValType)WasmValType.I32, (WasmValType)WasmValType.I32);
        fn.accept((Object)sdkKeyAddress, (Object)configAddress);
    }

    public void setPlatformData(String platformData) {
        this.unpinAll();
        int platformDataAddress = this.newWasmString(platformData);
        Func setPlatformDataPtr = ((Extern)this.linker.get(this.store, "", "setPlatformData").get()).func();
        WasmFunctions.Consumer1 fn = WasmFunctions.consumer(this.store, (Func)setPlatformDataPtr, (WasmValType)WasmValType.I32);
        fn.accept((Object)platformDataAddress);
    }

    public BucketedUserConfig generateBucketedConfig(String sdkKey, User user) throws JsonProcessingException {
        this.unpinAll();
        String userString = OBJECT_MAPPER.writeValueAsString((Object)user);
        int sdkKeyAddress = this.getSDKKeyAddress(sdkKey);
        int userAddress = this.newWasmString(userString);
        Func generateBucketedConfigForUserPtr = ((Extern)this.linker.get(this.store, "", "generateBucketedConfigForUser").get()).func();
        WasmFunctions.Function2 generateBucketedConfigForUser = WasmFunctions.func(this.store, (Func)generateBucketedConfigForUserPtr, (WasmValType)WasmValType.I32, (WasmValType)WasmValType.I32, (WasmValType)WasmValType.I32);
        int resultAddress = (Integer)generateBucketedConfigForUser.call((Object)sdkKeyAddress, (Object)userAddress);
        String bucketedConfigString = this.readWasmString(resultAddress);
        ObjectMapper objectMapper = new ObjectMapper();
        BucketedUserConfig config = (BucketedUserConfig)objectMapper.readValue(bucketedConfigString, BucketedUserConfig.class);
        return config;
    }

    public void initEventQueue(String sdkKey, String options) {
        this.unpinAll();
        int sdkKeyAddress = this.getSDKKeyAddress(sdkKey);
        int optionsAddress = this.newWasmString(options);
        Func initEventQueuePtr = ((Extern)this.linker.get(this.store, "", "initEventQueue").get()).func();
        WasmFunctions.Consumer2 fn = WasmFunctions.consumer(this.store, (Func)initEventQueuePtr, (WasmValType)WasmValType.I32, (WasmValType)WasmValType.I32);
        fn.accept((Object)sdkKeyAddress, (Object)optionsAddress);
    }

    public void queueEvent(String sdkKey, String user, String event) {
        this.unpinAll();
        int sdkKeyAddress = this.newWasmString(sdkKey);
        int userAddress = this.getPinnedParameter(user);
        int eventAddress = this.newWasmString(event);
        Func queueEventPtr = ((Extern)this.linker.get(this.store, "", "queueEvent").get()).func();
        WasmFunctions.Consumer3 fn = WasmFunctions.consumer(this.store, (Func)queueEventPtr, (WasmValType)WasmValType.I32, (WasmValType)WasmValType.I32, (WasmValType)WasmValType.I32);
        fn.accept((Object)sdkKeyAddress, (Object)userAddress, (Object)eventAddress);
    }

    public void queueAggregateEvent(String sdkKey, String event, String variableVariationMap) {
        this.unpinAll();
        int sdkKeyAddress = this.getSDKKeyAddress(sdkKey);
        int eventAddress = this.getPinnedParameter(event);
        int variableVariationMapAddress = this.newWasmString(variableVariationMap);
        Func queueAggregateEventPtr = ((Extern)this.linker.get(this.store, "", "queueAggregateEvent").get()).func();
        WasmFunctions.Consumer3 fn = WasmFunctions.consumer(this.store, (Func)queueAggregateEventPtr, (WasmValType)WasmValType.I32, (WasmValType)WasmValType.I32, (WasmValType)WasmValType.I32);
        fn.accept((Object)sdkKeyAddress, (Object)eventAddress, (Object)variableVariationMapAddress);
    }

    public FlushPayload[] flushEventQueue(String sdkKey) throws JsonProcessingException {
        this.unpinAll();
        int sdkKeyAddress = this.getSDKKeyAddress(sdkKey);
        Func flushEventQueuePtr = ((Extern)this.linker.get(this.store, "", "flushEventQueue").get()).func();
        WasmFunctions.Function1 fn = WasmFunctions.func(this.store, (Func)flushEventQueuePtr, (WasmValType)WasmValType.I32, (WasmValType)WasmValType.I32);
        int resultAddress = (Integer)fn.call((Object)sdkKeyAddress);
        String flushPayloadsStr = this.readWasmString(resultAddress);
        ObjectMapper objectMapper = new ObjectMapper();
        objectMapper.disable(SerializationFeature.WRITE_DATES_AS_TIMESTAMPS);
        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ssZ");
        df.setTimeZone(TimeZone.getTimeZone("UTC"));
        objectMapper.setDateFormat((DateFormat)df);
        FlushPayload[] payloads = (FlushPayload[])objectMapper.readValue(flushPayloadsStr, FlushPayload[].class);
        return payloads;
    }

    public void onPayloadFailure(String sdkKey, String payloadId, boolean retryable) {
        this.unpinAll();
        int sdkKeyAddress = this.getSDKKeyAddress(sdkKey);
        int payloadIdAddress = this.newWasmString(payloadId);
        Func onPayloadFailurePtr = ((Extern)this.linker.get(this.store, "", "onPayloadFailure").get()).func();
        WasmFunctions.Consumer3 fn = WasmFunctions.consumer(this.store, (Func)onPayloadFailurePtr, (WasmValType)WasmValType.I32, (WasmValType)WasmValType.I32, (WasmValType)WasmValType.I32);
        fn.accept((Object)sdkKeyAddress, (Object)payloadIdAddress, (Object)(retryable ? 1 : 0));
    }

    public void onPayloadSuccess(String sdkKey, String payloadId) {
        this.unpinAll();
        int sdkKeyAddress = this.getSDKKeyAddress(sdkKey);
        int payloadIdAddress = this.newWasmString(payloadId);
        Func onPayloadSuccessPtr = ((Extern)this.linker.get(this.store, "", "onPayloadSuccess").get()).func();
        WasmFunctions.Consumer2 fn = WasmFunctions.consumer(this.store, (Func)onPayloadSuccessPtr, (WasmValType)WasmValType.I32, (WasmValType)WasmValType.I32);
        fn.accept((Object)sdkKeyAddress, (Object)payloadIdAddress);
    }

    public int getEventQueueSize(String sdkKey) {
        this.unpinAll();
        int sdkKeyAddress = this.getSDKKeyAddress(sdkKey);
        Func getEventQueueSizePtr = ((Extern)this.linker.get(this.store, "", "eventQueueSize").get()).func();
        WasmFunctions.Function1 getEventQueueSize = WasmFunctions.func(this.store, (Func)getEventQueueSizePtr, (WasmValType)WasmValType.I32, (WasmValType)WasmValType.I32);
        return (Integer)getEventQueueSize.call((Object)sdkKeyAddress);
    }

    private void pinParameter(int address) {
        Func pinPtr = ((Extern)this.linker.get(this.store, "", "__pin").get()).func();
        WasmFunctions.Consumer1 pin = WasmFunctions.consumer(this.store, (Func)pinPtr, (WasmValType)WasmValType.I32);
        pin.accept((Object)address);
    }

    private void unpinParameter(int address) {
        Func unpinPtr = ((Extern)this.linker.get(this.store, "", "__unpin").get()).func();
        WasmFunctions.Consumer1 unpin = WasmFunctions.consumer(this.store, (Func)unpinPtr, (WasmValType)WasmValType.I32);
        unpin.accept((Object)address);
    }

    private void unpinAll() {
        for (int address : this.pinnedAddresses) {
            this.unpinParameter(address);
        }
        this.pinnedAddresses.clear();
    }

    private int getPinnedParameter(String param) {
        int address = this.newWasmString(param);
        this.pinParameter(address);
        this.pinnedAddresses.add(address);
        return address;
    }

    private int getSDKKeyAddress(String sdkKey) {
        if (!this.sdkKeyAddresses.containsKey(sdkKey)) {
            int sdkKeyAddress = this.newWasmString(sdkKey);
            this.pinParameter(sdkKeyAddress);
            this.sdkKeyAddresses.put(sdkKey, sdkKeyAddress);
        }
        return this.sdkKeyAddresses.get(sdkKey);
    }
}

