/*
 * Decompiled with CFR 0.152.
 */
package com.devcycle.sdk.server.local.managers;

import com.devcycle.sdk.server.common.api.IDVCApi;
import com.devcycle.sdk.server.common.exception.DVCException;
import com.devcycle.sdk.server.common.model.ErrorResponse;
import com.devcycle.sdk.server.common.model.HttpResponseCode;
import com.devcycle.sdk.server.common.model.ProjectConfig;
import com.devcycle.sdk.server.local.api.DVCLocalApiClient;
import com.devcycle.sdk.server.local.bucketing.LocalBucketing;
import com.devcycle.sdk.server.local.model.DVCLocalOptions;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import retrofit2.Call;
import retrofit2.Response;

public final class EnvironmentConfigManager {
    private final ScheduledExecutorService scheduler = Executors.newScheduledThreadPool(1);
    private static final ObjectMapper OBJECT_MAPPER = new ObjectMapper();
    private static final int DEFAULT_POLL_INTERVAL_MS = 30000;
    private static final int MIN_INTERVALS_MS = 1000;
    private IDVCApi configApiClient;
    private LocalBucketing localBucketing;
    private ProjectConfig config;
    private String configETag = "";
    private String sdkKey;
    private int pollingIntervalMS;

    public EnvironmentConfigManager(String sdkKey, LocalBucketing localBucketing, DVCLocalOptions options) {
        this.sdkKey = sdkKey;
        this.localBucketing = localBucketing;
        this.configApiClient = new DVCLocalApiClient(sdkKey, options).initialize();
        int configPollingIntervalMS = options.getConfigPollingIntervalMS();
        this.pollingIntervalMS = configPollingIntervalMS >= 1000 ? configPollingIntervalMS : 30000;
        this.setupScheduler();
    }

    private void setupScheduler() {
        Runnable getConfigRunnable = new Runnable(){

            @Override
            public void run() {
                try {
                    EnvironmentConfigManager.this.getConfig();
                }
                catch (DVCException | JsonProcessingException e) {
                    e.printStackTrace();
                }
            }
        };
        this.scheduler.scheduleAtFixedRate(getConfigRunnable, 0L, this.pollingIntervalMS, TimeUnit.MILLISECONDS);
    }

    public boolean isConfigInitialized() {
        return this.config != null;
    }

    private ProjectConfig getConfig() throws DVCException, JsonProcessingException {
        Call<ProjectConfig> config = this.configApiClient.getConfig(this.sdkKey, this.configETag);
        this.config = this.getConfigResponse(config);
        return this.config;
    }

    private ProjectConfig getConfigResponse(Call<ProjectConfig> call) throws DVCException, JsonProcessingException {
        Response response;
        ErrorResponse errorResponse = ErrorResponse.builder().build();
        try {
            response = call.execute();
        }
        catch (IOException e) {
            errorResponse.setMessage(e.getMessage());
            throw new DVCException(HttpResponseCode.byCode(500), errorResponse);
        }
        HttpResponseCode httpResponseCode = HttpResponseCode.byCode(response.code());
        errorResponse.setMessage("Unknown error");
        if (response.isSuccessful()) {
            String currentETag = response.headers().get("ETag");
            ProjectConfig config = (ProjectConfig)response.body();
            try {
                ObjectMapper mapper = new ObjectMapper();
                this.localBucketing.storeConfig(this.sdkKey, mapper.writeValueAsString((Object)config));
            }
            catch (JsonProcessingException e) {
                if (this.config != null) {
                    System.out.printf("Unable to parse config with etag: %s. Using cache, etag %s%n", currentETag, this.configETag);
                    return this.config;
                }
                throw e;
            }
            this.configETag = currentETag;
            return (ProjectConfig)response.body();
        }
        if (httpResponseCode == HttpResponseCode.NOT_MODIFIED) {
            System.out.printf("Config not modified, using cache, etag: %s%n", this.configETag);
            return this.config;
        }
        if (response.errorBody() != null) {
            try {
                errorResponse = (ErrorResponse)OBJECT_MAPPER.readValue(response.errorBody().string(), ErrorResponse.class);
            }
            catch (IOException e) {
                errorResponse.setMessage(e.getMessage());
                throw new DVCException(httpResponseCode, errorResponse);
            }
            throw new DVCException(httpResponseCode, errorResponse);
        }
        if (httpResponseCode == HttpResponseCode.UNAUTHORIZED) {
            errorResponse.setMessage("API Key is unauthorized");
        } else if (!response.message().equals("")) {
            try {
                errorResponse = (ErrorResponse)OBJECT_MAPPER.readValue(response.message(), ErrorResponse.class);
            }
            catch (JsonProcessingException e) {
                errorResponse.setMessage(e.getMessage());
                throw new DVCException(httpResponseCode, errorResponse);
            }
        }
        throw new DVCException(httpResponseCode, errorResponse);
    }
}

