/*
 * Decompiled with CFR 0.152.
 */
package com.devcycle.sdk.server.common.model;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import io.swagger.v3.oas.annotations.media.Schema;

@JsonIgnoreProperties(ignoreUnknown=true)
public class Feature {
    @Schema(required=true, description="unique database id")
    @JsonProperty(value="_id")
    private String id;
    @Schema(required=true, description="Unique key by Project, can be used in the SDK / API to reference by 'key' rather than _id.")
    private String key;
    @Schema(required=true, description="Feature type")
    private TypeEnum type;
    @Schema(required=true, description="Bucketed feature variation")
    @JsonProperty(value="_variation")
    private String variation;
    @Schema(required=true, description="Bucketed feature variation key")
    @JsonProperty(value="variationKey")
    private String variationKey;
    @Schema(required=true, description="Bucketed feature variation name")
    @JsonProperty(value="variationName")
    private String variationName;
    @Schema(description="Evaluation reasoning")
    private String evalReason;

    public static FeatureBuilder builder() {
        return new FeatureBuilder();
    }

    public String getId() {
        return this.id;
    }

    public String getKey() {
        return this.key;
    }

    public TypeEnum getType() {
        return this.type;
    }

    public String getVariation() {
        return this.variation;
    }

    public String getVariationKey() {
        return this.variationKey;
    }

    public String getVariationName() {
        return this.variationName;
    }

    public String getEvalReason() {
        return this.evalReason;
    }

    @JsonProperty(value="_id")
    public void setId(String id) {
        this.id = id;
    }

    public void setKey(String key) {
        this.key = key;
    }

    public void setType(TypeEnum type) {
        this.type = type;
    }

    @JsonProperty(value="_variation")
    public void setVariation(String variation) {
        this.variation = variation;
    }

    @JsonProperty(value="variationKey")
    public void setVariationKey(String variationKey) {
        this.variationKey = variationKey;
    }

    @JsonProperty(value="variationName")
    public void setVariationName(String variationName) {
        this.variationName = variationName;
    }

    public void setEvalReason(String evalReason) {
        this.evalReason = evalReason;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Feature)) {
            return false;
        }
        Feature other = (Feature)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$id = this.getId();
        String other$id = other.getId();
        if (this$id == null ? other$id != null : !this$id.equals(other$id)) {
            return false;
        }
        String this$key = this.getKey();
        String other$key = other.getKey();
        if (this$key == null ? other$key != null : !this$key.equals(other$key)) {
            return false;
        }
        TypeEnum this$type = this.getType();
        TypeEnum other$type = other.getType();
        if (this$type == null ? other$type != null : !((Object)((Object)this$type)).equals((Object)other$type)) {
            return false;
        }
        String this$variation = this.getVariation();
        String other$variation = other.getVariation();
        if (this$variation == null ? other$variation != null : !this$variation.equals(other$variation)) {
            return false;
        }
        String this$variationKey = this.getVariationKey();
        String other$variationKey = other.getVariationKey();
        if (this$variationKey == null ? other$variationKey != null : !this$variationKey.equals(other$variationKey)) {
            return false;
        }
        String this$variationName = this.getVariationName();
        String other$variationName = other.getVariationName();
        if (this$variationName == null ? other$variationName != null : !this$variationName.equals(other$variationName)) {
            return false;
        }
        String this$evalReason = this.getEvalReason();
        String other$evalReason = other.getEvalReason();
        return !(this$evalReason == null ? other$evalReason != null : !this$evalReason.equals(other$evalReason));
    }

    protected boolean canEqual(Object other) {
        return other instanceof Feature;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $id = this.getId();
        result = result * 59 + ($id == null ? 43 : $id.hashCode());
        String $key = this.getKey();
        result = result * 59 + ($key == null ? 43 : $key.hashCode());
        TypeEnum $type = this.getType();
        result = result * 59 + ($type == null ? 43 : ((Object)((Object)$type)).hashCode());
        String $variation = this.getVariation();
        result = result * 59 + ($variation == null ? 43 : $variation.hashCode());
        String $variationKey = this.getVariationKey();
        result = result * 59 + ($variationKey == null ? 43 : $variationKey.hashCode());
        String $variationName = this.getVariationName();
        result = result * 59 + ($variationName == null ? 43 : $variationName.hashCode());
        String $evalReason = this.getEvalReason();
        result = result * 59 + ($evalReason == null ? 43 : $evalReason.hashCode());
        return result;
    }

    public String toString() {
        return "Feature(id=" + this.getId() + ", key=" + this.getKey() + ", type=" + (Object)((Object)this.getType()) + ", variation=" + this.getVariation() + ", variationKey=" + this.getVariationKey() + ", variationName=" + this.getVariationName() + ", evalReason=" + this.getEvalReason() + ")";
    }

    public Feature(String id, String key, TypeEnum type, String variation, String variationKey, String variationName, String evalReason) {
        this.id = id;
        this.key = key;
        this.type = type;
        this.variation = variation;
        this.variationKey = variationKey;
        this.variationName = variationName;
        this.evalReason = evalReason;
    }

    public Feature() {
    }

    public static class FeatureBuilder {
        private String id;
        private String key;
        private TypeEnum type;
        private String variation;
        private String variationKey;
        private String variationName;
        private String evalReason;

        FeatureBuilder() {
        }

        @JsonProperty(value="_id")
        public FeatureBuilder id(String id) {
            this.id = id;
            return this;
        }

        public FeatureBuilder key(String key) {
            this.key = key;
            return this;
        }

        public FeatureBuilder type(TypeEnum type) {
            this.type = type;
            return this;
        }

        @JsonProperty(value="_variation")
        public FeatureBuilder variation(String variation) {
            this.variation = variation;
            return this;
        }

        @JsonProperty(value="variationKey")
        public FeatureBuilder variationKey(String variationKey) {
            this.variationKey = variationKey;
            return this;
        }

        @JsonProperty(value="variationName")
        public FeatureBuilder variationName(String variationName) {
            this.variationName = variationName;
            return this;
        }

        public FeatureBuilder evalReason(String evalReason) {
            this.evalReason = evalReason;
            return this;
        }

        public Feature build() {
            return new Feature(this.id, this.key, this.type, this.variation, this.variationKey, this.variationName, this.evalReason);
        }

        public String toString() {
            return "Feature.FeatureBuilder(id=" + this.id + ", key=" + this.key + ", type=" + (Object)((Object)this.type) + ", variation=" + this.variation + ", variationKey=" + this.variationKey + ", variationName=" + this.variationName + ", evalReason=" + this.evalReason + ")";
        }
    }

    public static enum TypeEnum {
        RELEASE("release"),
        EXPERIMENT("experiment"),
        PERMISSION("permission"),
        OPS("ops");

        private final String value;

        private TypeEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static TypeEnum fromValue(String text) {
            for (TypeEnum b : TypeEnum.values()) {
                if (!String.valueOf(b.value).equals(text)) continue;
                return b;
            }
            return null;
        }
    }
}

