/*
 * Decompiled with CFR 0.152.
 */
package com.devcycle.sdk.server.local.api;

import com.devcycle.sdk.server.common.model.BaseVariable;
import com.devcycle.sdk.server.common.model.Event;
import com.devcycle.sdk.server.common.model.Feature;
import com.devcycle.sdk.server.common.model.PlatformData;
import com.devcycle.sdk.server.common.model.User;
import com.devcycle.sdk.server.common.model.Variable;
import com.devcycle.sdk.server.local.bucketing.LocalBucketing;
import com.devcycle.sdk.server.local.managers.EnvironmentConfigManager;
import com.devcycle.sdk.server.local.managers.EventQueueManager;
import com.devcycle.sdk.server.local.model.BucketedUserConfig;
import com.devcycle.sdk.server.local.model.DVCLocalOptions;
import com.devcycle.sdk.server.local.protobuf.SDKVariable_PB;
import com.devcycle.sdk.server.local.protobuf.VariableForUserParams_PB;
import com.devcycle.sdk.server.local.protobuf.VariableType_PB;
import com.devcycle.sdk.server.local.utils.ProtobufUtils;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.Collections;
import java.util.Map;

public final class DVCLocalClient {
    private LocalBucketing localBucketing = new LocalBucketing();
    private EnvironmentConfigManager configManager;
    private final String sdkKey;
    private EventQueueManager eventQueueManager;

    public DVCLocalClient(String sdkKey) {
        this(sdkKey, DVCLocalOptions.builder().build());
    }

    public DVCLocalClient(String sdkKey, DVCLocalOptions dvcOptions) {
        if (sdkKey == null || sdkKey.equals("")) {
            throw new IllegalArgumentException("Missing SDK key! Call initialize with a valid SDK key");
        }
        if (!this.isValidServerKey(sdkKey)) {
            throw new IllegalArgumentException("Invalid SDK key provided. Please call initialize with a valid server SDK key");
        }
        if (!this.isValidRuntime()) {
            System.out.println("Invalid architecture. The DVCLocalClient requires a 64-bit, x86 runtime environment.");
        }
        this.localBucketing.setPlatformData(PlatformData.builder().build().toString());
        this.configManager = new EnvironmentConfigManager(sdkKey, this.localBucketing, dvcOptions);
        this.sdkKey = sdkKey;
        try {
            this.eventQueueManager = new EventQueueManager(sdkKey, this.localBucketing, dvcOptions);
        }
        catch (Exception e) {
            System.out.printf("Error creating event queue due to error: %s%n", e.getMessage());
        }
    }

    public boolean isInitialized() {
        if (this.configManager != null) {
            return this.configManager.isConfigInitialized();
        }
        return false;
    }

    public Map<String, Feature> allFeatures(User user) {
        if (!this.isInitialized()) {
            return Collections.emptyMap();
        }
        this.validateUser(user);
        BucketedUserConfig bucketedUserConfig = null;
        try {
            bucketedUserConfig = this.localBucketing.generateBucketedConfig(this.sdkKey, user);
        }
        catch (JsonProcessingException e) {
            System.out.printf("Unable to parse JSON for allFeatures due to error: %s%n", e.getMessage());
            return Collections.emptyMap();
        }
        return bucketedUserConfig.features;
    }

    public <T> T variableValue(User user, String key, T defaultValue) {
        return this.variable(user, key, defaultValue).getValue();
    }

    public <T> Variable<T> variable(User user, String key, T defaultValue) {
        this.validateUser(user);
        if (key == null || key.equals("")) {
            throw new IllegalArgumentException("Missing parameter: key");
        }
        if (defaultValue == null) {
            throw new IllegalArgumentException("Missing parameter: defaultValue");
        }
        Variable.TypeEnum variableType = Variable.TypeEnum.fromClass(defaultValue.getClass());
        Variable defaultVariable = Variable.builder().key(key).type(variableType).value(defaultValue).defaultValue(defaultValue).isDefaulted(true).build();
        if (!this.isInitialized()) {
            System.out.println("Variable called before DVCClient has initialized, returning default value");
            try {
                this.eventQueueManager.queueAggregateEvent(Event.builder().type("aggVariableDefaulted").target(key).build(), null);
            }
            catch (Exception e) {
                System.out.printf("Unable to parse aggVariableDefaulted event for Variable %s due to error: %s", key, e.toString());
            }
            return defaultVariable;
        }
        VariableType_PB pbVariableType = ProtobufUtils.convertTypeEnumToVariableType(variableType);
        VariableForUserParams_PB params = VariableForUserParams_PB.newBuilder().setSdkKey(this.sdkKey).setUser(ProtobufUtils.createDVCUserPB(user)).setVariableKey(key).setVariableType(pbVariableType).setShouldTrackEvent(true).build();
        try {
            byte[] paramsBuffer = params.toByteArray();
            byte[] variableData = this.localBucketing.getVariableForUserProtobuf(paramsBuffer);
            if (variableData == null || variableData.length == 0) {
                return defaultVariable;
            }
            SDKVariable_PB sdkVariable = SDKVariable_PB.parseFrom(variableData);
            if (sdkVariable.getType() != pbVariableType) {
                System.out.printf("Variable type mismatch, returning default value", new Object[0]);
                return defaultVariable;
            }
            return ProtobufUtils.createVariable(sdkVariable, defaultValue);
        }
        catch (Exception e) {
            System.out.printf("Unable to evaluate Variable %s due to error: %s", key, e);
            return defaultVariable;
        }
    }

    public Map<String, BaseVariable> allVariables(User user) {
        this.validateUser(user);
        if (!this.isInitialized()) {
            return Collections.emptyMap();
        }
        BucketedUserConfig bucketedUserConfig = null;
        try {
            bucketedUserConfig = this.localBucketing.generateBucketedConfig(this.sdkKey, user);
        }
        catch (JsonProcessingException e) {
            System.out.printf("Unable to parse JSON for allVariables due to error: %s%n", e.getMessage());
            return Collections.emptyMap();
        }
        return bucketedUserConfig.variables;
    }

    public void track(User user, Event event) {
        this.validateUser(user);
        if (event == null || event.getType().equals("")) {
            throw new IllegalArgumentException("Invalid Event");
        }
        try {
            this.eventQueueManager.queueEvent(user, event);
        }
        catch (Exception e) {
            System.out.printf("Failed to queue event due to error: %s%n", e.getMessage());
        }
    }

    public void setClientCustomData(Map<String, Object> customData) {
        if (!this.isInitialized()) {
            System.out.println("SetClientCustomData called before DVCClient has initialized");
            return;
        }
        if (customData != null && !customData.isEmpty()) {
            try {
                ObjectMapper mapper = new ObjectMapper();
                String customDataJSON = mapper.writeValueAsString(customData);
                this.localBucketing.setClientCustomData(this.sdkKey, customDataJSON);
            }
            catch (Exception e) {
                System.out.printf("Failed to set custom data: %s%n", e.getMessage());
            }
        }
    }

    public void close() {
        if (this.configManager != null) {
            this.configManager.cleanup();
        }
        if (this.eventQueueManager != null) {
            this.eventQueueManager.cleanup();
        }
    }

    private void validateUser(User user) {
        if (user == null) {
            throw new IllegalArgumentException("User cannot be null");
        }
        if (user.getUserId().equals("")) {
            throw new IllegalArgumentException("userId cannot be empty");
        }
    }

    private boolean isValidServerKey(String serverKey) {
        return serverKey.startsWith("server") || serverKey.startsWith("dvc_server");
    }

    private boolean isValidRuntime() {
        String arch = System.getProperty("os.arch");
        String model = System.getProperty("sun.arch.data.model");
        return arch.contains("x86") && model.contains("64");
    }
}

