/*
 * Decompiled with CFR 0.152.
 */
package com.devcycle.sdk.server.local.api;

import com.devcycle.sdk.server.common.api.IDVCApi;
import com.devcycle.sdk.server.common.interceptor.AuthorizationHeaderInterceptor;
import com.devcycle.sdk.server.local.model.DVCLocalOptions;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.Objects;
import okhttp3.Interceptor;
import okhttp3.OkHttpClient;
import retrofit2.Converter;
import retrofit2.Retrofit;
import retrofit2.converter.jackson.JacksonConverterFactory;

public final class DVCLocalEventsApiClient {
    private final OkHttpClient.Builder okBuilder;
    private final Retrofit.Builder adapterBuilder;
    private static final ObjectMapper OBJECT_MAPPER = new ObjectMapper();
    private static final String EVENTS_API_URL = "https://events.devcycle.com/";
    private String eventsApiUrl;

    private DVCLocalEventsApiClient(DVCLocalOptions options) {
        OBJECT_MAPPER.setSerializationInclusion(JsonInclude.Include.NON_NULL);
        this.okBuilder = new OkHttpClient.Builder();
        String eventsApiUrlFromOptions = options.getEventsApiBaseUrl();
        this.eventsApiUrl = this.checkIfStringNullOrEmpty(eventsApiUrlFromOptions) != false ? EVENTS_API_URL : eventsApiUrlFromOptions;
        this.eventsApiUrl = this.eventsApiUrl.endsWith("/") ? this.eventsApiUrl : this.eventsApiUrl + "/";
        this.adapterBuilder = new Retrofit.Builder().baseUrl(this.eventsApiUrl).addConverterFactory((Converter.Factory)JacksonConverterFactory.create());
    }

    public DVCLocalEventsApiClient(String sdkKey, DVCLocalOptions options) {
        this(options);
        this.okBuilder.addInterceptor((Interceptor)new AuthorizationHeaderInterceptor(sdkKey));
    }

    public IDVCApi initialize() {
        return (IDVCApi)this.adapterBuilder.client(this.okBuilder.build()).build().create(IDVCApi.class);
    }

    private Boolean checkIfStringNullOrEmpty(String stringToCheck) {
        return Objects.isNull(stringToCheck) || Objects.equals(stringToCheck, "");
    }
}

