/*
 * Decompiled with CFR 0.152.
 */
package com.devcycle.sdk.server.cloud.api;

import com.devcycle.sdk.server.cloud.model.DVCCloudOptions;
import com.devcycle.sdk.server.common.api.APIUtils;
import com.devcycle.sdk.server.common.api.IDVCApi;
import com.devcycle.sdk.server.common.interceptor.AuthorizationHeaderInterceptor;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.Objects;
import okhttp3.Interceptor;
import okhttp3.OkHttpClient;
import retrofit2.Converter;
import retrofit2.Retrofit;
import retrofit2.converter.jackson.JacksonConverterFactory;

public final class DVCCloudApiClient {
    private final OkHttpClient.Builder okBuilder;
    private final Retrofit.Builder adapterBuilder;
    private static final ObjectMapper OBJECT_MAPPER = new ObjectMapper();
    private static final String BUCKETING_URL = "https://bucketing-api.devcycle.com/";
    private String bucketingUrl;

    public DVCCloudApiClient(String apiKey, DVCCloudOptions options) {
        OBJECT_MAPPER.setSerializationInclusion(JsonInclude.Include.NON_NULL);
        this.okBuilder = new OkHttpClient.Builder();
        APIUtils.applyRestOptions(options.getRestOptions(), this.okBuilder);
        this.okBuilder.addInterceptor((Interceptor)new AuthorizationHeaderInterceptor(apiKey));
        this.bucketingUrl = this.isStringNullOrEmpty(options.getBaseURLOverride()) == false ? options.getBaseURLOverride() : BUCKETING_URL;
        this.bucketingUrl = this.bucketingUrl.endsWith("/") ? this.bucketingUrl : this.bucketingUrl + "/";
        this.adapterBuilder = new Retrofit.Builder().baseUrl(this.bucketingUrl).addConverterFactory((Converter.Factory)JacksonConverterFactory.create());
    }

    public IDVCApi initialize() {
        return (IDVCApi)this.adapterBuilder.client(this.okBuilder.build()).build().create(IDVCApi.class);
    }

    private Boolean isStringNullOrEmpty(String stringToCheck) {
        return Objects.isNull(stringToCheck) || Objects.equals(stringToCheck, "");
    }
}

