/*
 * Decompiled with CFR 0.152.
 */
package com.devcycle.sdk.server.local.model;

import com.devcycle.sdk.server.common.api.IRestOptions;
import com.devcycle.sdk.server.common.logging.DVCLogger;
import com.devcycle.sdk.server.common.logging.IDVCLogger;
import com.devcycle.sdk.server.common.model.IDVCOptions;
import com.fasterxml.jackson.annotation.JsonIgnore;

public class DVCLocalOptions
implements IDVCOptions {
    private int configRequestTimeoutMs = 10000;
    private int configPollingIntervalMS = 30000;
    private String configCdnBaseUrl = "https://config-cdn.devcycle.com/";
    private String eventsApiBaseUrl = "https://events.devcycle.com/";
    private int eventFlushIntervalMS = 10000;
    private int flushEventQueueSize = 1000;
    private int maxEventQueueSize = 2000;
    private int eventRequestChunkSize = 100;
    private boolean disableAutomaticEventLogging = false;
    @JsonIgnore
    private IDVCLogger customLogger = null;
    private boolean disableCustomEventLogging = false;
    @JsonIgnore
    private IRestOptions restOptions = null;

    public int getConfigPollingIntervalMS(int configPollingIntervalMs, int configPollingIntervalMS) {
        if (configPollingIntervalMS > 0) {
            return configPollingIntervalMS;
        }
        if (configPollingIntervalMs > 0) {
            return configPollingIntervalMs;
        }
        return this.configPollingIntervalMS;
    }

    public DVCLocalOptions(int configRequestTimeoutMs, @Deprecated int configPollingIntervalMs, int configPollingIntervalMS, String configCdnBaseUrl, String eventsApiBaseUrl, int eventFlushIntervalMS, int flushEventQueueSize, int maxEventQueueSize, int eventRequestChunkSize, boolean disableAutomaticEventLogging, boolean disableCustomEventLogging, IDVCLogger customLogger, IRestOptions restOptions) {
        this.configRequestTimeoutMs = configRequestTimeoutMs > 0 ? configRequestTimeoutMs : this.configRequestTimeoutMs;
        this.configPollingIntervalMS = this.getConfigPollingIntervalMS(configPollingIntervalMs, configPollingIntervalMS);
        this.configCdnBaseUrl = configCdnBaseUrl != null ? configCdnBaseUrl : this.configCdnBaseUrl;
        this.eventsApiBaseUrl = eventsApiBaseUrl != null ? eventsApiBaseUrl : this.eventsApiBaseUrl;
        this.eventFlushIntervalMS = eventFlushIntervalMS > 0 ? eventFlushIntervalMS : this.eventFlushIntervalMS;
        this.flushEventQueueSize = flushEventQueueSize > 0 ? flushEventQueueSize : this.flushEventQueueSize;
        this.maxEventQueueSize = maxEventQueueSize > 0 ? maxEventQueueSize : this.maxEventQueueSize;
        this.eventRequestChunkSize = eventRequestChunkSize > 0 ? eventRequestChunkSize : this.eventRequestChunkSize;
        this.disableAutomaticEventLogging = disableAutomaticEventLogging;
        this.disableCustomEventLogging = disableCustomEventLogging;
        this.customLogger = customLogger;
        this.restOptions = restOptions;
        if (this.flushEventQueueSize >= this.maxEventQueueSize) {
            DVCLogger.warning("flushEventQueueSize: " + this.flushEventQueueSize + " must be smaller than maxEventQueueSize: " + this.maxEventQueueSize);
            this.flushEventQueueSize = this.maxEventQueueSize - 1;
        }
        if (this.eventRequestChunkSize > this.flushEventQueueSize) {
            DVCLogger.warning("eventRequestChunkSize: " + this.eventRequestChunkSize + " must be smaller than flushEventQueueSize: " + this.flushEventQueueSize);
            this.eventRequestChunkSize = 100;
        }
        if (this.eventRequestChunkSize > this.maxEventQueueSize) {
            DVCLogger.warning("eventRequestChunkSize: " + this.eventRequestChunkSize + " must be smaller than maxEventQueueSize: " + this.maxEventQueueSize);
            this.eventRequestChunkSize = 100;
        }
        if (this.flushEventQueueSize > 20000) {
            DVCLogger.warning("flushEventQueueSize: " + this.flushEventQueueSize + " must be smaller than 20,000");
            this.flushEventQueueSize = 20000;
        }
        if (this.maxEventQueueSize > 20000) {
            DVCLogger.warning("maxEventQueueSize: " + this.maxEventQueueSize + " must be smaller than 20,000");
            this.maxEventQueueSize = 20000;
        }
    }

    public static DVCLocalOptionsBuilder builder() {
        return new DVCLocalOptionsBuilder();
    }

    public int getConfigRequestTimeoutMs() {
        return this.configRequestTimeoutMs;
    }

    public int getConfigPollingIntervalMS() {
        return this.configPollingIntervalMS;
    }

    public String getConfigCdnBaseUrl() {
        return this.configCdnBaseUrl;
    }

    public String getEventsApiBaseUrl() {
        return this.eventsApiBaseUrl;
    }

    public int getEventFlushIntervalMS() {
        return this.eventFlushIntervalMS;
    }

    public int getFlushEventQueueSize() {
        return this.flushEventQueueSize;
    }

    public int getMaxEventQueueSize() {
        return this.maxEventQueueSize;
    }

    public int getEventRequestChunkSize() {
        return this.eventRequestChunkSize;
    }

    public boolean isDisableAutomaticEventLogging() {
        return this.disableAutomaticEventLogging;
    }

    public IDVCLogger getCustomLogger() {
        return this.customLogger;
    }

    public boolean isDisableCustomEventLogging() {
        return this.disableCustomEventLogging;
    }

    public IRestOptions getRestOptions() {
        return this.restOptions;
    }

    public void setConfigRequestTimeoutMs(int configRequestTimeoutMs) {
        this.configRequestTimeoutMs = configRequestTimeoutMs;
    }

    public void setConfigPollingIntervalMS(int configPollingIntervalMS) {
        this.configPollingIntervalMS = configPollingIntervalMS;
    }

    public void setConfigCdnBaseUrl(String configCdnBaseUrl) {
        this.configCdnBaseUrl = configCdnBaseUrl;
    }

    public void setEventsApiBaseUrl(String eventsApiBaseUrl) {
        this.eventsApiBaseUrl = eventsApiBaseUrl;
    }

    public void setEventFlushIntervalMS(int eventFlushIntervalMS) {
        this.eventFlushIntervalMS = eventFlushIntervalMS;
    }

    public void setFlushEventQueueSize(int flushEventQueueSize) {
        this.flushEventQueueSize = flushEventQueueSize;
    }

    public void setMaxEventQueueSize(int maxEventQueueSize) {
        this.maxEventQueueSize = maxEventQueueSize;
    }

    public void setEventRequestChunkSize(int eventRequestChunkSize) {
        this.eventRequestChunkSize = eventRequestChunkSize;
    }

    public void setDisableAutomaticEventLogging(boolean disableAutomaticEventLogging) {
        this.disableAutomaticEventLogging = disableAutomaticEventLogging;
    }

    @JsonIgnore
    public void setCustomLogger(IDVCLogger customLogger) {
        this.customLogger = customLogger;
    }

    public void setDisableCustomEventLogging(boolean disableCustomEventLogging) {
        this.disableCustomEventLogging = disableCustomEventLogging;
    }

    @JsonIgnore
    public void setRestOptions(IRestOptions restOptions) {
        this.restOptions = restOptions;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof DVCLocalOptions)) {
            return false;
        }
        DVCLocalOptions other = (DVCLocalOptions)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getConfigRequestTimeoutMs() != other.getConfigRequestTimeoutMs()) {
            return false;
        }
        if (this.getConfigPollingIntervalMS() != other.getConfigPollingIntervalMS()) {
            return false;
        }
        if (this.getEventFlushIntervalMS() != other.getEventFlushIntervalMS()) {
            return false;
        }
        if (this.getFlushEventQueueSize() != other.getFlushEventQueueSize()) {
            return false;
        }
        if (this.getMaxEventQueueSize() != other.getMaxEventQueueSize()) {
            return false;
        }
        if (this.getEventRequestChunkSize() != other.getEventRequestChunkSize()) {
            return false;
        }
        if (this.isDisableAutomaticEventLogging() != other.isDisableAutomaticEventLogging()) {
            return false;
        }
        if (this.isDisableCustomEventLogging() != other.isDisableCustomEventLogging()) {
            return false;
        }
        String this$configCdnBaseUrl = this.getConfigCdnBaseUrl();
        String other$configCdnBaseUrl = other.getConfigCdnBaseUrl();
        if (this$configCdnBaseUrl == null ? other$configCdnBaseUrl != null : !this$configCdnBaseUrl.equals(other$configCdnBaseUrl)) {
            return false;
        }
        String this$eventsApiBaseUrl = this.getEventsApiBaseUrl();
        String other$eventsApiBaseUrl = other.getEventsApiBaseUrl();
        if (this$eventsApiBaseUrl == null ? other$eventsApiBaseUrl != null : !this$eventsApiBaseUrl.equals(other$eventsApiBaseUrl)) {
            return false;
        }
        IDVCLogger this$customLogger = this.getCustomLogger();
        IDVCLogger other$customLogger = other.getCustomLogger();
        if (this$customLogger == null ? other$customLogger != null : !this$customLogger.equals(other$customLogger)) {
            return false;
        }
        IRestOptions this$restOptions = this.getRestOptions();
        IRestOptions other$restOptions = other.getRestOptions();
        return !(this$restOptions == null ? other$restOptions != null : !this$restOptions.equals(other$restOptions));
    }

    protected boolean canEqual(Object other) {
        return other instanceof DVCLocalOptions;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getConfigRequestTimeoutMs();
        result = result * 59 + this.getConfigPollingIntervalMS();
        result = result * 59 + this.getEventFlushIntervalMS();
        result = result * 59 + this.getFlushEventQueueSize();
        result = result * 59 + this.getMaxEventQueueSize();
        result = result * 59 + this.getEventRequestChunkSize();
        result = result * 59 + (this.isDisableAutomaticEventLogging() ? 79 : 97);
        result = result * 59 + (this.isDisableCustomEventLogging() ? 79 : 97);
        String $configCdnBaseUrl = this.getConfigCdnBaseUrl();
        result = result * 59 + ($configCdnBaseUrl == null ? 43 : $configCdnBaseUrl.hashCode());
        String $eventsApiBaseUrl = this.getEventsApiBaseUrl();
        result = result * 59 + ($eventsApiBaseUrl == null ? 43 : $eventsApiBaseUrl.hashCode());
        IDVCLogger $customLogger = this.getCustomLogger();
        result = result * 59 + ($customLogger == null ? 43 : $customLogger.hashCode());
        IRestOptions $restOptions = this.getRestOptions();
        result = result * 59 + ($restOptions == null ? 43 : $restOptions.hashCode());
        return result;
    }

    public String toString() {
        return "DVCLocalOptions(configRequestTimeoutMs=" + this.getConfigRequestTimeoutMs() + ", configPollingIntervalMS=" + this.getConfigPollingIntervalMS() + ", configCdnBaseUrl=" + this.getConfigCdnBaseUrl() + ", eventsApiBaseUrl=" + this.getEventsApiBaseUrl() + ", eventFlushIntervalMS=" + this.getEventFlushIntervalMS() + ", flushEventQueueSize=" + this.getFlushEventQueueSize() + ", maxEventQueueSize=" + this.getMaxEventQueueSize() + ", eventRequestChunkSize=" + this.getEventRequestChunkSize() + ", disableAutomaticEventLogging=" + this.isDisableAutomaticEventLogging() + ", customLogger=" + this.getCustomLogger() + ", disableCustomEventLogging=" + this.isDisableCustomEventLogging() + ", restOptions=" + this.getRestOptions() + ")";
    }

    public static class DVCLocalOptionsBuilder {
        private int configRequestTimeoutMs;
        private int configPollingIntervalMs;
        private int configPollingIntervalMS;
        private String configCdnBaseUrl;
        private String eventsApiBaseUrl;
        private int eventFlushIntervalMS;
        private int flushEventQueueSize;
        private int maxEventQueueSize;
        private int eventRequestChunkSize;
        private boolean disableAutomaticEventLogging;
        private boolean disableCustomEventLogging;
        private IDVCLogger customLogger;
        private IRestOptions restOptions;

        DVCLocalOptionsBuilder() {
        }

        public DVCLocalOptionsBuilder configRequestTimeoutMs(int configRequestTimeoutMs) {
            this.configRequestTimeoutMs = configRequestTimeoutMs;
            return this;
        }

        @Deprecated
        public DVCLocalOptionsBuilder configPollingIntervalMs(int configPollingIntervalMs) {
            this.configPollingIntervalMs = configPollingIntervalMs;
            return this;
        }

        public DVCLocalOptionsBuilder configPollingIntervalMS(int configPollingIntervalMS) {
            this.configPollingIntervalMS = configPollingIntervalMS;
            return this;
        }

        public DVCLocalOptionsBuilder configCdnBaseUrl(String configCdnBaseUrl) {
            this.configCdnBaseUrl = configCdnBaseUrl;
            return this;
        }

        public DVCLocalOptionsBuilder eventsApiBaseUrl(String eventsApiBaseUrl) {
            this.eventsApiBaseUrl = eventsApiBaseUrl;
            return this;
        }

        public DVCLocalOptionsBuilder eventFlushIntervalMS(int eventFlushIntervalMS) {
            this.eventFlushIntervalMS = eventFlushIntervalMS;
            return this;
        }

        public DVCLocalOptionsBuilder flushEventQueueSize(int flushEventQueueSize) {
            this.flushEventQueueSize = flushEventQueueSize;
            return this;
        }

        public DVCLocalOptionsBuilder maxEventQueueSize(int maxEventQueueSize) {
            this.maxEventQueueSize = maxEventQueueSize;
            return this;
        }

        public DVCLocalOptionsBuilder eventRequestChunkSize(int eventRequestChunkSize) {
            this.eventRequestChunkSize = eventRequestChunkSize;
            return this;
        }

        public DVCLocalOptionsBuilder disableAutomaticEventLogging(boolean disableAutomaticEventLogging) {
            this.disableAutomaticEventLogging = disableAutomaticEventLogging;
            return this;
        }

        public DVCLocalOptionsBuilder disableCustomEventLogging(boolean disableCustomEventLogging) {
            this.disableCustomEventLogging = disableCustomEventLogging;
            return this;
        }

        public DVCLocalOptionsBuilder customLogger(IDVCLogger customLogger) {
            this.customLogger = customLogger;
            return this;
        }

        public DVCLocalOptionsBuilder restOptions(IRestOptions restOptions) {
            this.restOptions = restOptions;
            return this;
        }

        public DVCLocalOptions build() {
            return new DVCLocalOptions(this.configRequestTimeoutMs, this.configPollingIntervalMs, this.configPollingIntervalMS, this.configCdnBaseUrl, this.eventsApiBaseUrl, this.eventFlushIntervalMS, this.flushEventQueueSize, this.maxEventQueueSize, this.eventRequestChunkSize, this.disableAutomaticEventLogging, this.disableCustomEventLogging, this.customLogger, this.restOptions);
        }

        public String toString() {
            return "DVCLocalOptions.DVCLocalOptionsBuilder(configRequestTimeoutMs=" + this.configRequestTimeoutMs + ", configPollingIntervalMs=" + this.configPollingIntervalMs + ", configPollingIntervalMS=" + this.configPollingIntervalMS + ", configCdnBaseUrl=" + this.configCdnBaseUrl + ", eventsApiBaseUrl=" + this.eventsApiBaseUrl + ", eventFlushIntervalMS=" + this.eventFlushIntervalMS + ", flushEventQueueSize=" + this.flushEventQueueSize + ", maxEventQueueSize=" + this.maxEventQueueSize + ", eventRequestChunkSize=" + this.eventRequestChunkSize + ", disableAutomaticEventLogging=" + this.disableAutomaticEventLogging + ", disableCustomEventLogging=" + this.disableCustomEventLogging + ", customLogger=" + this.customLogger + ", restOptions=" + this.restOptions + ")";
        }
    }
}

