/*
 * Decompiled with CFR 0.152.
 */
package com.devcycle.sdk.server.cloud.api;

import com.devcycle.sdk.server.cloud.api.DevCycleCloudApiClient;
import com.devcycle.sdk.server.cloud.model.DevCycleCloudOptions;
import com.devcycle.sdk.server.common.api.IDevCycleApi;
import com.devcycle.sdk.server.common.exception.DevCycleException;
import com.devcycle.sdk.server.common.logging.DevCycleLogger;
import com.devcycle.sdk.server.common.model.BaseVariable;
import com.devcycle.sdk.server.common.model.DevCycleEvent;
import com.devcycle.sdk.server.common.model.DevCycleResponse;
import com.devcycle.sdk.server.common.model.DevCycleUser;
import com.devcycle.sdk.server.common.model.DevCycleUserAndEvents;
import com.devcycle.sdk.server.common.model.ErrorResponse;
import com.devcycle.sdk.server.common.model.Feature;
import com.devcycle.sdk.server.common.model.HttpResponseCode;
import com.devcycle.sdk.server.common.model.Variable;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.exc.MismatchedInputException;
import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import retrofit2.Call;
import retrofit2.Response;

public final class DevCycleCloudClient {
    private final IDevCycleApi api;
    private final DevCycleCloudOptions dvcOptions;
    private static final ObjectMapper OBJECT_MAPPER = new ObjectMapper();

    public DevCycleCloudClient(String sdkKey) {
        this(sdkKey, DevCycleCloudOptions.builder().build());
    }

    public DevCycleCloudClient(String sdkKey, DevCycleCloudOptions options) {
        if (sdkKey == null || sdkKey.equals("")) {
            throw new IllegalArgumentException("Missing environment key! Call initialize with a valid environment key");
        }
        if (!this.isValidServerKey(sdkKey)) {
            throw new IllegalArgumentException("Invalid environment key provided. Please call initialize with a valid server environment key");
        }
        if (options.getCustomLogger() != null) {
            DevCycleLogger.setCustomLogger(options.getCustomLogger());
        }
        this.dvcOptions = options;
        this.api = new DevCycleCloudApiClient(sdkKey, options).initialize();
        OBJECT_MAPPER.setSerializationInclusion(JsonInclude.Include.NON_NULL);
    }

    public Map<String, Feature> allFeatures(DevCycleUser user) throws DevCycleException {
        this.validateUser(user);
        Call<Map<String, Feature>> response = this.api.getFeatures(user, this.dvcOptions.getEnableEdgeDB());
        return this.getResponse(response);
    }

    public <T> T variableValue(DevCycleUser user, String key, T defaultValue) throws DevCycleException {
        return this.variable(user, key, defaultValue).getValue();
    }

    public <T> Variable<T> variable(DevCycleUser user, String key, T defaultValue) throws DevCycleException {
        Variable variable;
        this.validateUser(user);
        if (key == null || key.equals("")) {
            ErrorResponse errorResponse = new ErrorResponse(500, "Missing parameter: key", null);
            throw new DevCycleException(HttpResponseCode.byCode(500), errorResponse);
        }
        if (defaultValue == null) {
            ErrorResponse errorResponse = new ErrorResponse(500, "Missing parameter: defaultValue", null);
            throw new DevCycleException(HttpResponseCode.byCode(500), errorResponse);
        }
        Variable.TypeEnum variableType = Variable.TypeEnum.fromClass(defaultValue.getClass());
        try {
            Call<Variable> response = this.api.getVariableByKey(user, key, this.dvcOptions.getEnableEdgeDB());
            variable = this.getResponseWithRetries(response, 5);
            if (variable.getType() != variableType) {
                throw new IllegalArgumentException("Variable type mismatch, returning default value");
            }
            variable.setIsDefaulted(false);
        }
        catch (Exception exception) {
            variable = Variable.builder().key(key).type(variableType).value(defaultValue).defaultValue(defaultValue).isDefaulted(true).build();
        }
        return variable;
    }

    public Map<String, BaseVariable> allVariables(DevCycleUser user) throws DevCycleException {
        this.validateUser(user);
        Call<Map<String, BaseVariable>> response = this.api.getVariables(user, this.dvcOptions.getEnableEdgeDB());
        try {
            Map<String, BaseVariable> variablesResponse = this.getResponse(response);
            return variablesResponse;
        }
        catch (DevCycleException exception) {
            if (exception.getHttpResponseCode() == HttpResponseCode.SERVER_ERROR) {
                return new HashMap<String, BaseVariable>();
            }
            throw exception;
        }
    }

    public void track(DevCycleUser user, DevCycleEvent event) throws DevCycleException {
        this.validateUser(user);
        if (event == null || event.getType() == null || event.getType().equals("")) {
            throw new IllegalArgumentException("Invalid DevCycleEvent");
        }
        DevCycleUserAndEvents userAndEvents = DevCycleUserAndEvents.builder().user(user).events(Collections.singletonList(event)).build();
        Call<DevCycleResponse> response = this.api.track(userAndEvents, this.dvcOptions.getEnableEdgeDB());
        this.getResponseWithRetries(response, 5);
    }

    private <T> T getResponseWithRetries(Call<T> call, int maxRetries) throws DevCycleException {
        int attempt = 0;
        while (true) {
            try {
                return this.getResponse(call);
            }
            catch (DevCycleException e) {
                if (!e.isRetryable() || ++attempt > maxRetries) {
                    throw e;
                }
                try {
                    long waitIntervalMS = (long)(10.0 * Math.pow(2.0, attempt));
                    Thread.sleep(waitIntervalMS);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                call = call.clone();
                if (attempt <= maxRetries) continue;
                ErrorResponse errorResponse = ErrorResponse.builder().build();
                errorResponse.setMessage("Out of retry attempts");
                throw new DevCycleException(HttpResponseCode.SERVER_ERROR, errorResponse);
            }
            break;
        }
    }

    private <T> T getResponse(Call<T> call) throws DevCycleException {
        Response response;
        ErrorResponse errorResponse = ErrorResponse.builder().build();
        try {
            response = call.execute();
        }
        catch (MismatchedInputException mie) {
            errorResponse.setMessage(mie.getMessage());
            throw new DevCycleException(HttpResponseCode.NO_CONTENT, errorResponse);
        }
        catch (IOException e) {
            errorResponse.setMessage(e.getMessage());
            throw new DevCycleException(HttpResponseCode.byCode(500), errorResponse);
        }
        HttpResponseCode httpResponseCode = HttpResponseCode.byCode(response.code());
        errorResponse.setMessage("Unknown error");
        if (response.errorBody() != null) {
            try {
                errorResponse = (ErrorResponse)OBJECT_MAPPER.readValue(response.errorBody().string(), ErrorResponse.class);
            }
            catch (IOException e) {
                errorResponse.setMessage(e.getMessage());
                throw new DevCycleException(httpResponseCode, errorResponse);
            }
            throw new DevCycleException(httpResponseCode, errorResponse);
        }
        if (response.body() == null) {
            throw new DevCycleException(httpResponseCode, errorResponse);
        }
        if (response.isSuccessful()) {
            return (T)response.body();
        }
        if (httpResponseCode == HttpResponseCode.UNAUTHORIZED) {
            errorResponse.setMessage("Invalid SDK Key");
        } else if (!response.message().equals("")) {
            try {
                errorResponse = (ErrorResponse)OBJECT_MAPPER.readValue(response.message(), ErrorResponse.class);
            }
            catch (JsonProcessingException e) {
                errorResponse.setMessage(e.getMessage());
                throw new DevCycleException(httpResponseCode, errorResponse);
            }
        }
        throw new DevCycleException(httpResponseCode, errorResponse);
    }

    private boolean isValidServerKey(String serverKey) {
        return serverKey.startsWith("server") || serverKey.startsWith("dvc_server");
    }

    private void validateUser(DevCycleUser user) {
        if (user == null) {
            throw new IllegalArgumentException("DevCycleUser cannot be null");
        }
        if (user.getUserId().equals("")) {
            throw new IllegalArgumentException("userId cannot be empty");
        }
    }
}

