/*
 * Decompiled with CFR 0.152.
 */
package com.devcycle.sdk.server.local.managers;

import com.devcycle.sdk.server.common.api.IDevCycleApi;
import com.devcycle.sdk.server.common.logging.DevCycleLogger;
import com.devcycle.sdk.server.common.model.DevCycleEvent;
import com.devcycle.sdk.server.common.model.DevCycleResponse;
import com.devcycle.sdk.server.common.model.DevCycleUser;
import com.devcycle.sdk.server.local.api.DevCycleLocalEventsApiClient;
import com.devcycle.sdk.server.local.bucketing.LocalBucketing;
import com.devcycle.sdk.server.local.managers.DaemonThreadFactory;
import com.devcycle.sdk.server.local.model.BucketedUserConfig;
import com.devcycle.sdk.server.local.model.DevCycleLocalOptions;
import com.devcycle.sdk.server.local.model.EventsBatch;
import com.devcycle.sdk.server.local.model.FlushPayload;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.util.Arrays;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import retrofit2.Call;
import retrofit2.Response;

public class EventQueueManager {
    private LocalBucketing localBucketing;
    private final String sdkKey;
    private static final ObjectMapper OBJECT_MAPPER = new ObjectMapper();
    private IDevCycleApi eventsApiClient;
    private int eventFlushIntervalMS;
    private final ScheduledExecutorService scheduler = Executors.newScheduledThreadPool(1, new DaemonThreadFactory());
    private boolean isFlushingEvents = false;
    private int flushEventQueueSize;
    private int maxEventQueueSize;

    public EventQueueManager(String sdkKey, LocalBucketing localBucketing, DevCycleLocalOptions options) throws Exception {
        this.localBucketing = localBucketing;
        this.sdkKey = sdkKey;
        this.eventFlushIntervalMS = options.getEventFlushIntervalMS();
        this.flushEventQueueSize = options.getFlushEventQueueSize();
        this.maxEventQueueSize = options.getMaxEventQueueSize();
        this.eventsApiClient = new DevCycleLocalEventsApiClient(sdkKey, options).initialize();
        OBJECT_MAPPER.setSerializationInclusion(JsonInclude.Include.NON_NULL);
        this.localBucketing.initEventQueue(sdkKey, OBJECT_MAPPER.writeValueAsString((Object)options));
        this.setupScheduler();
    }

    private void setupScheduler() {
        Runnable flushEventsRunnable = () -> {
            try {
                this.flushEvents();
            }
            catch (Exception e) {
                DevCycleLogger.error("DevCycle Error flushing events: " + e.getMessage(), e);
            }
        };
        this.scheduler.scheduleAtFixedRate(flushEventsRunnable, 0L, this.eventFlushIntervalMS, TimeUnit.MILLISECONDS);
    }

    public synchronized void flushEvents() throws Exception {
        if (this.isFlushingEvents) {
            return;
        }
        if (this.sdkKey == null || this.sdkKey.equals("")) {
            throw new Exception("DevCycle is not yet initialized to publish events.");
        }
        Object[] flushPayloads = new FlushPayload[]{};
        try {
            flushPayloads = this.localBucketing.flushEventQueue(this.sdkKey);
        }
        catch (Exception e) {
            DevCycleLogger.error("DevCycle Error flushing event payloads: " + e.getMessage(), e);
        }
        if (flushPayloads.length == 0) {
            return;
        }
        DevCycleLogger.debug("DevCycle Flush Payloads: " + Arrays.toString(flushPayloads));
        int eventCount = 0;
        this.isFlushingEvents = true;
        for (Object payload : flushPayloads) {
            eventCount += ((FlushPayload)payload).eventCount;
            this.publishEvents(this.sdkKey, (FlushPayload)payload);
        }
        this.isFlushingEvents = false;
        DevCycleLogger.debug(String.format("DevCycle Flush %d AS Events, for %d Users", eventCount, flushPayloads.length));
    }

    public void queueEvent(DevCycleUser user, DevCycleEvent event) throws Exception {
        if (this.checkEventQueueSize()) {
            DevCycleLogger.warning("Max event queue size reached, dropping event: " + event);
            return;
        }
        this.localBucketing.queueEvent(this.sdkKey, OBJECT_MAPPER.writeValueAsString((Object)user), OBJECT_MAPPER.writeValueAsString((Object)event));
    }

    public void queueAggregateEvent(DevCycleEvent event, BucketedUserConfig bucketedConfig) throws Exception {
        if (this.checkEventQueueSize()) {
            DevCycleLogger.warning("Max event queue size reached, dropping aggregate event: " + event);
            return;
        }
        if (bucketedConfig != null) {
            this.localBucketing.queueAggregateEvent(this.sdkKey, OBJECT_MAPPER.writeValueAsString((Object)event), OBJECT_MAPPER.writeValueAsString(bucketedConfig.variableVariationMap));
        } else {
            this.localBucketing.queueAggregateEvent(this.sdkKey, OBJECT_MAPPER.writeValueAsString((Object)event), "{}");
        }
    }

    private void publishEvents(String sdkKey, FlushPayload flushPayload) throws InterruptedException {
        Call<DevCycleResponse> response = this.eventsApiClient.publishEvents(EventsBatch.builder().batch(flushPayload.records).build());
        int responseCode = this.getResponse(response);
        if (responseCode == 201) {
            this.localBucketing.onPayloadSuccess(sdkKey, flushPayload.payloadId);
        } else {
            DevCycleLogger.warning("DevCycle Error Publishing Events: " + responseCode);
            this.localBucketing.onPayloadFailure(sdkKey, flushPayload.payloadId, responseCode >= 500);
        }
    }

    private int getResponse(Call call) {
        Response response = null;
        try {
            response = call.execute();
        }
        catch (IOException e) {
            DevCycleLogger.error("DevCycle Events error: " + e.getMessage(), e);
        }
        if (response == null) {
            return 500;
        }
        return response.code();
    }

    private boolean checkEventQueueSize() throws Exception {
        int queueSize = this.localBucketing.getEventQueueSize(this.sdkKey);
        if (queueSize >= this.flushEventQueueSize) {
            if (!this.isFlushingEvents) {
                this.flushEvents();
            }
            if (queueSize >= this.maxEventQueueSize) {
                return true;
            }
        }
        return false;
    }

    public void cleanup() {
        try {
            this.flushEvents();
        }
        catch (Exception e) {
            DevCycleLogger.error("DevCycle Cleanup error: " + e.getMessage(), e);
        }
        this.scheduler.shutdown();
    }
}

