/*
 * Decompiled with CFR 0.152.
 */
package com.devcycle.sdk.server.common.model;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.Arrays;

@JsonIgnoreProperties(ignoreUnknown=true)
public class ProjectConfig {
    @Schema(description="Project Settings")
    private Object project;
    @Schema(description="Environment Key & ID")
    private Object environment;
    @Schema(description="List of Features in this Project")
    private Object[] features;
    @Schema(description="List of Variables in this Project")
    private Object[] variables;
    @Schema(description="Audiences in this Project indexed by ID")
    private Object audiences;
    @Schema(description="Variable Hashes for all Variables in this Project")
    private Object variableHashes;

    public static ProjectConfigBuilder builder() {
        return new ProjectConfigBuilder();
    }

    public Object getProject() {
        return this.project;
    }

    public Object getEnvironment() {
        return this.environment;
    }

    public Object[] getFeatures() {
        return this.features;
    }

    public Object[] getVariables() {
        return this.variables;
    }

    public Object getAudiences() {
        return this.audiences;
    }

    public Object getVariableHashes() {
        return this.variableHashes;
    }

    public void setProject(Object project) {
        this.project = project;
    }

    public void setEnvironment(Object environment) {
        this.environment = environment;
    }

    public void setFeatures(Object[] features) {
        this.features = features;
    }

    public void setVariables(Object[] variables) {
        this.variables = variables;
    }

    public void setAudiences(Object audiences) {
        this.audiences = audiences;
    }

    public void setVariableHashes(Object variableHashes) {
        this.variableHashes = variableHashes;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ProjectConfig)) {
            return false;
        }
        ProjectConfig other = (ProjectConfig)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Object this$project = this.getProject();
        Object other$project = other.getProject();
        if (this$project == null ? other$project != null : !this$project.equals(other$project)) {
            return false;
        }
        Object this$environment = this.getEnvironment();
        Object other$environment = other.getEnvironment();
        if (this$environment == null ? other$environment != null : !this$environment.equals(other$environment)) {
            return false;
        }
        if (!Arrays.deepEquals(this.getFeatures(), other.getFeatures())) {
            return false;
        }
        if (!Arrays.deepEquals(this.getVariables(), other.getVariables())) {
            return false;
        }
        Object this$audiences = this.getAudiences();
        Object other$audiences = other.getAudiences();
        if (this$audiences == null ? other$audiences != null : !this$audiences.equals(other$audiences)) {
            return false;
        }
        Object this$variableHashes = this.getVariableHashes();
        Object other$variableHashes = other.getVariableHashes();
        return !(this$variableHashes == null ? other$variableHashes != null : !this$variableHashes.equals(other$variableHashes));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ProjectConfig;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Object $project = this.getProject();
        result = result * 59 + ($project == null ? 43 : $project.hashCode());
        Object $environment = this.getEnvironment();
        result = result * 59 + ($environment == null ? 43 : $environment.hashCode());
        result = result * 59 + Arrays.deepHashCode(this.getFeatures());
        result = result * 59 + Arrays.deepHashCode(this.getVariables());
        Object $audiences = this.getAudiences();
        result = result * 59 + ($audiences == null ? 43 : $audiences.hashCode());
        Object $variableHashes = this.getVariableHashes();
        result = result * 59 + ($variableHashes == null ? 43 : $variableHashes.hashCode());
        return result;
    }

    public String toString() {
        return "ProjectConfig(project=" + this.getProject() + ", environment=" + this.getEnvironment() + ", features=" + Arrays.deepToString(this.getFeatures()) + ", variables=" + Arrays.deepToString(this.getVariables()) + ", audiences=" + this.getAudiences() + ", variableHashes=" + this.getVariableHashes() + ")";
    }

    public ProjectConfig(Object project, Object environment, Object[] features, Object[] variables, Object audiences, Object variableHashes) {
        this.project = project;
        this.environment = environment;
        this.features = features;
        this.variables = variables;
        this.audiences = audiences;
        this.variableHashes = variableHashes;
    }

    public ProjectConfig() {
    }

    public static class ProjectConfigBuilder {
        private Object project;
        private Object environment;
        private Object[] features;
        private Object[] variables;
        private Object audiences;
        private Object variableHashes;

        ProjectConfigBuilder() {
        }

        public ProjectConfigBuilder project(Object project) {
            this.project = project;
            return this;
        }

        public ProjectConfigBuilder environment(Object environment) {
            this.environment = environment;
            return this;
        }

        public ProjectConfigBuilder features(Object[] features) {
            this.features = features;
            return this;
        }

        public ProjectConfigBuilder variables(Object[] variables) {
            this.variables = variables;
            return this;
        }

        public ProjectConfigBuilder audiences(Object audiences) {
            this.audiences = audiences;
            return this;
        }

        public ProjectConfigBuilder variableHashes(Object variableHashes) {
            this.variableHashes = variableHashes;
            return this;
        }

        public ProjectConfig build() {
            return new ProjectConfig(this.project, this.environment, this.features, this.variables, this.audiences, this.variableHashes);
        }

        public String toString() {
            return "ProjectConfig.ProjectConfigBuilder(project=" + this.project + ", environment=" + this.environment + ", features=" + Arrays.deepToString(this.features) + ", variables=" + Arrays.deepToString(this.variables) + ", audiences=" + this.audiences + ", variableHashes=" + this.variableHashes + ")";
        }
    }
}

