/*
 * Decompiled with CFR 0.152.
 */
package com.devcycle.sdk.server.common.model;

import com.devcycle.sdk.server.common.logging.DevCycleLogger;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import io.swagger.v3.oas.annotations.media.Schema;
import java.net.InetAddress;
import java.net.UnknownHostException;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class PlatformData {
    @Schema(description="Platform the SDK is running on")
    private String platform;
    @Schema(description="Version of the platform the SDK is running on")
    private String platformVersion;
    @Schema(description="DevCycle SDK type")
    private SdkTypeEnum sdkType;
    @Schema(description="DevCycle SDK Version")
    private String sdkVersion;
    @Schema(description="Hostname where the SDK is running")
    private String hostname;

    public PlatformData(String platform, String platformVersion, SdkTypeEnum sdkType, String sdkVersion, String hostname) {
        this.platform = platform;
        this.platformVersion = platformVersion;
        this.sdkType = sdkType;
        this.sdkVersion = sdkVersion;
        try {
            this.hostname = hostname != null ? hostname : InetAddress.getLocalHost().getHostName();
        }
        catch (UnknownHostException e) {
            DevCycleLogger.warning("Error getting system hostname: " + e.getMessage());
            this.hostname = "";
        }
    }

    public String toString() {
        ObjectMapper mapper = new ObjectMapper();
        ObjectNode platformData = mapper.createObjectNode();
        platformData.put("platform", this.platform);
        platformData.put("platformVersion", this.platformVersion);
        platformData.put("sdkType", this.sdkType.toString());
        platformData.put("sdkVersion", this.sdkVersion);
        platformData.put("hostname", this.hostname);
        String platformDataString = null;
        try {
            mapper.setSerializationInclusion(JsonInclude.Include.NON_NULL);
            platformDataString = mapper.writeValueAsString((Object)platformData);
        }
        catch (JsonProcessingException e) {
            DevCycleLogger.warning("Error reading platformData: " + e.getMessage());
        }
        return platformDataString;
    }

    private static String $default$platform() {
        return "Java";
    }

    private static String $default$platformVersion() {
        return System.getProperty("java.version");
    }

    private static SdkTypeEnum $default$sdkType() {
        return SdkTypeEnum.SERVER;
    }

    private static String $default$sdkVersion() {
        return "2.4.0";
    }

    public static PlatformDataBuilder builder() {
        return new PlatformDataBuilder();
    }

    public String getPlatform() {
        return this.platform;
    }

    public String getPlatformVersion() {
        return this.platformVersion;
    }

    public SdkTypeEnum getSdkType() {
        return this.sdkType;
    }

    public String getSdkVersion() {
        return this.sdkVersion;
    }

    public String getHostname() {
        return this.hostname;
    }

    public void setPlatform(String platform) {
        this.platform = platform;
    }

    public void setPlatformVersion(String platformVersion) {
        this.platformVersion = platformVersion;
    }

    public void setSdkType(SdkTypeEnum sdkType) {
        this.sdkType = sdkType;
    }

    public void setSdkVersion(String sdkVersion) {
        this.sdkVersion = sdkVersion;
    }

    public void setHostname(String hostname) {
        this.hostname = hostname;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof PlatformData)) {
            return false;
        }
        PlatformData other = (PlatformData)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$platform = this.getPlatform();
        String other$platform = other.getPlatform();
        if (this$platform == null ? other$platform != null : !this$platform.equals(other$platform)) {
            return false;
        }
        String this$platformVersion = this.getPlatformVersion();
        String other$platformVersion = other.getPlatformVersion();
        if (this$platformVersion == null ? other$platformVersion != null : !this$platformVersion.equals(other$platformVersion)) {
            return false;
        }
        SdkTypeEnum this$sdkType = this.getSdkType();
        SdkTypeEnum other$sdkType = other.getSdkType();
        if (this$sdkType == null ? other$sdkType != null : !((Object)((Object)this$sdkType)).equals((Object)other$sdkType)) {
            return false;
        }
        String this$sdkVersion = this.getSdkVersion();
        String other$sdkVersion = other.getSdkVersion();
        if (this$sdkVersion == null ? other$sdkVersion != null : !this$sdkVersion.equals(other$sdkVersion)) {
            return false;
        }
        String this$hostname = this.getHostname();
        String other$hostname = other.getHostname();
        return !(this$hostname == null ? other$hostname != null : !this$hostname.equals(other$hostname));
    }

    protected boolean canEqual(Object other) {
        return other instanceof PlatformData;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $platform = this.getPlatform();
        result = result * 59 + ($platform == null ? 43 : $platform.hashCode());
        String $platformVersion = this.getPlatformVersion();
        result = result * 59 + ($platformVersion == null ? 43 : $platformVersion.hashCode());
        SdkTypeEnum $sdkType = this.getSdkType();
        result = result * 59 + ($sdkType == null ? 43 : ((Object)((Object)$sdkType)).hashCode());
        String $sdkVersion = this.getSdkVersion();
        result = result * 59 + ($sdkVersion == null ? 43 : $sdkVersion.hashCode());
        String $hostname = this.getHostname();
        result = result * 59 + ($hostname == null ? 43 : $hostname.hashCode());
        return result;
    }

    public static class PlatformDataBuilder {
        private boolean platform$set;
        private String platform$value;
        private boolean platformVersion$set;
        private String platformVersion$value;
        private boolean sdkType$set;
        private SdkTypeEnum sdkType$value;
        private boolean sdkVersion$set;
        private String sdkVersion$value;
        private String hostname;

        PlatformDataBuilder() {
        }

        public PlatformDataBuilder platform(String platform) {
            this.platform$value = platform;
            this.platform$set = true;
            return this;
        }

        public PlatformDataBuilder platformVersion(String platformVersion) {
            this.platformVersion$value = platformVersion;
            this.platformVersion$set = true;
            return this;
        }

        public PlatformDataBuilder sdkType(SdkTypeEnum sdkType) {
            this.sdkType$value = sdkType;
            this.sdkType$set = true;
            return this;
        }

        public PlatformDataBuilder sdkVersion(String sdkVersion) {
            this.sdkVersion$value = sdkVersion;
            this.sdkVersion$set = true;
            return this;
        }

        public PlatformDataBuilder hostname(String hostname) {
            this.hostname = hostname;
            return this;
        }

        public PlatformData build() {
            String platform$value = this.platform$value;
            if (!this.platform$set) {
                platform$value = PlatformData.$default$platform();
            }
            String platformVersion$value = this.platformVersion$value;
            if (!this.platformVersion$set) {
                platformVersion$value = PlatformData.$default$platformVersion();
            }
            SdkTypeEnum sdkType$value = this.sdkType$value;
            if (!this.sdkType$set) {
                sdkType$value = PlatformData.$default$sdkType();
            }
            String sdkVersion$value = this.sdkVersion$value;
            if (!this.sdkVersion$set) {
                sdkVersion$value = PlatformData.$default$sdkVersion();
            }
            return new PlatformData(platform$value, platformVersion$value, sdkType$value, sdkVersion$value, this.hostname);
        }

        public String toString() {
            return "PlatformData.PlatformDataBuilder(platform$value=" + this.platform$value + ", platformVersion$value=" + this.platformVersion$value + ", sdkType$value=" + this.sdkType$value + ", sdkVersion$value=" + this.sdkVersion$value + ", hostname=" + this.hostname + ")";
        }
    }

    public static enum SdkTypeEnum {
        API("api"),
        SERVER("server");

        private final String value;

        private SdkTypeEnum(String value) {
            this.value = value;
        }

        public static SdkTypeEnum fromValue(String text) {
            for (SdkTypeEnum b : SdkTypeEnum.values()) {
                if (!String.valueOf(b.value).equals(text)) continue;
                return b;
            }
            return null;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }
    }
}

