/*
 * Decompiled with CFR 0.152.
 */
package com.devcycle.sdk.server.local.api;

import com.devcycle.sdk.server.common.api.IDevCycleClient;
import com.devcycle.sdk.server.common.exception.BeforeHookError;
import com.devcycle.sdk.server.common.logging.DevCycleLogger;
import com.devcycle.sdk.server.common.model.BaseVariable;
import com.devcycle.sdk.server.common.model.DevCycleEvent;
import com.devcycle.sdk.server.common.model.DevCycleUser;
import com.devcycle.sdk.server.common.model.EvalHook;
import com.devcycle.sdk.server.common.model.EvalHooksRunner;
import com.devcycle.sdk.server.common.model.Feature;
import com.devcycle.sdk.server.common.model.HookContext;
import com.devcycle.sdk.server.common.model.PlatformData;
import com.devcycle.sdk.server.common.model.Variable;
import com.devcycle.sdk.server.local.bucketing.LocalBucketing;
import com.devcycle.sdk.server.local.managers.EnvironmentConfigManager;
import com.devcycle.sdk.server.local.managers.EventQueueManager;
import com.devcycle.sdk.server.local.model.BucketedUserConfig;
import com.devcycle.sdk.server.local.model.ConfigMetadata;
import com.devcycle.sdk.server.local.model.DevCycleLocalOptions;
import com.devcycle.sdk.server.local.protobuf.SDKVariable_PB;
import com.devcycle.sdk.server.local.protobuf.VariableForUserParams_PB;
import com.devcycle.sdk.server.local.protobuf.VariableType_PB;
import com.devcycle.sdk.server.local.utils.ProtobufUtils;
import com.devcycle.sdk.server.openfeature.DevCycleProvider;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import dev.openfeature.sdk.FeatureProvider;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;

public final class DevCycleLocalClient
implements IDevCycleClient {
    private final String sdkKey;
    private final LocalBucketing localBucketing = new LocalBucketing();
    private final EnvironmentConfigManager configManager;
    private EventQueueManager eventQueueManager;
    private final String clientUUID = UUID.randomUUID().toString();
    private EvalHooksRunner evalHooksRunner;
    private static DevCycleProvider openFeatureProvider = null;

    public DevCycleLocalClient(String sdkKey) {
        this(sdkKey, DevCycleLocalOptions.builder().build());
    }

    public DevCycleLocalClient(String sdkKey, DevCycleLocalOptions dvcOptions) {
        if (sdkKey == null || sdkKey.equals("")) {
            throw new IllegalArgumentException("Missing SDK key! Call initialize with a valid SDK key");
        }
        if (!this.isValidServerKey(sdkKey)) {
            throw new IllegalArgumentException("Invalid SDK key provided. Please call initialize with a valid server SDK key");
        }
        if (dvcOptions.getCustomLogger() != null) {
            DevCycleLogger.setCustomLogger(dvcOptions.getCustomLogger());
        }
        if (!this.isValidRuntime()) {
            DevCycleLogger.warning("The DevCycleLocalClient requires a 64-bit, x86 or aarch64 runtime environment. This architecture may not be supported: " + System.getProperty("os.arch") + " | " + System.getProperty("sun.arch.data.model"));
        }
        this.localBucketing.setPlatformData(PlatformData.builder().build().toString());
        this.configManager = new EnvironmentConfigManager(sdkKey, this.localBucketing, dvcOptions);
        this.sdkKey = sdkKey;
        try {
            this.eventQueueManager = new EventQueueManager(sdkKey, this.localBucketing, this.clientUUID, dvcOptions);
        }
        catch (Exception e) {
            DevCycleLogger.error("Error creating event queue due to error: " + e.getMessage());
        }
        this.evalHooksRunner = new EvalHooksRunner(dvcOptions.getHooks());
    }

    @Override
    public boolean isInitialized() {
        if (this.configManager != null) {
            return this.configManager.isConfigInitialized();
        }
        return false;
    }

    public Map<String, Feature> allFeatures(DevCycleUser user) {
        if (!this.isInitialized()) {
            return Collections.emptyMap();
        }
        this.validateUser(user);
        BucketedUserConfig bucketedUserConfig = null;
        try {
            bucketedUserConfig = this.localBucketing.generateBucketedConfig(this.sdkKey, user);
        }
        catch (JsonProcessingException e) {
            DevCycleLogger.error("Unable to parse JSON for allFeatures due to error: " + e.getMessage());
            return Collections.emptyMap();
        }
        return bucketedUserConfig.features;
    }

    @Override
    public <T> T variableValue(DevCycleUser user, String key, T defaultValue) {
        return this.variable(user, key, defaultValue).getValue();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> Variable<T> variable(DevCycleUser user, String key, T defaultValue) {
        this.validateUser(user);
        if (key == null || key.equals("")) {
            throw new IllegalArgumentException("Missing parameter: key");
        }
        if (defaultValue == null) {
            throw new IllegalArgumentException("Missing parameter: defaultValue");
        }
        Variable.TypeEnum variableType = Variable.TypeEnum.fromClass(defaultValue.getClass());
        Variable defaultVariable = Variable.builder().key(key).type(variableType).value(defaultValue).defaultValue(defaultValue).isDefaulted(true).build();
        if (!this.isInitialized()) {
            DevCycleLogger.info("Variable called before DevCycleLocalClient has initialized, returning default value");
            try {
                this.eventQueueManager.queueAggregateEvent(DevCycleEvent.builder().type("aggVariableDefaulted").target(key).build(), null);
            }
            catch (Exception e) {
                DevCycleLogger.error("Unable to parse aggVariableDefaulted event for Variable " + key + " due to error: " + e, e);
            }
            return defaultVariable;
        }
        VariableType_PB pbVariableType = ProtobufUtils.convertTypeEnumToVariableType(variableType);
        VariableForUserParams_PB params = VariableForUserParams_PB.newBuilder().setSdkKey(this.sdkKey).setUser(ProtobufUtils.createDVCUserPB(user)).setVariableKey(key).setVariableType(pbVariableType).setShouldTrackEvent(true).build();
        HookContext<T> hookContext = new HookContext<T>(user, key, defaultValue, this.getMetadata());
        Variable variable = null;
        ArrayList hooks = new ArrayList(this.evalHooksRunner.getHooks());
        ArrayList reversedHooks = new ArrayList(this.evalHooksRunner.getHooks());
        Collections.reverse(reversedHooks);
        try {
            byte[] paramsBuffer = params.toByteArray();
            byte[] variableData = this.localBucketing.getVariableForUserProtobuf(paramsBuffer);
            Throwable beforeError = null;
            try {
                this.evalHooksRunner.executeBefore(hooks, hookContext);
            }
            catch (Throwable e) {
                beforeError = e;
            }
            if (variableData == null || variableData.length == 0) {
                variable = defaultVariable;
            } else {
                SDKVariable_PB sdkVariable = SDKVariable_PB.parseFrom(variableData);
                if (sdkVariable.getType() != pbVariableType) {
                    DevCycleLogger.warning("Variable type mismatch, returning default value");
                    variable = defaultVariable;
                } else {
                    variable = ProtobufUtils.createVariable(sdkVariable, defaultValue);
                }
            }
            if (beforeError != null) {
                throw beforeError;
            }
            this.evalHooksRunner.executeAfter(reversedHooks, hookContext, variable);
        }
        catch (Throwable e) {
            if (!(e instanceof BeforeHookError)) {
                DevCycleLogger.error("Unable to evaluate Variable " + key + " due to error: " + e, e);
            }
            Throwable errorToPass = e instanceof BeforeHookError && e.getCause() != null ? e.getCause() : e;
            this.evalHooksRunner.executeError(reversedHooks, hookContext, errorToPass);
        }
        finally {
            if (variable == null) {
                variable = defaultVariable;
            }
            this.evalHooksRunner.executeFinally(reversedHooks, hookContext, Optional.of(variable));
        }
        return variable;
    }

    public ConfigMetadata getMetadata() {
        return this.configManager.getConfigMetadata();
    }

    public Map<String, BaseVariable> allVariables(DevCycleUser user) {
        this.validateUser(user);
        if (!this.isInitialized()) {
            return Collections.emptyMap();
        }
        BucketedUserConfig bucketedUserConfig = null;
        try {
            bucketedUserConfig = this.localBucketing.generateBucketedConfig(this.sdkKey, user);
        }
        catch (JsonProcessingException e) {
            DevCycleLogger.error("Unable to parse JSON for allVariables due to error: " + e.getMessage());
            return Collections.emptyMap();
        }
        return bucketedUserConfig.variables;
    }

    @Override
    public void track(DevCycleUser user, DevCycleEvent event) {
        this.validateUser(user);
        if (event == null || event.getType().equals("")) {
            throw new IllegalArgumentException("Invalid DevCycleEvent");
        }
        try {
            this.eventQueueManager.queueEvent(user, event);
        }
        catch (Exception e) {
            DevCycleLogger.error("Failed to queue event due to error: " + e.getMessage());
        }
    }

    public void setClientCustomData(Map<String, Object> customData) {
        if (!this.isInitialized()) {
            DevCycleLogger.error("SetClientCustomData called before DevCycleClient has initialized");
            return;
        }
        if (customData != null && !customData.isEmpty()) {
            try {
                ObjectMapper mapper = new ObjectMapper();
                String customDataJSON = mapper.writeValueAsString(customData);
                this.localBucketing.setClientCustomData(this.sdkKey, customDataJSON);
            }
            catch (Exception e) {
                DevCycleLogger.error("Failed to set custom data due to error: " + e.getMessage(), e);
            }
        }
    }

    @Override
    public void close() {
        if (this.configManager != null) {
            this.configManager.cleanup();
        }
        if (this.eventQueueManager != null) {
            this.eventQueueManager.cleanup();
        }
    }

    public void addHook(EvalHook hook) {
        this.evalHooksRunner.addHook(hook);
    }

    public void clearHooks() {
        this.evalHooksRunner.clearHooks();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public FeatureProvider getOpenFeatureProvider() {
        if (openFeatureProvider != null) return openFeatureProvider;
        Class<DevCycleLocalClient> clazz = DevCycleLocalClient.class;
        synchronized (DevCycleLocalClient.class) {
            if (openFeatureProvider == null) {
                openFeatureProvider = new DevCycleProvider(this);
            }
            PlatformData platformData = PlatformData.builder().sdkPlatform("java-of").build();
            this.localBucketing.setPlatformData(platformData.toString());
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return openFeatureProvider;
        }
    }

    @Override
    public String getSDKPlatform() {
        return "Local";
    }

    private void validateUser(DevCycleUser user) {
        if (user == null) {
            throw new IllegalArgumentException("DevCycleUser cannot be null");
        }
        if (user.getUserId().equals("")) {
            throw new IllegalArgumentException("userId cannot be empty");
        }
    }

    private boolean isValidServerKey(String serverKey) {
        return serverKey.startsWith("server") || serverKey.startsWith("dvc_server");
    }

    private boolean isValidRuntime() {
        String os = System.getProperty("os.name").toLowerCase();
        String arch = System.getProperty("os.arch").toLowerCase();
        String model = System.getProperty("sun.arch.data.model").toLowerCase();
        if (arch.contains("x86") && model.contains("64")) {
            return true;
        }
        if (os.contains("mac os") || os.contains("darwin")) {
            return arch.equals("aarch64");
        }
        return false;
    }
}

