/*
 * Decompiled with CFR 0.152.
 */
package com.devcycle.sdk.server.common.model;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.v3.oas.annotations.media.Schema;

@JsonIgnoreProperties(ignoreUnknown=true)
@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class EvalReason {
    @Schema(description="Evaluation reason", required=true)
    @JsonProperty(value="reason")
    private String reason;
    @Schema(description="Details")
    @JsonProperty(value="details")
    private String details;
    @Schema(description="Target ID")
    @JsonProperty(value="target_id")
    private String targetId;

    private EvalReason(String reason, String details) {
        this.reason = reason;
        this.details = details;
    }

    public static EvalReason defaultReason(DefaultReasonDetailsEnum details) {
        return new EvalReason("DEFAULT", details.getValue());
    }

    public String getReason() {
        return this.reason == null ? "UNKNOWN" : this.reason;
    }

    public String getDetails() {
        return this.details;
    }

    public String getTargetId() {
        return this.targetId;
    }

    @JsonProperty(value="reason")
    public void setReason(String reason) {
        this.reason = reason;
    }

    @JsonProperty(value="details")
    public void setDetails(String details) {
        this.details = details;
    }

    @JsonProperty(value="target_id")
    public void setTargetId(String targetId) {
        this.targetId = targetId;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof EvalReason)) {
            return false;
        }
        EvalReason other = (EvalReason)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$reason = this.getReason();
        String other$reason = other.getReason();
        if (this$reason == null ? other$reason != null : !this$reason.equals(other$reason)) {
            return false;
        }
        String this$details = this.getDetails();
        String other$details = other.getDetails();
        if (this$details == null ? other$details != null : !this$details.equals(other$details)) {
            return false;
        }
        String this$targetId = this.getTargetId();
        String other$targetId = other.getTargetId();
        return !(this$targetId == null ? other$targetId != null : !this$targetId.equals(other$targetId));
    }

    protected boolean canEqual(Object other) {
        return other instanceof EvalReason;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $reason = this.getReason();
        result = result * 59 + ($reason == null ? 43 : $reason.hashCode());
        String $details = this.getDetails();
        result = result * 59 + ($details == null ? 43 : $details.hashCode());
        String $targetId = this.getTargetId();
        result = result * 59 + ($targetId == null ? 43 : $targetId.hashCode());
        return result;
    }

    public String toString() {
        return "EvalReason(reason=" + this.getReason() + ", details=" + this.getDetails() + ", targetId=" + this.getTargetId() + ")";
    }

    public EvalReason(String reason, String details, String targetId) {
        this.reason = reason;
        this.details = details;
        this.targetId = targetId;
    }

    public EvalReason() {
    }

    public static enum DefaultReasonDetailsEnum {
        MISSING_CONFIG("Missing Config"),
        USER_NOT_TARGETED("User Not Targeted"),
        VARIABLE_TYPE_MISMATCH("Variable Type Mismatch"),
        ERROR("Error");

        private final String value;

        private DefaultReasonDetailsEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }
    }
}

