/*
 * Decompiled with CFR 0.152.
 */
package com.devcycle.sdk.server.local.api;

import com.devcycle.sdk.server.common.api.APIUtils;
import com.devcycle.sdk.server.common.api.IDevCycleApi;
import com.devcycle.sdk.server.common.api.ObjectMapperUtils;
import com.devcycle.sdk.server.local.model.DevCycleLocalOptions;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import okhttp3.OkHttpClient;
import retrofit2.Converter;
import retrofit2.Retrofit;
import retrofit2.converter.jackson.JacksonConverterFactory;

public final class DevCycleLocalApiClient {
    private static final ObjectMapper OBJECT_MAPPER = ObjectMapperUtils.createDefaultObjectMapper();
    private static final String CONFIG_URL = "https://config-cdn.devcycle.com/";
    private static final int DEFAULT_TIMEOUT_MS = 10000;
    private static final int MIN_INTERVALS_MS = 1000;
    private final OkHttpClient.Builder okBuilder = new OkHttpClient.Builder();
    private final Retrofit.Builder adapterBuilder;
    private String configUrl;
    private final int requestTimeoutMs;

    private DevCycleLocalApiClient(DevCycleLocalOptions options) {
        APIUtils.applyRestOptions(options.getRestOptions(), this.okBuilder);
        String cdnUrlFromOptions = options.getConfigCdnBaseUrl();
        int configRequestTimeoutMs = options.getConfigRequestTimeoutMs();
        this.configUrl = this.checkIfStringNullOrEmpty(cdnUrlFromOptions) != false ? CONFIG_URL : cdnUrlFromOptions;
        this.requestTimeoutMs = configRequestTimeoutMs >= 1000 ? configRequestTimeoutMs : 10000;
        this.okBuilder.callTimeout((long)this.requestTimeoutMs, TimeUnit.MILLISECONDS);
        this.configUrl = this.configUrl.endsWith("/") ? this.configUrl : this.configUrl + "/";
        this.adapterBuilder = new Retrofit.Builder().baseUrl(this.configUrl).addConverterFactory((Converter.Factory)JacksonConverterFactory.create((ObjectMapper)OBJECT_MAPPER));
    }

    public DevCycleLocalApiClient(String sdkKey, DevCycleLocalOptions options) {
        this(options);
    }

    public IDevCycleApi initialize() {
        return (IDevCycleApi)this.adapterBuilder.client(this.okBuilder.build()).build().create(IDevCycleApi.class);
    }

    private Boolean checkIfStringNullOrEmpty(String stringToCheck) {
        return Objects.isNull(stringToCheck) || Objects.equals(stringToCheck, "");
    }
}

