/*
 * Decompiled with CFR 0.152.
 */
package com.devcycle.sdk.server.common.interceptor;

import com.devcycle.sdk.server.common.api.IRestOptions;
import java.io.IOException;
import java.util.Map;
import okhttp3.Interceptor;
import okhttp3.Request;
import okhttp3.Response;

public final class CustomHeaderInterceptor
implements Interceptor {
    private final IRestOptions restOptions;

    public CustomHeaderInterceptor(IRestOptions restOptions) {
        this.restOptions = restOptions;
    }

    public Response intercept(Interceptor.Chain chain) throws IOException {
        Request request = chain.request();
        if (this.restOptions != null) {
            Request.Builder builder = request.newBuilder();
            for (Map.Entry<String, String> entry : this.restOptions.getHeaders().entrySet()) {
                if (entry.getValue() == null) continue;
                builder.addHeader(entry.getKey(), entry.getValue());
            }
            request = builder.build();
        }
        return chain.proceed(request);
    }
}

