/*
 * Decompiled with CFR 0.152.
 */
package com.devcycle.sdk.server.common.model;

import com.devcycle.sdk.server.common.model.SSE;
import com.devcycle.sdk.server.local.model.Environment;
import com.devcycle.sdk.server.local.model.Project;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.Arrays;

@JsonIgnoreProperties(ignoreUnknown=true)
public class ProjectConfig {
    @Schema(description="Project Settings")
    @JsonProperty(value="project")
    private Project project;
    @Schema(description="Environment Key & ID")
    @JsonProperty(value="environment")
    private Environment environment;
    @Schema(description="List of Features in this Project")
    private Object[] features;
    @Schema(description="List of Variables in this Project")
    private Object[] variables;
    @Schema(description="Audiences in this Project indexed by ID")
    private Object audiences;
    @Schema(description="Variable Hashes for all Variables in this Project")
    private Object variableHashes;
    @Schema(description="SSE Configuration")
    private SSE sse;

    public Project getProject() {
        return this.project;
    }

    public Environment getEnvironment() {
        return this.environment;
    }

    public static ProjectConfigBuilder builder() {
        return new ProjectConfigBuilder();
    }

    public Object[] getFeatures() {
        return this.features;
    }

    public Object[] getVariables() {
        return this.variables;
    }

    public Object getAudiences() {
        return this.audiences;
    }

    public Object getVariableHashes() {
        return this.variableHashes;
    }

    public SSE getSse() {
        return this.sse;
    }

    @JsonProperty(value="project")
    public void setProject(Project project) {
        this.project = project;
    }

    @JsonProperty(value="environment")
    public void setEnvironment(Environment environment) {
        this.environment = environment;
    }

    public void setFeatures(Object[] features) {
        this.features = features;
    }

    public void setVariables(Object[] variables) {
        this.variables = variables;
    }

    public void setAudiences(Object audiences) {
        this.audiences = audiences;
    }

    public void setVariableHashes(Object variableHashes) {
        this.variableHashes = variableHashes;
    }

    public void setSse(SSE sse) {
        this.sse = sse;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ProjectConfig)) {
            return false;
        }
        ProjectConfig other = (ProjectConfig)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Project this$project = this.getProject();
        Project other$project = other.getProject();
        if (this$project == null ? other$project != null : !this$project.equals(other$project)) {
            return false;
        }
        Environment this$environment = this.getEnvironment();
        Environment other$environment = other.getEnvironment();
        if (this$environment == null ? other$environment != null : !this$environment.equals(other$environment)) {
            return false;
        }
        if (!Arrays.deepEquals(this.getFeatures(), other.getFeatures())) {
            return false;
        }
        if (!Arrays.deepEquals(this.getVariables(), other.getVariables())) {
            return false;
        }
        Object this$audiences = this.getAudiences();
        Object other$audiences = other.getAudiences();
        if (this$audiences == null ? other$audiences != null : !this$audiences.equals(other$audiences)) {
            return false;
        }
        Object this$variableHashes = this.getVariableHashes();
        Object other$variableHashes = other.getVariableHashes();
        if (this$variableHashes == null ? other$variableHashes != null : !this$variableHashes.equals(other$variableHashes)) {
            return false;
        }
        SSE this$sse = this.getSse();
        SSE other$sse = other.getSse();
        return !(this$sse == null ? other$sse != null : !((Object)this$sse).equals(other$sse));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ProjectConfig;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Project $project = this.getProject();
        result = result * 59 + ($project == null ? 43 : $project.hashCode());
        Environment $environment = this.getEnvironment();
        result = result * 59 + ($environment == null ? 43 : $environment.hashCode());
        result = result * 59 + Arrays.deepHashCode(this.getFeatures());
        result = result * 59 + Arrays.deepHashCode(this.getVariables());
        Object $audiences = this.getAudiences();
        result = result * 59 + ($audiences == null ? 43 : $audiences.hashCode());
        Object $variableHashes = this.getVariableHashes();
        result = result * 59 + ($variableHashes == null ? 43 : $variableHashes.hashCode());
        SSE $sse = this.getSse();
        result = result * 59 + ($sse == null ? 43 : ((Object)$sse).hashCode());
        return result;
    }

    public String toString() {
        return "ProjectConfig(project=" + this.getProject() + ", environment=" + this.getEnvironment() + ", features=" + Arrays.deepToString(this.getFeatures()) + ", variables=" + Arrays.deepToString(this.getVariables()) + ", audiences=" + this.getAudiences() + ", variableHashes=" + this.getVariableHashes() + ", sse=" + this.getSse() + ")";
    }

    public ProjectConfig(Project project, Environment environment, Object[] features, Object[] variables, Object audiences, Object variableHashes, SSE sse) {
        this.project = project;
        this.environment = environment;
        this.features = features;
        this.variables = variables;
        this.audiences = audiences;
        this.variableHashes = variableHashes;
        this.sse = sse;
    }

    public ProjectConfig() {
    }

    public static class ProjectConfigBuilder {
        private Project project;
        private Environment environment;
        private Object[] features;
        private Object[] variables;
        private Object audiences;
        private Object variableHashes;
        private SSE sse;

        ProjectConfigBuilder() {
        }

        @JsonProperty(value="project")
        public ProjectConfigBuilder project(Project project) {
            this.project = project;
            return this;
        }

        @JsonProperty(value="environment")
        public ProjectConfigBuilder environment(Environment environment) {
            this.environment = environment;
            return this;
        }

        public ProjectConfigBuilder features(Object[] features) {
            this.features = features;
            return this;
        }

        public ProjectConfigBuilder variables(Object[] variables) {
            this.variables = variables;
            return this;
        }

        public ProjectConfigBuilder audiences(Object audiences) {
            this.audiences = audiences;
            return this;
        }

        public ProjectConfigBuilder variableHashes(Object variableHashes) {
            this.variableHashes = variableHashes;
            return this;
        }

        public ProjectConfigBuilder sse(SSE sse) {
            this.sse = sse;
            return this;
        }

        public ProjectConfig build() {
            return new ProjectConfig(this.project, this.environment, this.features, this.variables, this.audiences, this.variableHashes, this.sse);
        }

        public String toString() {
            return "ProjectConfig.ProjectConfigBuilder(project=" + this.project + ", environment=" + this.environment + ", features=" + Arrays.deepToString(this.features) + ", variables=" + Arrays.deepToString(this.variables) + ", audiences=" + this.audiences + ", variableHashes=" + this.variableHashes + ", sse=" + this.sse + ")";
        }
    }
}

