/*
 * Decompiled with CFR 0.152.
 */
package com.devcycle.sdk.server.local.utils;

import com.devcycle.sdk.server.common.model.DevCycleUser;
import com.devcycle.sdk.server.common.model.EvalReason;
import com.devcycle.sdk.server.common.model.Variable;
import com.devcycle.sdk.server.local.protobuf.CustomDataType;
import com.devcycle.sdk.server.local.protobuf.CustomDataValue;
import com.devcycle.sdk.server.local.protobuf.DVCUser_PB;
import com.devcycle.sdk.server.local.protobuf.EvalReason_PB;
import com.devcycle.sdk.server.local.protobuf.NullableCustomData;
import com.devcycle.sdk.server.local.protobuf.NullableDouble;
import com.devcycle.sdk.server.local.protobuf.NullableString;
import com.devcycle.sdk.server.local.protobuf.SDKVariable_PB;
import com.devcycle.sdk.server.local.protobuf.VariableType_PB;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;

public class ProtobufUtils {
    public static DVCUser_PB createDVCUserPB(DevCycleUser user) {
        double appBuild = Double.NaN;
        try {
            appBuild = Double.parseDouble(user.getAppBuild());
        }
        catch (Exception exception) {
            // empty catch block
        }
        return DVCUser_PB.newBuilder().setUserId(user.getUserId()).setEmail(ProtobufUtils.createNullableString(user.getEmail())).setName(ProtobufUtils.createNullableString(user.getName())).setLanguage(ProtobufUtils.createNullableString(user.getLanguage())).setCountry(ProtobufUtils.createNullableString(user.getCountry())).setAppBuild(ProtobufUtils.createNullableDouble(appBuild)).setAppVersion(ProtobufUtils.createNullableString(user.getAppVersion())).setCustomData(ProtobufUtils.createNullableCustomData(user.getCustomData())).setPrivateCustomData(ProtobufUtils.createNullableCustomData(user.getPrivateCustomData())).build();
    }

    public static <T> Variable<T> createVariable(SDKVariable_PB sdkVariable, T defaultValue) throws JsonProcessingException {
        Variable<Object> variable;
        switch (sdkVariable.getType()) {
            case Boolean: {
                variable = Variable.builder().key(sdkVariable.getKey()).type(Variable.TypeEnum.BOOLEAN).value(sdkVariable.getBoolValue()).defaultValue((Boolean)defaultValue).isDefaulted(false).eval(ProtobufUtils.convertToEvalReason(sdkVariable.getEval())).build();
                break;
            }
            case String: {
                variable = Variable.builder().key(sdkVariable.getKey()).type(Variable.TypeEnum.STRING).value(sdkVariable.getStringValue()).defaultValue((String)defaultValue).isDefaulted(false).eval(ProtobufUtils.convertToEvalReason(sdkVariable.getEval())).build();
                break;
            }
            case Number: {
                variable = Variable.builder().key(sdkVariable.getKey()).type(Variable.TypeEnum.NUMBER).value(sdkVariable.getDoubleValue()).defaultValue((Double)defaultValue).isDefaulted(false).eval(ProtobufUtils.convertToEvalReason(sdkVariable.getEval())).build();
                break;
            }
            case JSON: {
                ObjectMapper mapper = new ObjectMapper();
                LinkedHashMap jsonObject = (LinkedHashMap)mapper.readValue(sdkVariable.getStringValue(), (TypeReference)new TypeReference<LinkedHashMap<String, Object>>(){});
                variable = Variable.builder().key(sdkVariable.getKey()).type(Variable.TypeEnum.JSON).value(jsonObject).defaultValue((LinkedHashMap)defaultValue).isDefaulted(false).eval(ProtobufUtils.convertToEvalReason(sdkVariable.getEval())).build();
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown variable type: " + sdkVariable.getType());
            }
        }
        return variable;
    }

    public static NullableString createNullableString(String value) {
        return value == null ? NullableString.newBuilder().setIsNull(true).build() : NullableString.newBuilder().setIsNull(false).setValue(value).build();
    }

    public static NullableDouble createNullableDouble(double value) {
        return !Double.isNaN(value) ? NullableDouble.newBuilder().setIsNull(false).setValue(value).build() : NullableDouble.newBuilder().setIsNull(true).build();
    }

    public static NullableCustomData createNullableCustomData(Object temp) {
        if (temp == null) {
            return NullableCustomData.newBuilder().setIsNull(true).build();
        }
        Map customData = (Map)temp;
        HashMap<String, CustomDataValue> values = new HashMap<String, CustomDataValue>();
        for (Map.Entry entry : customData.entrySet()) {
            if (entry.getValue() == null) {
                values.put((String)entry.getKey(), CustomDataValue.newBuilder().setType(CustomDataType.Null).build());
                continue;
            }
            if (entry.getValue() instanceof String) {
                String strValue = (String)entry.getValue();
                values.put((String)entry.getKey(), CustomDataValue.newBuilder().setType(CustomDataType.Str).setStringValue(strValue).build());
                continue;
            }
            if (entry.getValue() instanceof Number) {
                double numValue = ((Number)entry.getValue()).doubleValue();
                values.put((String)entry.getKey(), CustomDataValue.newBuilder().setType(CustomDataType.Num).setDoubleValue(numValue).build());
                continue;
            }
            if (!(entry.getValue() instanceof Boolean)) continue;
            boolean boolValue = (Boolean)entry.getValue();
            values.put((String)entry.getKey(), CustomDataValue.newBuilder().setType(CustomDataType.Bool).setBoolValue(boolValue).build());
        }
        return NullableCustomData.newBuilder().putAllValue(values).setIsNull(false).build();
    }

    public static VariableType_PB convertTypeEnumToVariableType(Variable.TypeEnum type) {
        switch (type) {
            case BOOLEAN: {
                return VariableType_PB.Boolean;
            }
            case STRING: {
                return VariableType_PB.String;
            }
            case NUMBER: {
                return VariableType_PB.Number;
            }
            case JSON: {
                return VariableType_PB.JSON;
            }
        }
        throw new IllegalArgumentException("Unknown variable type: " + type);
    }

    public static EvalReason convertToEvalReason(EvalReason_PB eval) {
        return new EvalReason(eval.getReason(), eval.getDetails(), eval.getTargetId());
    }
}

