/*
 * Decompiled with CFR 0.152.
 */
package com.devonfw.cobigen.javaplugin.merger;

import com.devonfw.cobigen.api.exception.MergeException;
import com.devonfw.cobigen.api.extension.Merger;
import com.devonfw.cobigen.javaplugin.inputreader.JavaParserUtil;
import com.devonfw.cobigen.javaplugin.merger.libextension.ModifyableJavaClass;
import com.thoughtworks.qdox.model.JavaClass;
import com.thoughtworks.qdox.model.JavaConstructor;
import com.thoughtworks.qdox.model.JavaField;
import com.thoughtworks.qdox.model.JavaMethod;
import com.thoughtworks.qdox.parser.ParseException;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.StringReader;
import java.util.List;

public class JavaMerger
implements Merger {
    private String type;
    private boolean patchOverrides;

    public JavaMerger(String type, boolean patchOverrides) {
        this.type = type;
        this.patchOverrides = patchOverrides;
    }

    public String getType() {
        return this.type;
    }

    public String merge(File base, String patch, String targetCharset) throws MergeException {
        ModifyableJavaClass patchClass;
        ModifyableJavaClass baseClass;
        try {
            baseClass = (ModifyableJavaClass)JavaParserUtil.getFirstJavaClass(new InputStreamReader((InputStream)new FileInputStream(base), targetCharset));
        }
        catch (IOException e) {
            throw new MergeException(base, "Cannot read base file.", (Throwable)e);
        }
        catch (ParseException e) {
            throw new MergeException(base, "Cannot parse base file. Error in line: " + e.getLine() + " / column: " + e.getColumn() + ": " + e.getMessage(), (Throwable)e);
        }
        try {
            patchClass = (ModifyableJavaClass)JavaParserUtil.getFirstJavaClass(new StringReader(patch));
        }
        catch (ParseException e) {
            throw new MergeException(base, "Cannot parse generated patch. Error in line: " + e.getLine() + " / column: " + e.getColumn() + ": " + e.getMessage(), (Throwable)e);
        }
        if (baseClass == null) {
            throw new MergeException(base, "The base file does not declare a valid JavaClass.");
        }
        if (patchClass == null) {
            throw new MergeException(base, "The patch does not declare a valid JavaClass.");
        }
        ModifyableJavaClass mergedClass = this.merge(baseClass, patchClass);
        return this.consolidateLineEndings(mergedClass.getSource().getCodeBlock());
    }

    private String consolidateLineEndings(String codeBlock) {
        return codeBlock.replaceAll("\r\n|\r|\n", System.getProperty("line.separator"));
    }

    private ModifyableJavaClass merge(ModifyableJavaClass baseClass, ModifyableJavaClass patchClass) {
        this.mergeImports(baseClass, patchClass);
        this.mergeFields(baseClass, patchClass);
        this.mergeInnerClasses(baseClass, patchClass);
        this.mergeMethods(baseClass, patchClass);
        this.mergeSupertypes(baseClass, patchClass);
        return baseClass;
    }

    private void mergeSupertypes(ModifyableJavaClass baseClass, ModifyableJavaClass patchClass) {
        if (this.patchOverrides) {
            baseClass.setImplementz(patchClass.getImplementedInterfaces());
            if (!patchClass.getSuperClass().getCanonicalName().equals("java.lang.Enum")) {
                baseClass.setSuperClass(patchClass.getSuperClass());
            }
        } else {
            List<JavaClass> baseClassInterfaces = baseClass.getImplementedInterfaces();
            for (JavaClass pClass : patchClass.getImplementedInterfaces()) {
                if (baseClassInterfaces.contains(pClass) || baseClass.isA(pClass)) continue;
                baseClassInterfaces.add(pClass);
            }
            baseClass.setImplementz(baseClassInterfaces);
            if (baseClass.getSuperClass() == null || baseClass.getSuperClass().getCanonicalName().equals("java.lang.Object")) {
                baseClass.setSuperClass(patchClass.getSuperClass());
            }
        }
    }

    private void mergeImports(ModifyableJavaClass baseClass, ModifyableJavaClass patchClass) {
        for (String patchImport : patchClass.getSource().getImports()) {
            List baseImports = baseClass.getSource().getImports();
            String conflictingBaseImport = null;
            for (String baseImport : baseImports) {
                if (!this.getShortTypeName(patchImport).equals(this.getShortTypeName(baseImport))) continue;
                conflictingBaseImport = baseImport;
                break;
            }
            if (conflictingBaseImport != null) {
                if (!this.patchOverrides) continue;
                int i = baseImports.indexOf(conflictingBaseImport);
                baseImports.set(i, patchImport);
                continue;
            }
            baseClass.getSource().getImports().add(patchImport);
        }
    }

    private String getShortTypeName(String canonicalName) {
        if (canonicalName.lastIndexOf(".") != -1) {
            return canonicalName.substring(canonicalName.lastIndexOf(".") + 1);
        }
        return canonicalName;
    }

    private void mergeInnerClasses(ModifyableJavaClass baseClass, ModifyableJavaClass patchClass) {
        for (JavaClass rawInnerPatchClass : patchClass.getNestedClasses()) {
            ModifyableJavaClass innerPatchClass = (ModifyableJavaClass)rawInnerPatchClass;
            ModifyableJavaClass nestedBaseClass = (ModifyableJavaClass)baseClass.getNestedClassByName(innerPatchClass.getName());
            if (nestedBaseClass == null) {
                baseClass.addClass(innerPatchClass);
                continue;
            }
            this.merge(nestedBaseClass, innerPatchClass);
        }
    }

    private void mergeFields(ModifyableJavaClass baseClass, ModifyableJavaClass patchClass) {
        for (JavaField patchField : patchClass.getFields()) {
            JavaField baseField = baseClass.getFieldByName(patchField.getName());
            if (baseField == null) {
                baseClass.addField(patchField);
                continue;
            }
            if (!this.patchOverrides) continue;
            baseClass.replace(baseField, patchField);
        }
    }

    private void mergeMethods(ModifyableJavaClass baseClass, ModifyableJavaClass patchClass) {
        this.mergeImports(patchClass, baseClass);
        for (JavaConstructor patchConstructor : patchClass.getConstructors()) {
            JavaConstructor baseConstructor = baseClass.getConstructor(patchConstructor.getParameterTypes());
            if (baseConstructor == null) {
                baseClass.addConstructor(patchConstructor);
                continue;
            }
            if (!this.patchOverrides) continue;
            baseClass.replace(baseConstructor, patchConstructor);
        }
        for (JavaMethod patchMethod : patchClass.getMethods()) {
            JavaMethod baseMethod = baseClass.getMethodBySignature(patchMethod.getName(), patchMethod.getParameterTypes(true));
            if (baseMethod == null) {
                baseClass.addMethod(patchMethod);
                continue;
            }
            if (!this.patchOverrides) continue;
            baseClass.replace(baseMethod, patchMethod);
        }
    }
}

