/*
 * Decompiled with CFR 0.152.
 */
package com.devonfw.cobigen.javaplugin.matcher.resolver;

import com.devonfw.cobigen.api.exception.UnknownExpressionException;
import com.thoughtworks.qdox.model.JavaClass;
import java.lang.reflect.Modifier;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TriggerExpressionResolver {
    private Object pojo;
    private static final Logger LOG = LoggerFactory.getLogger(TriggerExpressionResolver.class);
    private static Pattern instanceOfPattern = Pattern.compile("\\s*instanceof\\s+([^\\s]+)");
    private static Pattern isAbstractPattern = Pattern.compile("\\s*isAbstract\\s*");

    public TriggerExpressionResolver(Class<?> reflectionClass) {
        this.pojo = reflectionClass;
    }

    public TriggerExpressionResolver(JavaClass parsedClass) {
        this.pojo = parsedClass;
    }

    public boolean evaluateExpression(String expression) {
        Matcher m = instanceOfPattern.matcher(expression);
        if (m.matches()) {
            if (this.pojo instanceof Class) {
                try {
                    return ((Class)this.pojo).getClassLoader().loadClass(m.group(1)).isAssignableFrom((Class)this.pojo);
                }
                catch (ClassNotFoundException e) {
                    LOG.info("Could not load class '{}' to resolve expression '{}'.", (Object)m.group(1), (Object)expression);
                }
            } else if (this.pojo instanceof JavaClass) {
                return ((JavaClass)this.pojo).isA(m.group(1));
            }
        } else {
            m = isAbstractPattern.matcher(expression);
            if (m.matches()) {
                if (this.pojo instanceof Class) {
                    return Modifier.isAbstract(((Class)this.pojo).getModifiers());
                }
                if (this.pojo instanceof JavaClass) {
                    return ((JavaClass)this.pojo).isAbstract();
                }
            } else {
                throw new UnknownExpressionException("Unknown trigger expression: '" + expression + "'");
            }
        }
        return false;
    }
}

