/*
 * Decompiled with CFR 0.152.
 */
package com.devonfw.cobigen.javaplugin.merger.libextension;

import com.devonfw.cobigen.javaplugin.merger.libextension.CustomModelWriterFactory;
import com.devonfw.cobigen.javaplugin.merger.libextension.ModifyableModelBuilder;
import com.thoughtworks.qdox.builder.Builder;
import com.thoughtworks.qdox.library.AbstractClassLibrary;
import com.thoughtworks.qdox.library.ClassLibrary;
import com.thoughtworks.qdox.library.SourceLibrary;
import com.thoughtworks.qdox.model.DocletTagFactory;
import com.thoughtworks.qdox.model.JavaSource;
import com.thoughtworks.qdox.model.impl.DefaultDocletTagFactory;
import com.thoughtworks.qdox.parser.JavaLexer;
import com.thoughtworks.qdox.parser.ParseException;
import com.thoughtworks.qdox.parser.impl.JFlexLexer;
import com.thoughtworks.qdox.parser.impl.Parser;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URL;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ModifyableSourceLibrary
extends SourceLibrary {
    private static final long serialVersionUID = 6865328738451045200L;
    private static final Logger LOG = LoggerFactory.getLogger(ModifyableSourceLibrary.class);

    public ModifyableSourceLibrary(AbstractClassLibrary parent) {
        super(parent);
    }

    public JavaSource addSource(Object source) throws ParseException, IOException {
        JavaSource resultSource = null;
        Builder modelBuilder = this.getModelBuilder();
        resultSource = this.parseSource(modelBuilder, source);
        this.registerJavaSource(resultSource);
        return resultSource;
    }

    private JavaSource parseSource(Builder modelBuilder, Object source) throws FileNotFoundException, MalformedURLException, UnsupportedEncodingException, IOException {
        JavaSource resultSource = null;
        if (source instanceof File) {
            resultSource = this.parse(new FileInputStream((File)source), ((File)source).toURI().toURL(), modelBuilder);
        } else if (source instanceof Reader) {
            resultSource = this.parse((Reader)source, null, modelBuilder);
        } else if (source instanceof InputStream) {
            resultSource = this.parse((InputStream)source, null, modelBuilder);
        } else if (source instanceof URL) {
            resultSource = this.parse(new InputStreamReader(((URL)source).openStream(), this.getEncoding()), (URL)source, modelBuilder);
        }
        return resultSource;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected JavaSource parse(InputStream stream, URL url, Builder modelBuilder) throws ParseException {
        try {
            JavaSource javaSource = this.parse((JavaLexer)new JFlexLexer(stream), url, modelBuilder);
            return javaSource;
        }
        finally {
            try {
                stream.close();
            }
            catch (IOException e) {
                LOG.error("{}", (Object)"ParseException", (Object)e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected JavaSource parse(Reader reader, URL url, Builder modelBuilder) throws ParseException {
        try {
            JavaSource javaSource = this.parse((JavaLexer)new JFlexLexer(reader), url, modelBuilder);
            return javaSource;
        }
        finally {
            try {
                reader.close();
            }
            catch (IOException e) {
                LOG.error("{}", (Object)"ParseException", (Object)e);
            }
        }
    }

    private JavaSource parse(JavaLexer lexer, URL url, Builder builder) throws ParseException {
        JavaSource result = null;
        builder.setUrl(url);
        Parser parser = new Parser(lexer, builder);
        parser.setDebugLexer(this.isDebugLexer());
        parser.setDebugParser(this.isDebugParser());
        try {
            if (parser.parse()) {
                result = builder.getSource();
            }
        }
        catch (ParseException pe) {
            if (url != null) {
                pe.setSourceInfo(url.toExternalForm());
                LOG.info("{}{}", new Object[]{"source info set", "url not null", url.toExternalForm()});
            }
            if (this.getErrorHandler() != null) {
                LOG.info("error handler not null");
                this.getErrorHandler().handle(pe);
            }
            LOG.error("{}", (Object)"ParseException", (Object)pe);
            throw pe;
        }
        return result;
    }

    protected Builder getModelBuilder() {
        ModifyableModelBuilder modelBuilder = new ModifyableModelBuilder((ClassLibrary)this, (DocletTagFactory)new DefaultDocletTagFactory());
        modelBuilder.setModelWriterFactory(new CustomModelWriterFactory());
        return modelBuilder;
    }
}

