/*
 * Decompiled with CFR 0.152.
 */
package com.devonfw.cobigen.javaplugin.inputreader;

import com.devonfw.cobigen.api.exception.InputReaderException;
import com.devonfw.cobigen.api.extension.InputReader;
import com.devonfw.cobigen.javaplugin.inputreader.JavaParserUtil;
import com.devonfw.cobigen.javaplugin.inputreader.ParsedJavaModelBuilder;
import com.devonfw.cobigen.javaplugin.inputreader.ReflectedJavaModelBuilder;
import com.devonfw.cobigen.javaplugin.inputreader.to.PackageFolder;
import com.devonfw.cobigen.javaplugin.merger.libextension.ModifyableClassLibraryBuilder;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.thoughtworks.qdox.model.JavaClass;
import com.thoughtworks.qdox.model.JavaSource;
import com.thoughtworks.qdox.parser.ParseException;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.commons.io.FilenameUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JavaInputReader
implements InputReader {
    private static final Logger LOG = LoggerFactory.getLogger(JavaInputReader.class);

    public boolean isValidInput(Object input) {
        Object[] inputArr;
        if (input instanceof Class || input instanceof JavaClass || input instanceof PackageFolder) {
            return true;
        }
        if (input instanceof Object[] && (inputArr = (Object[])input).length == 2) {
            if (inputArr[0] instanceof JavaClass && inputArr[1] instanceof Class) {
                if (((JavaClass)inputArr[0]).getFullyQualifiedName().equals(((Class)inputArr[1]).getCanonicalName())) {
                    return true;
                }
                LOG.debug("Invalid array input, not reflecting the same java class: JavaClass[{}], Class<>[{}]", (Object)((JavaClass)inputArr[0]).getFullyQualifiedName(), (Object)((Class)inputArr[1]).getCanonicalName());
            } else if (inputArr[0] instanceof Class && inputArr[1] instanceof JavaClass) {
                if (((Class)inputArr[0]).getCanonicalName().equals(((JavaClass)inputArr[1]).getFullyQualifiedName())) {
                    return true;
                }
                LOG.debug("Invalid array input, not reflecting the same java class: JavaClass[{}], Class<>[{}]", (Object)((JavaClass)inputArr[1]).getFullyQualifiedName(), (Object)((Class)inputArr[0]).getCanonicalName());
            }
        }
        return false;
    }

    public Map<String, Object> createModel(Object o) {
        if (o instanceof Class) {
            return new ReflectedJavaModelBuilder().createModel((Class)o);
        }
        if (o instanceof JavaClass) {
            return new ParsedJavaModelBuilder().createModel((JavaClass)o);
        }
        if (o instanceof Object[] && this.isValidInput(o)) {
            Map<String, Object> reflectionModel;
            Map<String, Object> parsedModel;
            Object[] inputArr = (Object[])o;
            if (inputArr[0] instanceof JavaClass) {
                parsedModel = new ParsedJavaModelBuilder().createModel((JavaClass)inputArr[0]);
                reflectionModel = new ReflectedJavaModelBuilder().createModel((Class)inputArr[1]);
            } else {
                parsedModel = new ParsedJavaModelBuilder().createModel((JavaClass)inputArr[1]);
                reflectionModel = new ReflectedJavaModelBuilder().createModel((Class)inputArr[0]);
            }
            return (Map)this.mergeModelsRecursively(parsedModel, reflectionModel);
        }
        return null;
    }

    public List<Object> getInputObjects(Object input, Charset inputCharset) {
        return this.getInputObjects(input, inputCharset, false);
    }

    public List<Object> getInputObjectsRecursively(Object input, Charset inputCharset) {
        return this.getInputObjects(input, inputCharset, true);
    }

    public List<Object> getInputObjects(Object input, Charset inputCharset, boolean recursively) {
        LOG.debug("Retrieve input object for input {} {}", input, (Object)(recursively ? "recursively" : ""));
        LinkedList<Object> javaClasses = new LinkedList<Object>();
        if (input instanceof PackageFolder) {
            File packageFolder = new File(((PackageFolder)input).getLocation());
            List<File> files = this.retrieveAllJavaSourceFiles(packageFolder, recursively);
            for (File f : files) {
                ModifyableClassLibraryBuilder classLibraryBuilder = new ModifyableClassLibraryBuilder();
                classLibraryBuilder.appendDefaultClassLoaders();
                ClassLoader containerClassloader = ((PackageFolder)input).getClassLoader();
                if (containerClassloader != null) {
                    classLibraryBuilder.appendClassLoader(containerClassloader);
                }
                try {
                    classLibraryBuilder.addSource(new InputStreamReader((InputStream)new FileInputStream(f), inputCharset));
                    JavaSource source = null;
                    Iterator iterator = classLibraryBuilder.getClassLibrary().getJavaSources().iterator();
                    if (iterator.hasNext()) {
                        JavaSource s;
                        source = s = (JavaSource)iterator.next();
                    }
                    if (source == null || source.getClasses().size() <= 0) continue;
                    JavaClass javaClass = (JavaClass)source.getClasses().get(0);
                    if (containerClassloader != null) {
                        try {
                            Class<?> loadedClass = containerClassloader.loadClass(javaClass.getCanonicalName());
                            javaClasses.add(new Object[]{javaClass, loadedClass});
                        }
                        catch (ClassNotFoundException e) {
                            LOG.info("Could not load Java type '{}' with the containers class loader. Just returning the parsed Java model.", (Object)javaClass.getCanonicalName());
                            javaClasses.add(javaClass);
                        }
                        continue;
                    }
                    javaClasses.add(javaClass);
                }
                catch (IOException e) {
                    LOG.error("The file {} could not be parsed as a java class", (Object)f.getAbsolutePath().toString(), (Object)e);
                }
            }
        }
        LOG.debug("{} java classes found!", (Object)javaClasses.size());
        return javaClasses;
    }

    private List<File> retrieveAllJavaSourceFiles(File packageFolder, boolean recursively) {
        LinkedList<File> files = new LinkedList<File>();
        LinkedList<File> directories = new LinkedList<File>();
        if (packageFolder.isDirectory()) {
            for (File f : packageFolder.listFiles()) {
                if (f.isFile() && f.getName().endsWith(".java")) {
                    files.add(f);
                    LOG.debug("Found java source {}", (Object)f.getAbsolutePath());
                    continue;
                }
                if (!f.isDirectory()) continue;
                directories.add(f);
            }
            if (recursively) {
                for (File dir : directories) {
                    files.addAll(this.retrieveAllJavaSourceFiles(dir, recursively));
                }
            }
        }
        return files;
    }

    public Map<String, Object> getTemplateMethods(Object input) {
        HashMap<String, Object> methodMap = new HashMap<String, Object>();
        ClassLoader classloader = null;
        if (this.isValidInput(input)) {
            if (input instanceof JavaClass) {
                classloader = this.getClass().getClassLoader();
            } else if (input instanceof PackageFolder) {
                classloader = ((PackageFolder)input).getClassLoader();
                if (classloader == null) {
                    classloader = this.getClass().getClassLoader();
                }
            } else if (input instanceof Object[]) {
                Object[] inputArr = (Object[])input;
                if (inputArr[0] instanceof JavaClass && inputArr[1] instanceof Class) {
                    classloader = ((Class)inputArr[1]).getClassLoader();
                } else if (inputArr[0] instanceof Class && inputArr[1] instanceof JavaClass) {
                    classloader = ((Class)inputArr[0]).getClassLoader();
                }
            } else if (input instanceof Class) {
                classloader = ((Class)input).getClassLoader();
            }
        }
        if (classloader == null) {
            throw new IllegalArgumentException("There is no ClassLoader for the given input. Perhaps you used a bootstrap class (e.g.java.lang.String) as input which is not supported");
        }
        return methodMap;
    }

    private Object mergeModelsRecursively(Object parsedModel, Object reflectionModel) {
        if (parsedModel == null && reflectionModel == null) {
            return null;
        }
        if (parsedModel == null) {
            return reflectionModel;
        }
        if (reflectionModel == null) {
            return parsedModel;
        }
        if (parsedModel.equals(reflectionModel)) {
            return parsedModel;
        }
        if (parsedModel.getClass().equals(reflectionModel.getClass())) {
            if (parsedModel instanceof Map && reflectionModel instanceof Map) {
                HashMap mergedModel = Maps.newHashMap();
                Map model1Map = (Map)parsedModel;
                Map model2Map = (Map)reflectionModel;
                HashSet union = Sets.newHashSet(model1Map.keySet());
                union.addAll(model2Map.keySet());
                for (String unionKey : union) {
                    if (model1Map.containsKey(unionKey) && model2Map.containsKey(unionKey)) {
                        mergedModel.put(unionKey, this.mergeModelsRecursively(model1Map.get(unionKey), model2Map.get(unionKey)));
                        continue;
                    }
                    if (model1Map.containsKey(unionKey)) {
                        mergedModel.put(unionKey, model1Map.get(unionKey));
                        continue;
                    }
                    mergedModel.put(unionKey, model2Map.get(unionKey));
                }
                return mergedModel;
            }
            if (parsedModel instanceof List && reflectionModel instanceof List) {
                if (!((List)parsedModel).isEmpty() && ((List)parsedModel).get(0) instanceof Map || !((List)reflectionModel).isEmpty() && ((List)reflectionModel).get(0) instanceof Map) {
                    LinkedList model1List = Lists.newLinkedList((Iterable)((List)parsedModel));
                    LinkedList model2List = Lists.newLinkedList((Iterable)((List)reflectionModel));
                    LinkedList mergedModel = Lists.newLinkedList();
                    Iterator model1ListIt = model1List.iterator();
                    block1: while (model1ListIt.hasNext()) {
                        Map model1Entry = (Map)model1ListIt.next();
                        Iterator model2ListIt = model2List.iterator();
                        while (model2ListIt.hasNext()) {
                            Map model2Entry = (Map)model2ListIt.next();
                            if (model1Entry.get("name") != null) {
                                if (!model1Entry.get("name").equals(model2Entry.get("name"))) continue;
                                mergedModel.add(this.mergeModelsRecursively(model1Entry, model2Entry));
                                model1ListIt.remove();
                                model2ListIt.remove();
                                continue block1;
                            }
                            if (model1Entry.size() == 1 && model2Entry.size() == 1) {
                                this.mergeModelsRecursively(model1Entry.get(model1Entry.keySet().iterator().next()), model2Entry.get(model2Entry.keySet().iterator().next()));
                                continue;
                            }
                            throw new IllegalStateException("Anything unintended happened. Please state an issue at GitHub or mail one of the developers");
                        }
                    }
                    mergedModel.addAll(model1List);
                    mergedModel.addAll(model2List);
                    return mergedModel;
                }
                if (!((List)parsedModel).isEmpty() && ((List)parsedModel).get(0) instanceof String) {
                    return parsedModel;
                }
                if (reflectionModel instanceof Object[]) {
                    return Lists.newLinkedList(Arrays.asList(reflectionModel));
                }
                return reflectionModel;
            }
            return parsedModel;
        }
        if (parsedModel instanceof String[]) {
            return Lists.newLinkedList(Arrays.asList(parsedModel));
        }
        return parsedModel;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Object read(Path path, Charset inputCharset, Object ... additionalArguments) throws InputReaderException {
        int n;
        Object[] packageFolder2;
        Class<?> clazz;
        if (LOG.isDebugEnabled()) {
            LOG.debug("Read input file {} by java plugin with charset {} and additional arguments {}...", new Object[]{path, inputCharset, Arrays.toString(additionalArguments)});
        }
        ClassLoader classLoader = null;
        if (!Files.isDirectory(path, new LinkOption[0])) {
            clazz = null;
            packageFolder2 = additionalArguments;
            n = packageFolder2.length;
        } else {
            String packageName = null;
            for (Object addArg : additionalArguments) {
                if (packageName == null && addArg instanceof String) {
                    packageName = (String)addArg;
                    continue;
                }
                if (classLoader != null || !(addArg instanceof ClassLoader)) continue;
                classLoader = (ClassLoader)addArg;
            }
            if (packageName == null) throw new IllegalArgumentException("Expected packageName:String and classLoader:ClassLoader as additional arguments but was " + this.toString(additionalArguments));
            if (classLoader == null) {
                throw new IllegalArgumentException("Expected packageName:String and classLoader:ClassLoader as additional arguments but was " + this.toString(additionalArguments));
            }
            PackageFolder packageFolder2 = new PackageFolder(path.toUri(), packageName, classLoader);
            LOG.debug("Read {}.", (Object)packageFolder2);
            return packageFolder2;
        }
        for (int i = 0; i < n; ++i) {
            Object addArg = packageFolder2[i];
            if (clazz == null && addArg instanceof Class) {
                clazz = (Class<?>)addArg;
                continue;
            }
            if (classLoader != null || !(addArg instanceof ClassLoader)) continue;
            classLoader = (ClassLoader)addArg;
        }
        try (BufferedReader pathReader = new BufferedReader(new FileReader(path.toFile()));){
            if (clazz == null) {
                Object[] objectArray;
                if (classLoader == null) {
                    JavaClass firstJavaClass = JavaParserUtil.getFirstJavaClass(pathReader);
                    LOG.debug("Read {}.", (Object)firstJavaClass);
                    JavaClass javaClass = firstJavaClass;
                    return javaClass;
                }
                Object[] firstJavaClass = JavaParserUtil.getFirstJavaClass(classLoader, pathReader);
                try {
                    clazz = classLoader.loadClass(firstJavaClass.getCanonicalName());
                }
                catch (ClassNotFoundException e) {
                    LOG.debug("Read {}.", (Object)firstJavaClass);
                    objectArray = firstJavaClass;
                    pathReader.close();
                    return objectArray;
                }
                Object[] result = new Object[]{firstJavaClass, clazz};
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Read {}.", (Object)Arrays.toString(result));
                }
                objectArray = result;
                return objectArray;
            }
            Object[] result = new Object[]{null, clazz};
            result[0] = classLoader == null ? JavaParserUtil.getFirstJavaClass(pathReader) : JavaParserUtil.getFirstJavaClass(classLoader, pathReader);
            if (LOG.isDebugEnabled()) {
                LOG.debug("Read {}.", (Object)Arrays.toString(result));
            }
            Object[] objectArray = result;
            return objectArray;
        }
        catch (IOException e) {
            throw new InputReaderException("Could not read file " + path.toString(), (Throwable)e);
        }
        catch (ParseException e) {
            throw new InputReaderException("Failed to parse java sources in " + path.toString() + ".", (Throwable)e);
        }
    }

    public boolean isMostLikelyReadable(Path path) {
        String validExtension = "java";
        String fileExtension = FilenameUtils.getExtension((String)path.toString()).toLowerCase();
        return validExtension.equals(fileExtension) || Files.isDirectory(path, new LinkOption[0]);
    }

    private String toString(Object any) {
        if (any == null) {
            return "null";
        }
        if (any instanceof Object[]) {
            String result = "[";
            for (Object o : (Object[])any) {
                result = "[".equals(result) ? this.toString(o) : result + ", " + this.toString(o);
            }
            return result + "]";
        }
        if (Object.class.equals(any.getClass())) {
            return any.toString();
        }
        return any.getClass().getName() + "@" + any.toString();
    }
}

