/*
 * Decompiled with CFR 0.152.
 */
package com.devonfw.cobigen.javaplugin.matcher;

import com.devonfw.cobigen.api.exception.InvalidConfigurationException;
import com.devonfw.cobigen.api.extension.MatcherInterpreter;
import com.devonfw.cobigen.api.to.MatcherTo;
import com.devonfw.cobigen.api.to.VariableAssignmentTo;
import com.devonfw.cobigen.javaplugin.inputreader.to.PackageFolder;
import com.devonfw.cobigen.javaplugin.matcher.resolver.TriggerExpressionResolver;
import com.google.common.collect.Maps;
import com.thoughtworks.qdox.model.JavaClass;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JavaMatcher
implements MatcherInterpreter {
    private static final Logger LOG = LoggerFactory.getLogger(JavaMatcher.class);

    public boolean matches(MatcherTo matcher) {
        try {
            MatcherType matcherType = Enum.valueOf(MatcherType.class, matcher.getType().toUpperCase());
            switch (matcherType) {
                case FQN: {
                    String fqn = this.getFqn(matcher);
                    LOG.debug("Matching input FQN {} against regex '{}'", (Object)fqn, (Object)matcher.getValue());
                    return fqn != null && fqn.matches(matcher.getValue());
                }
                case PACKAGE: {
                    return matcher.getTarget() instanceof PackageFolder && ((PackageFolder)matcher.getTarget()).getPackageName().matches(matcher.getValue());
                }
                case EXPRESSION: {
                    Object target = matcher.getTarget();
                    if (target instanceof Object[]) {
                        target = ((Object[])target)[0] instanceof Class ? ((Object[])target)[0] : ((Object[])target)[1];
                    }
                    if (target instanceof Class) {
                        TriggerExpressionResolver resolver = new TriggerExpressionResolver((Class)target);
                        return resolver.evaluateExpression(matcher.getValue());
                    }
                    if (!(target instanceof JavaClass)) break;
                    TriggerExpressionResolver resolver = new TriggerExpressionResolver((JavaClass)target);
                    return resolver.evaluateExpression(matcher.getValue());
                }
            }
        }
        catch (IllegalArgumentException e) {
            LOG.info("Matcher type '{}' not registered --> no match!", (Object)matcher.getType());
        }
        return false;
    }

    public Map<String, String> resolveVariables(MatcherTo matcher, List<VariableAssignmentTo> variableAssignments) throws InvalidConfigurationException {
        try {
            MatcherType matcherType = Enum.valueOf(MatcherType.class, matcher.getType().toUpperCase());
            switch (matcherType) {
                case FQN: {
                    String fqn = this.getFqn(matcher);
                    return this.getResolvedVariables(matcherType, matcher.getValue(), fqn, variableAssignments);
                }
            }
        }
        catch (IllegalArgumentException e) {
            LOG.warn("Matcher type '{}' not registered --> no match!", (Object)matcher.getType());
        }
        return Maps.newHashMap();
    }

    private String getFqn(MatcherTo matcher) {
        Object target = matcher.getTarget();
        String fqn = null;
        if (target instanceof Object[]) {
            target = ((Object[])target)[0];
        }
        if (target instanceof Class) {
            fqn = ((Class)target).getCanonicalName();
        } else if (target instanceof JavaClass) {
            fqn = ((JavaClass)target).getCanonicalName();
        }
        return fqn;
    }

    public Map<String, String> getResolvedVariables(MatcherType matcherType, String matcherValue, String stringToMatch, List<VariableAssignmentTo> variableAssignments) throws InvalidConfigurationException {
        HashMap<String, String> resolvedVariables = new HashMap<String, String>();
        for (VariableAssignmentTo va : variableAssignments) {
            VariableType variableType = Enum.valueOf(VariableType.class, va.getType().toUpperCase());
            switch (variableType) {
                case CONSTANT: {
                    resolvedVariables.put(va.getVarName(), va.getValue());
                    break;
                }
                case REGEX: {
                    String resolvedRegexValue = this.resolveRegexValue(matcherType, matcherValue, stringToMatch, va);
                    resolvedVariables.put(va.getVarName(), resolvedRegexValue != null ? resolvedRegexValue : "");
                }
            }
        }
        return resolvedVariables;
    }

    private String resolveRegexValue(MatcherType matcherType, String matcherValue, String stringToMatch, VariableAssignmentTo va) throws InvalidConfigurationException {
        Pattern p = Pattern.compile(matcherValue);
        Matcher m = p.matcher(stringToMatch);
        if (m != null) {
            if (m.matches()) {
                try {
                    String value = m.group(Integer.parseInt(va.getValue()));
                    return value;
                }
                catch (NumberFormatException e) {
                    LOG.error("The VariableAssignment '{}' of Matcher of type '{}' should have an integer as value representing a regular expression group.\nCurrent value: '{}'", new Object[]{va.getType().toUpperCase(), matcherType.toString(), va.getValue(), e});
                    throw new InvalidConfigurationException("The VariableAssignment '" + va.getType().toUpperCase() + "' of Matcher of type '" + matcherType.toString() + "' should have an integer as value representing a regular expression group.\nCurrent value: '" + va.getValue() + "'");
                }
                catch (IndexOutOfBoundsException e) {
                    LOG.error("The VariableAssignment '{}' of Matcher of type '{}' declares a regular expression group not in range.\nCurrent value: '{}'", new Object[]{va.getType().toUpperCase(), matcherType.toString(), va.getValue(), e});
                    throw new InvalidConfigurationException("The VariableAssignment '" + va.getType().toUpperCase() + "' of Matcher of type '" + matcherType.toString() + "' declares a regular expression group not in range.\nCurrent value: '" + va.getValue() + "'");
                }
            }
        } else {
            throw new InvalidConfigurationException("The VariableAssignment type 'REGEX' can only be combined with matcher type 'FQN' or 'PACKAGE'");
        }
        return null;
    }

    private static enum VariableType {
        CONSTANT,
        REGEX;

    }

    private static enum MatcherType {
        FQN,
        PACKAGE,
        EXPRESSION;

    }
}

