/*
 * Decompiled with CFR 0.152.
 */
package com.devonfw.cobigen.javaplugin.inputreader;

import com.devonfw.cobigen.api.util.StringUtil;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import net.sf.mmm.util.pojo.descriptor.api.PojoDescriptor;
import net.sf.mmm.util.pojo.descriptor.api.PojoDescriptorBuilder;
import net.sf.mmm.util.pojo.descriptor.api.PojoPropertyDescriptor;
import net.sf.mmm.util.pojo.descriptor.api.accessor.PojoPropertyAccessor;
import net.sf.mmm.util.pojo.descriptor.api.accessor.PojoPropertyAccessorMode;
import net.sf.mmm.util.pojo.descriptor.api.accessor.PojoPropertyAccessorNonArgMode;
import net.sf.mmm.util.pojo.descriptor.api.accessor.PojoPropertyAccessorOneArgMode;
import net.sf.mmm.util.pojo.descriptor.impl.PojoDescriptorBuilderFactoryImpl;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReflectedJavaModelBuilder {
    private static final Logger LOG = LoggerFactory.getLogger(ReflectedJavaModelBuilder.class);
    private Class<?> cachedPojo;
    private Map<String, Object> cachedModel;

    Map<String, Object> createModel(Class<?> pojo) {
        if (this.cachedPojo != null && this.cachedPojo.equals(pojo)) {
            return new HashMap<String, Object>(this.cachedModel);
        }
        this.cachedPojo = pojo;
        this.cachedModel = new HashMap<String, Object>();
        HashMap<String, Object> pojoModel = new HashMap<String, Object>();
        pojoModel.put("name", pojo.getSimpleName());
        if (pojo.getPackage() != null) {
            pojoModel.put("package", pojo.getPackage().getName());
        } else {
            pojoModel.put("package", "");
        }
        pojoModel.put("canonicalName", pojo.getCanonicalName());
        HashMap<String, Object> annotations = new HashMap<String, Object>();
        this.extractAnnotationsRecursively(annotations, pojo.getAnnotations());
        pojoModel.put("annotations", annotations);
        List<Map<String, Object>> attributes = this.extractFields(pojo);
        pojoModel.put("attributes", attributes);
        pojoModel.put("fields", attributes);
        this.determinePojoIds(pojo, attributes);
        this.collectAnnotations(pojo, attributes);
        List<Map<String, Object>> accessibleAttributes = this.extractMethodAccessibleFields(pojo);
        pojoModel.put("methodAccessibleFields", accessibleAttributes);
        this.determinePojoIds(pojo, accessibleAttributes);
        this.collectAnnotations(pojo, accessibleAttributes);
        Map<String, Object> superclass = this.extractSuperclass(pojo);
        pojoModel.put("extendedType", superclass);
        List<Map<String, Object>> interfaces = this.extractInterfaces(pojo);
        pojoModel.put("implementedTypes", interfaces);
        pojoModel.put("methods", this.extractMethods(pojo));
        this.cachedModel.put("pojo", pojoModel);
        this.cachedModel.put("classObject", pojo);
        return new HashMap<String, Object>(this.cachedModel);
    }

    private List<Map<String, Object>> extractMethodAccessibleFields(Class<?> pojo) {
        PojoDescriptorBuilder pojoFieldDescriptorBuilder = PojoDescriptorBuilderFactoryImpl.getInstance().createPrivateFieldDescriptorBuilder();
        PojoDescriptor pojoFieldDescriptor = pojoFieldDescriptorBuilder.getDescriptor(pojo);
        Collection propertyFieldDescriptors = pojoFieldDescriptor.getPropertyDescriptors();
        Iterator it = propertyFieldDescriptors.iterator();
        HashMap existingFields = Maps.newHashMap();
        while (it.hasNext()) {
            PojoPropertyDescriptor fieldDescriptor = (PojoPropertyDescriptor)it.next();
            if (fieldDescriptor.getAccessors().isEmpty()) continue;
            existingFields.put(fieldDescriptor.getName(), (Field)((PojoPropertyAccessor)fieldDescriptor.getAccessors().iterator().next()).getAccessibleObject());
        }
        PojoDescriptorBuilder pojoMethodDescriptorBuilder = PojoDescriptorBuilderFactoryImpl.getInstance().createPublicMethodDescriptorBuilder();
        PojoDescriptor pojoMethodDescriptor = pojoMethodDescriptorBuilder.getDescriptor(pojo);
        Collection propertyMethodDescriptors = pojoMethodDescriptor.getPropertyDescriptors();
        it = propertyMethodDescriptors.iterator();
        LinkedList<Map<String, Object>> fields = new LinkedList<Map<String, Object>>();
        while (it.hasNext()) {
            PojoPropertyDescriptor methodDescriptor = (PojoPropertyDescriptor)it.next();
            PojoPropertyAccessor getter = methodDescriptor.getAccessor((PojoPropertyAccessorMode)PojoPropertyAccessorNonArgMode.GET);
            PojoPropertyAccessor setter = methodDescriptor.getAccessor((PojoPropertyAccessorMode)PojoPropertyAccessorOneArgMode.SET);
            if (getter == null || setter == null || !existingFields.containsKey(getter.getName())) continue;
            fields.add(this.extractFieldProperties((Field)existingFields.get(getter.getName())));
        }
        return fields;
    }

    private List<Map<String, Object>> extractFields(Class<?> pojo) {
        LinkedList<Map<String, Object>> fields = new LinkedList<Map<String, Object>>();
        for (Field field : pojo.getDeclaredFields()) {
            if (Modifier.isStatic(field.getModifiers())) continue;
            fields.add(this.extractFieldProperties(field));
        }
        return fields;
    }

    private Map<String, Object> extractFieldProperties(Field field) {
        HashMap<String, Object> fieldValues = new HashMap<String, Object>();
        fieldValues.put("name", field.getName());
        String type = field.getType().getSimpleName();
        if (field.getType().getTypeParameters().length > 0) {
            type = type + "<";
            for (int i = 0; i < field.getType().getTypeParameters().length; ++i) {
                if (!type.endsWith("<")) {
                    type = type + ",";
                }
                type = type + "?";
            }
            type = type + ">";
        }
        fieldValues.put("type", type);
        fieldValues.put("canonicalType", field.getType().getCanonicalName());
        return fieldValues;
    }

    private Map<String, Object> extractSuperclass(Class<?> pojo) {
        HashMap<String, Object> superclassModel = new HashMap<String, Object>();
        Class<?> superclass = pojo.getSuperclass();
        if (superclass != null) {
            superclassModel.put("name", superclass.getSimpleName());
            superclassModel.put("canonicalName", superclass.getCanonicalName());
            if (superclass.getPackage() != null) {
                superclassModel.put("package", superclass.getPackage().getName());
            } else {
                superclassModel.put("package", "");
            }
            return superclassModel;
        }
        return null;
    }

    private List<Map<String, Object>> extractInterfaces(Class<?> pojo) {
        LinkedList<Map<String, Object>> interfaceList = new LinkedList<Map<String, Object>>();
        for (Class<?> c : pojo.getInterfaces()) {
            HashMap<String, String> interfaceModel = new HashMap<String, String>();
            interfaceModel.put("name", c.getSimpleName());
            interfaceModel.put("canonicalName", c.getCanonicalName());
            if (c.getPackage() != null) {
                interfaceModel.put("package", c.getPackage().getName());
            } else {
                interfaceModel.put("package", "");
            }
            interfaceList.add(interfaceModel);
        }
        return interfaceList;
    }

    private List<Map<String, Object>> extractMethods(Class<?> pojo) {
        LinkedList<Map<String, Object>> methods = new LinkedList<Map<String, Object>>();
        for (Method method : pojo.getMethods()) {
            HashMap<String, Object> methodAttributes = new HashMap<String, Object>();
            methodAttributes.put("name", method.getName());
            HashMap<String, Object> annotations = new HashMap<String, Object>();
            this.extractAnnotationsRecursively(annotations, method.getAnnotations());
            methodAttributes.put("annotations", annotations);
            methods.add(methodAttributes);
        }
        return methods;
    }

    private void collectAnnotations(Class<?> pojo, List<Map<String, Object>> attributes) {
        for (Map<String, Object> attr : attributes) {
            Method getter2;
            HashMap<String, Object> annotations = new HashMap<String, Object>();
            attr.put("annotations", annotations);
            Field field = null;
            try {
                field = pojo.getDeclaredField((String)attr.get("name"));
            }
            catch (NoSuchFieldException noSuchFieldException) {
                // empty catch block
            }
            if (field == null) {
                boolean fieldNotFound = true;
                Class<?> actualClass = pojo.getSuperclass();
                while (fieldNotFound) {
                    try {
                        field = actualClass.getDeclaredField((String)attr.get("name"));
                        if (field == null) continue;
                        fieldNotFound = false;
                    }
                    catch (NoSuchFieldException e) {
                        if ((actualClass = actualClass.getSuperclass()) != Object.class) continue;
                        fieldNotFound = false;
                    }
                }
            }
            if (field != null) {
                this.extractAnnotationsRecursively(annotations, field.getAnnotations());
            }
            try {
                getter2 = pojo.getMethod("get" + StringUtils.capitalize((String)((String)attr.get("name"))), new Class[0]);
                this.extractAnnotationsRecursively(annotations, getter2.getAnnotations());
            }
            catch (NoSuchMethodException getter2) {
                // empty catch block
            }
            try {
                getter2 = pojo.getMethod("is" + StringUtils.capitalize((String)((String)attr.get("name"))), new Class[0]);
                this.extractAnnotationsRecursively(annotations, getter2.getAnnotations());
            }
            catch (NoSuchMethodException getter3) {
                // empty catch block
            }
            try {
                Class[] paramList = new Class[1];
                if (field != null) {
                    Class<?> attrClass;
                    paramList[0] = attrClass = field.getType();
                }
                Method setter = pojo.getMethod("set" + StringUtils.capitalize((String)((String)attr.get("name"))), paramList);
                this.extractAnnotationsRecursively(annotations, setter.getAnnotations());
            }
            catch (NoSuchMethodException noSuchMethodException) {}
        }
    }

    private void extractAnnotationsRecursively(Map<String, Object> annotationsMap, Annotation[] annotations) {
        for (Annotation annotation : annotations) {
            HashMap<String, Object> annotationParameters = new HashMap<String, Object>();
            annotationsMap.put(annotation.annotationType().getCanonicalName().replaceAll("\\.", "_"), annotationParameters);
            for (Method getter : annotation.annotationType().getMethods()) {
                if (getter.getParameterTypes().length > 0 || getter.getName().equals("hashCode") || getter.getName().equals("annotationType") || getter.getName().equals("toString")) continue;
                try {
                    Object value = getter.invoke((Object)annotation, new Object[0]);
                    if (value instanceof Annotation[]) {
                        LinkedList recursiveAnnotationList = Lists.newLinkedList();
                        for (Annotation a : (Annotation[])value) {
                            HashMap annotationParameterParameters = Maps.newHashMap();
                            this.extractAnnotationsRecursively(annotationParameterParameters, new Annotation[]{a});
                            recursiveAnnotationList.add(annotationParameterParameters);
                        }
                        annotationParameters.put(getter.getName(), recursiveAnnotationList);
                        continue;
                    }
                    if (value instanceof Enum[]) {
                        LinkedList enumValues = Lists.newLinkedList();
                        for (Enum e : (Enum[])value) {
                            enumValues.add(e.name());
                        }
                        annotationParameters.put(getter.getName(), enumValues);
                        continue;
                    }
                    if (value instanceof Object[]) {
                        annotationParameters.put(getter.getName(), Lists.newLinkedList(Arrays.asList((Object[])value)));
                        continue;
                    }
                    if (value instanceof Enum) {
                        annotationParameters.put(getter.getName(), ((Enum)value).name());
                        continue;
                    }
                    if (value instanceof Byte || value instanceof Short || value instanceof Integer || value instanceof Long || value instanceof Float || value instanceof Double || value instanceof Boolean || value instanceof Character) {
                        annotationParameters.put(getter.getName(), value.toString());
                        continue;
                    }
                    annotationParameters.put(getter.getName(), value != null ? value.toString() : null);
                }
                catch (IllegalAccessException | InvocationTargetException e) {
                    LOG.error("An error occured while retrieving value '{}' from annotation '{}'.", new Object[]{getter.getName(), annotation.getClass(), e});
                }
            }
        }
    }

    private void determinePojoIds(Class<?> pojo, List<Map<String, Object>> attributes) {
        for (Map<String, Object> attr : attributes) {
            try {
                Annotation[] annotations;
                Method getter = null;
                try {
                    getter = pojo.getDeclaredMethod("get" + StringUtil.capFirst((String)((String)attr.get("name"))), new Class[0]);
                }
                catch (NoSuchMethodException | SecurityException e) {
                    getter = pojo.getDeclaredMethod("is" + StringUtil.capFirst((String)((String)attr.get("name"))), new Class[0]);
                }
                if (getter == null) {
                    return;
                }
                for (Annotation a : annotations = getter.getAnnotations()) {
                    if (!"javax.persistence.Id".equals(a.annotationType().getCanonicalName())) continue;
                    attr.put("isId", "true");
                    break;
                }
                if (attr.get("isId") != null) continue;
                attr.put("isId", "false");
            }
            catch (NoSuchMethodException | SecurityException exception) {}
        }
    }
}

