/*
 * Decompiled with CFR 0.152.
 */
package com.devonfw.cobigen.javaplugin.inputreader;

import com.devonfw.cobigen.api.util.StringUtil;
import com.devonfw.cobigen.javaplugin.inputreader.JavaParserUtil;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.thoughtworks.qdox.model.BeanProperty;
import com.thoughtworks.qdox.model.DocletTag;
import com.thoughtworks.qdox.model.JavaAnnotatedElement;
import com.thoughtworks.qdox.model.JavaAnnotation;
import com.thoughtworks.qdox.model.JavaClass;
import com.thoughtworks.qdox.model.JavaField;
import com.thoughtworks.qdox.model.JavaMethod;
import com.thoughtworks.qdox.model.JavaParameter;
import com.thoughtworks.qdox.model.JavaType;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;

public class ParsedJavaModelBuilder {
    private JavaClass cachedPojo;
    private Map<String, Object> cachedModel;

    Map<String, Object> createModel(JavaClass javaClass) {
        if (this.cachedPojo != null && this.cachedPojo.equals(javaClass)) {
            return new HashMap<String, Object>(this.cachedModel);
        }
        this.cachedPojo = javaClass;
        this.cachedModel = new HashMap<String, Object>();
        HashMap<String, Object> pojoModel = new HashMap<String, Object>();
        pojoModel.put("name", javaClass.getName());
        if (javaClass.getPackage() != null) {
            pojoModel.put("package", javaClass.getPackage().getName());
        } else {
            pojoModel.put("package", "");
        }
        pojoModel.put("canonicalName", javaClass.getCanonicalName());
        Map<String, Object> javaDoc = this.extractJavaDoc((JavaAnnotatedElement)javaClass);
        if (javaDoc != null) {
            pojoModel.put("javaDoc", javaDoc);
        }
        HashMap<String, Object> annotations = new HashMap<String, Object>();
        this.extractAnnotationsRecursively(annotations, javaClass.getAnnotations());
        pojoModel.put("annotations", annotations);
        List<Map<String, Object>> fields = this.extractFields(javaClass);
        pojoModel.put("attributes", fields);
        pojoModel.put("fields", fields);
        this.determinePojoIds(javaClass, fields);
        this.collectAnnotations(javaClass, fields);
        List<Map<String, Object>> accessibleAttributes = this.extractMethodAccessibleFields(javaClass);
        pojoModel.put("methodAccessibleFields", accessibleAttributes);
        this.determinePojoIds(javaClass, accessibleAttributes);
        this.collectAnnotations(javaClass, accessibleAttributes);
        Map<String, Object> superclass = this.extractSuperclass(javaClass);
        pojoModel.put("extendedType", superclass);
        List<Map<String, Object>> interfaces = this.extractInterfaces(javaClass);
        pojoModel.put("implementedTypes", interfaces);
        pojoModel.put("methods", this.extractMethods(javaClass));
        this.cachedModel.put("pojo", pojoModel);
        return new HashMap<String, Object>(this.cachedModel);
    }

    private List<Map<String, Object>> extractMethodAccessibleFields(JavaClass javaClass) {
        LinkedList fields = Lists.newLinkedList();
        List beanProperties = javaClass.getBeanProperties(true);
        for (BeanProperty property : beanProperties) {
            if (property.getAccessor() == null || property.getMutator() == null) continue;
            fields.add(this.extractField(property.getName(), property.getType(), null));
        }
        return fields;
    }

    private List<Map<String, Object>> extractMethods(JavaClass javaClass) {
        LinkedList<Map<String, Object>> methods = new LinkedList<Map<String, Object>>();
        for (JavaMethod method : javaClass.getMethods()) {
            Map<String, Object> javaDoc;
            HashMap<String, Object> methodAttributes = new HashMap<String, Object>();
            methodAttributes.put("name", method.getName());
            if (method.getComment() != null && (javaDoc = this.extractJavaDoc((JavaAnnotatedElement)method)) != null) {
                methodAttributes.put("javaDoc", javaDoc);
            }
            HashMap<String, Object> annotations = new HashMap<String, Object>();
            this.extractAnnotationsRecursively(annotations, method.getAnnotations());
            methodAttributes.put("annotations", annotations);
            methods.add(methodAttributes);
        }
        return methods;
    }

    private List<Map<String, Object>> extractFields(JavaClass pojo) {
        LinkedList<Map<String, Object>> fields = new LinkedList<Map<String, Object>>();
        for (JavaField f : pojo.getFields()) {
            if (f.isStatic()) continue;
            fields.add(this.extractField(f.getName(), (JavaType)f.getType(), (JavaAnnotatedElement)f));
        }
        return fields;
    }

    private Map<String, Object> extractField(String fieldName, JavaType field, JavaAnnotatedElement annotatedElement) {
        Map<String, Object> javaDoc;
        HashMap<String, Object> fieldValues = new HashMap<String, Object>();
        fieldValues.put("name", fieldName);
        fieldValues.put("type", JavaParserUtil.resolveToSimpleType(field.getGenericValue()));
        fieldValues.put("canonicalType", field.getGenericCanonicalName());
        if (annotatedElement != null && (javaDoc = this.extractJavaDoc(annotatedElement)) != null) {
            fieldValues.put("javaDoc", javaDoc);
        }
        return fieldValues;
    }

    private Map<String, Object> extractSuperclass(JavaClass pojo) {
        HashMap<String, Object> superclassModel = new HashMap<String, Object>();
        JavaClass superclass = pojo.getSuperJavaClass();
        if (superclass != null) {
            superclassModel.put("name", superclass.getName());
            superclassModel.put("canonicalName", superclass.getCanonicalName());
            if (superclass.getPackage() != null) {
                superclassModel.put("package", superclass.getPackage().getName());
            } else {
                superclassModel.put("package", "");
            }
            Map<String, Object> javaDoc = this.extractJavaDoc((JavaAnnotatedElement)superclass);
            if (javaDoc != null) {
                superclassModel.put("javaDoc", javaDoc);
            }
            return superclassModel;
        }
        return null;
    }

    private List<Map<String, Object>> extractInterfaces(JavaClass pojo) {
        LinkedList<Map<String, Object>> interfaceList = new LinkedList<Map<String, Object>>();
        for (JavaClass c : pojo.getInterfaces()) {
            HashMap<String, Object> interfaceModel = new HashMap<String, Object>();
            interfaceModel.put("name", c.getName());
            interfaceModel.put("canonicalName", c.getCanonicalName());
            if (c.getPackage() != null) {
                interfaceModel.put("package", c.getPackage().getName());
            } else {
                interfaceModel.put("package", "");
            }
            Map<String, Object> javaDoc = this.extractJavaDoc((JavaAnnotatedElement)c);
            if (javaDoc != null) {
                interfaceModel.put("javaDoc", javaDoc);
            }
            interfaceList.add(interfaceModel);
        }
        return interfaceList;
    }

    private void collectAnnotations(JavaClass javaClass, List<Map<String, Object>> attributes) {
        for (Map<String, Object> attr : attributes) {
            JavaMethod setter;
            JavaMethod getter;
            HashMap<String, Object> annotations = new HashMap<String, Object>();
            attr.put("annotations", annotations);
            JavaField classField = javaClass.getFieldByName((String)attr.get("name"));
            if (classField != null) {
                this.extractAnnotationsRecursively(annotations, classField.getAnnotations());
            }
            if ((getter = javaClass.getMethod("get" + StringUtils.capitalize((String)((String)attr.get("name"))), null, false)) != null) {
                this.extractAnnotationsRecursively(annotations, getter.getAnnotations());
            }
            if ((getter = javaClass.getMethod("is" + StringUtils.capitalize((String)((String)attr.get("name"))), null, false)) != null) {
                this.extractAnnotationsRecursively(annotations, getter.getAnnotations());
            }
            ArrayList<JavaClass> paramList = null;
            if (classField != null) {
                JavaClass attrType = classField.getType();
                paramList = new ArrayList<JavaClass>();
                paramList.add(attrType);
            }
            if ((setter = javaClass.getMethod("set" + StringUtils.capitalize((String)((String)attr.get("name"))), paramList, false)) == null) continue;
            this.extractAnnotationsRecursively(annotations, setter.getAnnotations());
        }
    }

    private void extractAnnotationsRecursively(Map<String, Object> annotationsMap, List<JavaAnnotation> annotations) {
        for (JavaAnnotation annotation : annotations) {
            HashMap<String, Object> annotationParameters = new HashMap<String, Object>();
            annotationsMap.put(annotation.getType().getCanonicalName().replaceAll("\\.", "_"), annotationParameters);
            for (String propertyName : annotation.getPropertyMap().keySet()) {
                Object value = annotation.getNamedParameter(propertyName);
                if (value instanceof List && ((List)value).size() > 0 && ((List)value).get(0) instanceof JavaAnnotation) {
                    LinkedList recursiveAnnotationList = Lists.newLinkedList();
                    annotationParameters.put(propertyName, recursiveAnnotationList);
                    for (JavaAnnotation a : (List)value) {
                        HashMap<String, Object> annotationParameterParameters = new HashMap<String, Object>();
                        this.extractAnnotationsRecursively(annotationParameterParameters, Lists.newArrayList((Object[])new JavaAnnotation[]{a}));
                        recursiveAnnotationList.add(annotationParameterParameters);
                    }
                    continue;
                }
                if (value instanceof Enum[]) {
                    LinkedList enumValues = Lists.newLinkedList();
                    for (Enum e : (Enum[])value) {
                        enumValues.add(e.name());
                    }
                    annotationParameters.put(propertyName, enumValues);
                    continue;
                }
                if (value instanceof Object[]) {
                    annotationParameters.put(propertyName, value);
                    continue;
                }
                if (value instanceof Enum) {
                    annotationParameters.put(propertyName, ((Enum)value).name());
                    continue;
                }
                if (value instanceof Collection) {
                    annotationParameters.put(propertyName, value);
                    continue;
                }
                if (value instanceof Byte || value instanceof Short || value instanceof Integer || value instanceof Long || value instanceof Float || value instanceof Double || value instanceof Boolean || value instanceof Character) {
                    annotationParameters.put(propertyName, value);
                    continue;
                }
                if (value instanceof String) {
                    if (((String)value).matches("\".*\"")) {
                        value = ((String)value).replaceFirst("\"(.*)\"", "$1");
                    }
                    annotationParameters.put(propertyName, value);
                    continue;
                }
                annotationParameters.put(propertyName, value != null ? value.toString() : null);
            }
        }
    }

    private Map<String, Object> extractJavaDoc(JavaAnnotatedElement annotatedElement) {
        if (annotatedElement.getComment() == null) {
            return null;
        }
        HashMap javaDocModel = Maps.newHashMap();
        javaDocModel.put("comment", annotatedElement.getComment());
        HashMap params = Maps.newHashMap();
        HashMap thrown = Maps.newHashMap();
        for (DocletTag tag : annotatedElement.getTags()) {
            String tagValue = tag.getValue();
            String tagName = tag.getName();
            if (annotatedElement instanceof JavaMethod) {
                String name = StringUtils.substringBefore((String)tagValue, (String)" ").trim();
                String value = StringUtils.substringAfter((String)tagValue, (String)" ").trim();
                if (tagName.equals("param")) {
                    JavaMethod jm = (JavaMethod)annotatedElement;
                    int i = 0;
                    for (JavaParameter jp : jm.getParameters()) {
                        if (name.equals(jp.getName())) {
                            params.put(name, value);
                            params.put("arg" + i, value);
                        }
                        ++i;
                    }
                    continue;
                }
                if (tagName.equals("throws")) {
                    thrown.put(name, value);
                    continue;
                }
                javaDocModel.put(tagName, tagValue);
                continue;
            }
            javaDocModel.put(tagName, tagValue);
        }
        javaDocModel.put("params", params);
        javaDocModel.put("throws", thrown);
        return javaDocModel;
    }

    @Deprecated
    private void determinePojoIds(JavaClass javaClass, List<Map<String, Object>> attributes) {
        for (Map<String, Object> attr : attributes) {
            JavaMethod getter = null;
            try {
                getter = javaClass.getMethod("get" + StringUtil.capFirst((String)((String)attr.get("name"))), null, false);
            }
            catch (Exception e) {
                getter = javaClass.getMethod("is" + StringUtil.capFirst((String)((String)attr.get("name"))), null, false);
            }
            if (getter == null) {
                return;
            }
            List annotations = getter.getAnnotations();
            for (JavaAnnotation a : annotations) {
                if (!"javax.persistence.Id".equals(a.getType().getCanonicalName())) continue;
                attr.put("isId", "true");
                break;
            }
            if (attr.get("isId") != null) continue;
            attr.put("isId", "false");
        }
    }
}

