/*
 * Decompiled with CFR 0.152.
 */
package com.devonfw.module.basic.common.api.user;

import com.devonfw.module.basic.common.api.user.UserSessionProvider;
import com.devonfw.module.basic.common.api.user.UserSessionProviderImpl;
import java.util.Locale;

public class UserSessionAccess {
    private static UserSessionProvider provider;

    static UserSessionProvider getProvider() {
        if (provider == null) {
            return UserSessionAccess.getOrCreateProvider();
        }
        return provider;
    }

    private static synchronized UserSessionProvider getOrCreateProvider() {
        if (provider == null) {
            provider = new UserSessionProviderImpl();
        }
        return provider;
    }

    static void setProvider(UserSessionProvider provider) {
        if (UserSessionAccess.provider != null) {
            if (UserSessionAccess.provider == provider) {
                return;
            }
            throw new IllegalStateException("Provider is already initialized! Please set the provider at the beginning of the bootstrapping of your application.");
        }
        UserSessionAccess.provider = provider;
    }

    public static String getUserLogin() {
        return UserSessionAccess.getProvider().getUserLogin();
    }

    public static Locale getUserLocale() {
        return UserSessionAccess.getProvider().getUserLocale();
    }
}

