/*
 * Decompiled with CFR 0.152.
 */
package com.devonfw.module.security.common.api.authentication;

import com.devonfw.module.security.common.api.authentication.DefaultAuthentication;
import java.util.Objects;
import java.util.Set;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.security.core.context.SecurityContextHolder;

public interface AdvancedAuthentication
extends Authentication {
    default public <T> T getAttribute(String key) {
        return null;
    }

    default public void setAttribute(String key, Object value) {
        throw new UnsupportedOperationException();
    }

    public Set<String> getPermissions();

    default public boolean hasPermission(String permission) {
        return this.getPermissions().contains(permission);
    }

    public static boolean hasPermission(Authentication authentication, String permission) {
        if (authentication == null) {
            return false;
        }
        if (authentication instanceof AdvancedAuthentication) {
            return ((AdvancedAuthentication)authentication).hasPermission(permission);
        }
        for (GrantedAuthority authority : authentication.getAuthorities()) {
            if (authority == null || !Objects.equals(authority.getAuthority(), permission)) continue;
            return true;
        }
        return false;
    }

    public static AdvancedAuthentication get() {
        Authentication authentication = SecurityContextHolder.getContext().getAuthentication();
        if (authentication == null) {
            return null;
        }
        if (authentication instanceof AdvancedAuthentication) {
            return (AdvancedAuthentication)authentication;
        }
        Object principal = authentication.getPrincipal();
        if (principal instanceof AdvancedAuthentication) {
            return (AdvancedAuthentication)principal;
        }
        Object details = authentication.getDetails();
        if (details instanceof AdvancedAuthentication) {
            return (AdvancedAuthentication)details;
        }
        throw new IllegalStateException(authentication.getClass().getSimpleName());
    }

    public static Set<String> getPermissions(Authentication authentication) {
        if (authentication instanceof AdvancedAuthentication) {
            return ((AdvancedAuthentication)authentication).getPermissions();
        }
        return DefaultAuthentication.authorities2permissions(authentication.getAuthorities());
    }
}

