/*
 * Decompiled with CFR 0.152.
 */
package com.devonfw.module.security.common.api.authentication;

import com.devonfw.module.security.common.api.accesscontrol.AccessControl;
import com.devonfw.module.security.common.api.authentication.AdvancedAuthentication;
import com.devonfw.module.security.common.base.accesscontrol.AccessControlGrantedAuthority;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.springframework.security.authentication.UsernamePasswordAuthenticationToken;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.security.core.authority.SimpleGrantedAuthority;

public class DefaultAuthentication
extends UsernamePasswordAuthenticationToken
implements AdvancedAuthentication {
    private static final long serialVersionUID = 1L;
    private final Set<String> permissions;
    private Map<String, Object> attributes;

    public DefaultAuthentication(Object principal, Object credentials, Collection<? extends GrantedAuthority> authorities) {
        this(principal, credentials, authorities, null, null);
    }

    public DefaultAuthentication(Object principal, Object credentials, Collection<? extends GrantedAuthority> authorities, Map<String, Object> attributes) {
        this(principal, credentials, authorities, null, attributes);
    }

    public DefaultAuthentication(Object principal, Object credentials, Set<String> permissions) {
        this(principal, credentials, permissions.stream().map(SimpleGrantedAuthority::new).collect(Collectors.toList()), permissions, null);
    }

    public static DefaultAuthentication ofAccessControls(Object principal, Object credentials, Collection<? extends AccessControl> accessControls, Map<String, Object> attributes) {
        return new DefaultAuthentication(principal, credentials, accessControls.stream().map(AccessControlGrantedAuthority::new).collect(Collectors.toList()), attributes);
    }

    public DefaultAuthentication(Object principal, Object credentials, Set<String> permissions, Map<String, Object> attributes) {
        this(principal, credentials, permissions.stream().map(SimpleGrantedAuthority::new).collect(Collectors.toList()), permissions, attributes);
    }

    private DefaultAuthentication(Object principal, Object credentials, Collection<? extends GrantedAuthority> authorities, Set<String> permissions, Map<String, Object> attributes) {
        super(principal, credentials, authorities);
        this.attributes = attributes;
        this.permissions = permissions == null ? DefaultAuthentication.authorities2permissions(authorities) : permissions;
    }

    @Override
    public Set<String> getPermissions() {
        return this.permissions;
    }

    public Map<String, Object> getAttributes() {
        return this.attributes;
    }

    @Override
    public <T> T getAttribute(String key) {
        Object value;
        if (this.attributes != null && (value = this.attributes.get(key)) != null) {
            return (T)value;
        }
        return AdvancedAuthentication.super.getAttribute(key);
    }

    @Override
    public void setAttribute(String key, Object value) {
        Object duplicate;
        Objects.requireNonNull(key, "key");
        if (value == null) {
            throw new IllegalArgumentException("Value can not be null for key: " + key);
        }
        if (this.attributes == null) {
            this.attributes = new HashMap<String, Object>();
        }
        if ((duplicate = this.attributes.putIfAbsent(key, value)) != null) {
            throw new IllegalArgumentException("Attribute for key '" + key + "' is already set!");
        }
    }

    static Set<String> authorities2permissions(Collection<? extends GrantedAuthority> authorities) {
        HashSet<String> permissions = new HashSet<String>(authorities.size());
        for (GrantedAuthority grantedAuthority : authorities) {
            if (grantedAuthority == null) continue;
            permissions.add(grantedAuthority.getAuthority());
        }
        return permissions;
    }
}

