/*
 * Decompiled with CFR 0.152.
 */
package com.devonfw.module.security.common.base.accesscontrol;

import com.devonfw.module.security.common.api.accesscontrol.AccessControl;
import com.devonfw.module.security.common.api.accesscontrol.AccessControlGroup;
import com.devonfw.module.security.common.api.accesscontrol.AccessControlPermission;
import com.devonfw.module.security.common.api.accesscontrol.AccessControlProvider;
import com.devonfw.module.security.common.api.accesscontrol.AccessControlSchema;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractAccessControlProvider
implements AccessControlProvider {
    private static final Logger LOG = LoggerFactory.getLogger(AbstractAccessControlProvider.class);
    private final Map<String, AccessControl> id2nodeMap = new HashMap<String, AccessControl>();

    protected void initialize(AccessControlSchema config) {
        LOG.debug("Initializing.");
        List<AccessControlGroup> groups = config.getGroups();
        if (groups.size() == 0) {
            throw new IllegalStateException("AccessControlSchema is empty - please configure at least one group!");
        }
        HashSet<AccessControlGroup> toplevelGroups = new HashSet<AccessControlGroup>(groups);
        for (AccessControlGroup group : groups) {
            this.collectAccessControls(group, toplevelGroups);
            ArrayList<AccessControlGroup> groupList = new ArrayList<AccessControlGroup>();
            groupList.add(group);
            this.checkForCyclicDependencies(group, groupList);
        }
    }

    protected void checkForCyclicDependencies(AccessControlGroup group, List<AccessControlGroup> groupList) {
        for (AccessControlGroup inheritedGroup : group.getInherits()) {
            if (groupList.contains(inheritedGroup)) {
                StringBuilder sb = new StringBuilder("A cyclic dependency of access control groups has been detected: \n");
                for (int i = groupList.size() - 1; i >= 0; --i) {
                    AccessControlGroup node = groupList.get(i);
                    sb.append(node);
                    if (i <= 0) continue;
                    sb.append("-->");
                }
                throw new IllegalStateException(sb.toString());
            }
            groupList.add(inheritedGroup);
            this.checkForCyclicDependencies(inheritedGroup, groupList);
            AccessControlGroup removed = groupList.remove(groupList.size() - 1);
            assert (removed == inheritedGroup);
        }
    }

    protected void collectAccessControls(AccessControlGroup group, Set<AccessControlGroup> toplevelGroups) {
        if (!toplevelGroups.contains(group)) {
            throw new IllegalStateException("Invalid group not declared as top-level group in schema: " + group);
        }
        AccessControl old = this.id2nodeMap.put(group.getId(), group);
        if (old != null) {
            LOG.debug("Already visited access control group {}", (Object)group);
            if (old != group) {
                throw new IllegalStateException("Invalid security configuration: duplicate groups with id " + group.getId() + "!");
            }
            return;
        }
        LOG.debug("Registered access control group {}", (Object)group);
        for (AccessControlPermission permission : group.getPermissions()) {
            old = this.id2nodeMap.put(permission.getId(), permission);
            if (old != null) {
                LOG.warn("Security configuration contains duplicate permission with id {}.", (Object)permission.getId());
                continue;
            }
            LOG.debug("Registered access control permission {}", (Object)permission);
        }
        for (AccessControlGroup inheritedGroup : group.getInherits()) {
            this.collectAccessControls(inheritedGroup, toplevelGroups);
        }
    }

    @Override
    public AccessControl getAccessControl(String nodeId) {
        return this.id2nodeMap.get(nodeId);
    }

    protected void addAccessControl(AccessControl accessControl) {
        String id = accessControl.getId();
        AccessControl existing = this.id2nodeMap.get(id);
        if (existing == null) {
            this.id2nodeMap.put(id, accessControl);
            LOG.debug("Registered access control {}", (Object)accessControl);
        } else if (existing == accessControl) {
            LOG.debug("Access control {} was already registered.", (Object)accessControl);
        } else {
            throw new IllegalStateException("Duplicate access control with ID '" + id + "'.");
        }
    }

    @Override
    public boolean collectAccessControlIds(String groupId, Set<String> permissions) {
        AccessControl node = this.getAccessControl(groupId);
        if (node instanceof AccessControlGroup) {
            this.collectPermissionIds((AccessControlGroup)node, permissions);
        } else {
            permissions.add(groupId);
        }
        return node != null;
    }

    public void collectPermissionIds(AccessControlGroup group, Set<String> permissions) {
        boolean added = permissions.add(group.getId());
        if (!added) {
            return;
        }
        for (AccessControlPermission permission : group.getPermissions()) {
            permissions.add(permission.getId());
        }
        for (AccessControlGroup inheritedGroup : group.getInherits()) {
            this.collectPermissionIds(inheritedGroup, permissions);
        }
    }

    @Override
    public boolean collectAccessControls(String groupId, Set<AccessControl> permissions) {
        AccessControl node = this.getAccessControl(groupId);
        if (node == null) {
            return false;
        }
        if (node instanceof AccessControlGroup) {
            this.collectPermissionNodes((AccessControlGroup)node, permissions);
        } else {
            permissions.add(node);
        }
        return true;
    }

    public void collectPermissionNodes(AccessControlGroup group, Set<AccessControl> permissions) {
        boolean added = permissions.add(group);
        if (!added) {
            return;
        }
        for (AccessControlPermission permission : group.getPermissions()) {
            permissions.add(permission);
        }
        for (AccessControlGroup inheritedGroup : group.getInherits()) {
            this.collectPermissionNodes(inheritedGroup, permissions);
        }
    }
}

