/*
 * Decompiled with CFR 0.152.
 */
package com.devonfw.module.security.common.base.accesscontrol;

import com.devonfw.module.security.common.api.accesscontrol.AccessControl;
import com.devonfw.module.security.common.api.accesscontrol.AccessControlGroup;
import com.devonfw.module.security.common.api.accesscontrol.AccessControlPermission;
import com.devonfw.module.security.common.base.accesscontrol.AbstractAccessControlProvider;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public abstract class AccessControlConfig
extends AbstractAccessControlProvider {
    protected AccessControlPermission permission(String id) {
        AccessControl accessControl = this.getAccessControl(id);
        if (accessControl instanceof AccessControlPermission) {
            return (AccessControlPermission)accessControl;
        }
        if (accessControl != null) {
            throw new IllegalStateException("Duplicate access control for ID '" + id + "'.");
        }
        AccessControlPermission permission = new AccessControlPermission(id);
        this.addAccessControl(permission);
        return permission;
    }

    protected AccessControlGroup group(String groupId, String ... permissionIds) {
        return this.group(groupId, Collections.emptyList(), permissionIds);
    }

    protected AccessControlGroup group(String groupId, AccessControlGroup inherit, String ... permissionIds) {
        return this.group(groupId, Collections.singletonList(inherit), permissionIds);
    }

    protected AccessControlGroup group(String groupId, List<AccessControlGroup> inherits, String ... permissionIds) {
        AccessControlGroup group = new AccessControlGroup(groupId);
        group.setInherits(inherits);
        ArrayList<AccessControlPermission> permissions = new ArrayList<AccessControlPermission>(permissionIds.length);
        for (String permissionId : permissionIds) {
            permissions.add(this.permission(permissionId));
        }
        group.setPermissions(permissions);
        this.addAccessControl(group);
        return group;
    }
}

