/*
 * Decompiled with CFR 0.152.
 */
package com.devonfw.module.security.common.impl.accesscontrol;

import com.devonfw.module.security.common.api.accesscontrol.AccessControlSchema;
import com.devonfw.module.security.common.base.accesscontrol.AccessControlSchemaMapper;
import com.devonfw.module.security.common.base.accesscontrol.AccessControlSchemaProvider;
import com.devonfw.module.security.common.impl.accesscontrol.AccessControlSchemaXmlMapper;
import java.io.InputStream;
import javax.annotation.PostConstruct;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.io.ClassPathResource;
import org.springframework.core.io.Resource;

public class AccessControlSchemaProviderImpl
implements AccessControlSchemaProvider {
    private static final Logger LOG = LoggerFactory.getLogger(AccessControlSchemaProviderImpl.class);
    private Resource accessControlSchema;
    private AccessControlSchemaMapper accessControlSchemaMapper;
    private boolean initialized = false;

    @PostConstruct
    public void initialize() {
        if (this.initialized) {
            return;
        }
        LOG.debug("Initializing.");
        if (this.accessControlSchemaMapper == null) {
            this.accessControlSchemaMapper = new AccessControlSchemaXmlMapper();
        }
        if (this.accessControlSchema == null) {
            this.accessControlSchema = new ClassPathResource("config/app/security/access-control-schema.xml");
        }
        this.initialized = true;
    }

    @Override
    public AccessControlSchema loadSchema() {
        AccessControlSchema accessControlSchema;
        block8: {
            this.initialize();
            LOG.debug("Reading access control schema from {}", (Object)this.accessControlSchema);
            InputStream inputStream = this.accessControlSchema.getInputStream();
            try {
                AccessControlSchema schema = this.accessControlSchemaMapper.read(inputStream);
                LOG.debug("Reading access control schema completed successfully.");
                accessControlSchema = schema;
                if (inputStream == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (inputStream != null) {
                        try {
                            inputStream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    throw new IllegalStateException("Failed to load access control schema from " + this.accessControlSchema, e);
                }
            }
            inputStream.close();
        }
        return accessControlSchema;
    }

    public AccessControlSchemaMapper getAccessControlSchemaMapper() {
        return this.accessControlSchemaMapper;
    }

    public void setAccessControlSchemaMapper(AccessControlSchemaMapper accessControlSchemaMapper) {
        this.accessControlSchemaMapper = accessControlSchemaMapper;
    }

    public Resource getAccessControlSchema() {
        return this.accessControlSchema;
    }

    public void setAccessControlSchema(Resource accessControlSchema) {
        this.accessControlSchema = accessControlSchema;
    }
}

