/*
 * Decompiled with CFR 0.152.
 */
package com.devops4j.embedded;

import com.devops4j.embedded.handler.DelegateHttpHandler;
import com.devops4j.embedded.handler.StaticHttpHandler;
import com.devops4j.embedded.httpserver.HttpServer;
import com.devops4j.embedded.httpserver.HttpsConfigurator;
import com.devops4j.embedded.httpserver.HttpsServer;
import com.devops4j.embedded.servlet.EmbeddedServletConfig;
import com.devops4j.logtrace4j.ErrorContextFactory;
import com.devops4j.message.MessageFormatter;
import com.devops4j.reflection4j.GlobalSystemMetadata;
import com.devops4j.reflection4j.MetaClass;
import com.devops4j.reflection4j.resource.ClassScanner;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.InetSocketAddress;
import java.net.URISyntaxException;
import java.net.URL;
import java.security.KeyManagementException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.UnrecoverableKeyException;
import java.security.cert.CertificateException;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.servlet.Servlet;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.annotation.WebServlet;
import javax.servlet.http.HttpServlet;

public class EmbeddedHttpServer {
    HttpServer httpServer;
    HttpsServer httpsServer;
    ExecutorService threadPool;
    Timer timer;
    final Properties configs = new Properties();
    private Logger logger;
    final Map<String, HttpServlet> servlets = new HashMap<String, HttpServlet>();
    final Map<String, Set<String>> urlPatterns = new HashMap<String, Set<String>>();
    static EmbeddedHttpServer INSTANCE = new EmbeddedHttpServer();

    public EmbeddedHttpServer() {
        this.logger = Logger.getLogger(this.getClass().getName());
    }

    EmbeddedHttpServer registerServlet(String name, Set<String> urlPatterns, HttpServlet servlet) {
        if (servlet == null) {
            throw new NullPointerException("servlet '" + name + "' is null");
        }
        if (this.servlets.containsKey(name)) {
            throw ErrorContextFactory.instance().message("exists servlet name '{}'", new Object[]{name}).runtimeException();
        }
        this.urlPatterns.put(name, urlPatterns);
        for (String urlPattern : urlPatterns) {
            this.servlets.put(urlPattern, servlet);
        }
        return this;
    }

    EmbeddedHttpServer registerServlet(String name, String[] urlPatterns, HttpServlet servlet) {
        LinkedHashSet<String> urlPatterns_0 = new LinkedHashSet<String>();
        for (String urlPattern : urlPatterns) {
            urlPatterns_0.add(urlPattern);
        }
        return this.registerServlet(name, urlPatterns_0, servlet);
    }

    public static EmbeddedHttpServer getInstance() {
        return INSTANCE;
    }

    void _destroy() {
        this.httpServer = null;
        this.httpsServer = null;
        this.threadPool = null;
    }

    public static void destroy() {
        if (INSTANCE != null) {
            INSTANCE._destroy();
            INSTANCE = null;
        }
    }

    public void start() throws IOException {
        this.start(Thread.currentThread().getContextClassLoader());
    }

    void initConfig() {
        block8: {
            this.configs.clear();
            Properties systemProp = System.getProperties();
            String serverFile = systemProp.getProperty("server.properties");
            InputStream is = null;
            try {
                if (serverFile != null) {
                    File file = new File(serverFile);
                    is = new FileInputStream(file);
                } else {
                    URL url = this.getClass().getClassLoader().getResource("server.properties");
                    if (url == null) {
                        this.error("not found httpServer.properties", new Object[0]);
                        return;
                    }
                    is = url.openStream();
                }
                this.configs.load(is);
            }
            catch (IOException e) {
                if (is == null) break block8;
                try {
                    is.close();
                }
                catch (IOException e1) {
                    // empty catch block
                }
            }
        }
        for (Object key : this.configs.keySet()) {
            this.error("config key {}:'{}'", key, this.configs.get(key));
        }
    }

    void initServlet() {
        String scanPackages_ = this.configs.getProperty("server.servlet.packages", "com.devops4j.embedded");
        this.info("scan package'{}'", scanPackages_);
        String[] scanPackages = scanPackages_.split(";");
        String scanSubPackage_ = this.configs.getProperty("server.servlet.scan.subpackage", "true");
        this.info("scan subpackage '{}'", scanSubPackage_);
        ClassScanner classScanner = new ClassScanner(this.getClass().getClassLoader(), Boolean.valueOf(scanSubPackage_).booleanValue());
        for (String scanPackage : scanPackages) {
            classScanner.scan(scanPackage, (ClassScanner.Filter)new ClassScanner.AnnotatedWithFilter(WebServlet.class));
        }
        for (Class servletClass : classScanner.getClasses()) {
            WebServlet webServletAnn = servletClass.getAnnotation(WebServlet.class);
            MetaClass metaClass = GlobalSystemMetadata.forClass((Class)servletClass);
            HttpServlet servlet = (HttpServlet)metaClass.newInstance();
            EmbeddedServletConfig config = new EmbeddedServletConfig();
            try {
                servlet.init((ServletConfig)config);
            }
            catch (ServletException e) {
                throw new RuntimeException("\u521d\u59cb\u5316Servlet\u53d1\u751f\u5931\u8d25", e);
            }
            LinkedHashSet<String> urlPatterns_0 = new LinkedHashSet<String>();
            for (String urlPattern : webServletAnn.value()) {
                urlPatterns_0.add(urlPattern);
            }
            for (String urlPattern : webServletAnn.urlPatterns()) {
                urlPatterns_0.add(urlPattern);
            }
            this.registerServlet(webServletAnn.name(), urlPatterns_0, servlet);
        }
    }

    public void start(ClassLoader classLoader) throws IOException {
        int autoShutdownSeconds;
        if (this.httpServer != null || this.httpsServer != null) {
            this.stop();
            this._destroy();
        }
        this.initConfig();
        if (this.timer == null && (autoShutdownSeconds = Integer.valueOf(this.configs.getProperty("server.shutdown.auto.seconds", "-1")).intValue()) > 0) {
            this.info("auto shutdown timer '{}'", autoShutdownSeconds);
            this.timer = new Timer("auto shutdown timer", true);
            this.timer.schedule(new TimerTask(){

                @Override
                public void run() {
                    EmbeddedHttpServer.this.info("auto shutdown", new Object[0]);
                    EmbeddedHttpServer.getInstance().stop();
                    System.exit(0);
                }
            }, autoShutdownSeconds * 1000);
        }
        this.initServlet();
        this.threadPool = Executors.newCachedThreadPool();
        String enableHttp = this.configs.getProperty("server.http.enable", "true");
        String enableHttps = this.configs.getProperty("server.https.enable", "false");
        if (Boolean.valueOf(enableHttp).booleanValue()) {
            this.startHttp();
        }
        if (Boolean.valueOf(enableHttps).booleanValue()) {
            this.startHttps();
        }
        Runtime.getRuntime().addShutdownHook(new Thread(new Runnable(){

            @Override
            public void run() {
                System.out.println("Execute Hook.....");
                for (String name : EmbeddedHttpServer.this.servlets.keySet()) {
                    Servlet servlet = (Servlet)EmbeddedHttpServer.this.servlets.get(name);
                    servlet.destroy();
                }
            }
        }));
    }

    public void stop() {
        if (this.httpServer != null || this.httpsServer != null) {
            System.out.println("Server just now shutdown!");
            this.threadPool.shutdown();
            if (this.timer != null) {
                this.timer.cancel();
            }
            this.timer = null;
            if (this.httpServer != null) {
                this.httpServer.stop(3);
            }
            if (this.httpsServer != null) {
                this.httpsServer.stop(3);
            }
        } else {
            return;
        }
    }

    void startHttp() throws IOException {
        int port = Integer.valueOf(this.configs.getProperty("server.http.port", "80"));
        this.httpServer = HttpServer.create(new InetSocketAddress(port), 0);
        this.httpServer.setExecutor(this.threadPool);
        boolean forceHttps = Boolean.valueOf(this.configs.getProperty("server.force.https", "false"));
        DelegateHttpHandler delegateHttpHandler = new DelegateHttpHandler(this.getClass().getClassLoader(), this.threadPool, this.servlets, forceHttps);
        this.httpServer.createContext("/", new StaticHttpHandler(this.getClass().getClassLoader(), this.threadPool, forceHttps));
        for (String urlPattern : this.servlets.keySet()) {
            this.info("context '{}'", urlPattern);
            this.httpServer.createContext(urlPattern, delegateHttpHandler);
        }
        this.httpServer.start();
        System.out.println("Server is listening on port " + port);
    }

    void startHttps() throws IOException {
        int port = Integer.valueOf(this.configs.getProperty("server.https.port", "443"));
        this.httpsServer = HttpsServer.create(new InetSocketAddress(port), 0);
        this.httpsServer.setExecutor(this.threadPool);
        SSLContext sslContext = null;
        ErrorContextFactory.instance().activity("\u542f\u52a8HTTPS\u670d\u52a1", new Object[0]);
        try {
            sslContext = this.loadSslFile(this.configs.getProperty("server.https.ssl.cert.file", "ssl.cert"), this.configs.getProperty("server.https.ssl.cert.password", ""));
        }
        catch (Exception e) {
            throw ErrorContextFactory.instance().message("\u52a0\u8f7d\u8bc1\u4e66\u53d1\u751f\u9519\u8bef", new Object[0]).cause((Throwable)e).runtimeException();
        }
        finally {
            ErrorContextFactory.instance().reset();
        }
        HttpsConfigurator conf = new HttpsConfigurator(sslContext);
        this.httpsServer.setHttpsConfigurator(conf);
        boolean forceHttps = Boolean.valueOf(this.configs.getProperty("server.force.https", "false"));
        DelegateHttpHandler delegateHttpHandler = new DelegateHttpHandler(this.getClass().getClassLoader(), this.threadPool, this.servlets, forceHttps);
        this.httpsServer.createContext("/", new StaticHttpHandler(this.getClass().getClassLoader(), this.threadPool, forceHttps));
        for (String urlPattern : this.servlets.keySet()) {
            this.info("context '{}'", urlPattern);
            this.httpsServer.createContext(urlPattern, delegateHttpHandler);
        }
        this.httpsServer.start();
        System.out.println("Server is listening on port " + port);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    SSLContext loadSslFile(String httpsCertFile, String password) throws KeyStoreException, IOException, NoSuchAlgorithmException, CertificateException, UnrecoverableKeyException, KeyManagementException, URISyntaxException {
        KeyStore ks = KeyStore.getInstance("JKS");
        URL certURL = this.getClass().getClassLoader().getResource(httpsCertFile);
        if (certURL == null) {
            throw ErrorContextFactory.instance().message("https SSL cert '{}' not found", new Object[]{httpsCertFile}).runtimeException();
        }
        try (InputStream is = null;){
            is = certURL.openStream();
            ks.load(is, password.toCharArray());
        }
        KeyManagerFactory kmf = KeyManagerFactory.getInstance("SunX509");
        kmf.init(ks, password.toCharArray());
        SSLContext sslContext = SSLContext.getInstance("SSLv3");
        sslContext.init(kmf.getKeyManagers(), null, null);
        return sslContext;
    }

    public void error(String format, Object ... args) {
        this.logger.log(Level.WARNING, MessageFormatter.format((String)format, (Object[])args));
    }

    public void debug(String format, Object ... args) {
        this.logger.log(Level.FINER, MessageFormatter.format((String)format, (Object[])args));
    }

    public void info(String format, Object ... args) {
        this.logger.log(Level.INFO, MessageFormatter.format((String)format, (Object[])args));
    }
}

