/*
 * Decompiled with CFR 0.152.
 */
package com.devops4j.embedded.handler;

import com.devops4j.embedded.httpserver.HttpExchange;
import com.devops4j.embedded.httpserver.HttpHandler;
import com.devops4j.embedded.servlet.EmbeddedHttpServletRequest;
import com.devops4j.embedded.servlet.EmbeddedHttpServletResponse;
import com.devops4j.message.MessageFormatter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.concurrent.Executor;
import org.apache.commons.io.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StaticHttpHandler
implements HttpHandler {
    private static final Logger log = LoggerFactory.getLogger(StaticHttpHandler.class);
    Executor executor;
    ClassLoader classLoader;
    final boolean forceHttps;

    public StaticHttpHandler(ClassLoader classLoader, Executor executor, boolean forceHttps) {
        this.classLoader = classLoader;
        this.executor = executor;
        this.forceHttps = forceHttps;
    }

    @Override
    public void handle(HttpExchange exchange) throws IOException {
        final EmbeddedHttpServletRequest request = new EmbeddedHttpServletRequest(exchange);
        final EmbeddedHttpServletResponse response = new EmbeddedHttpServletResponse(exchange);
        this.executor.execute(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                try {
                    if (StaticHttpHandler.this.forceHttps && request.getScheme().equalsIgnoreCase("http")) {
                        String newUrl = "https://" + request.getServerName() + request.getContextPath();
                        if (!request.getQueryString().isEmpty()) {
                            newUrl = newUrl + "?" + request.getQueryString();
                        }
                        System.out.println(newUrl);
                        response.sendRedirect(newUrl);
                        return;
                    }
                    if (request.getRequestURI().equals("/")) {
                        response.sendRedirect("/index.html");
                    } else {
                        StaticHttpHandler.this.staticResource(request, response);
                    }
                }
                catch (IOException e) {
                    try {
                        response.sendError(500, e.getLocalizedMessage());
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }
                finally {
                    try {
                        response.flushBuffer();
                    }
                    catch (IOException e) {
                        throw new RuntimeException("\u5199\u5165\u7ed3\u679c\u53d1\u751f\u5f02\u5e38", e);
                    }
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    boolean staticResource(EmbeddedHttpServletRequest request, EmbeddedHttpServletResponse response) throws IOException {
        boolean bl;
        int lastFilePos;
        String path = "";
        String fileName = request.getRequestURI().substring("/".length());
        int lastPos = fileName.lastIndexOf("/");
        if (lastPos > -1) {
            path = fileName.substring(0, lastPos);
            fileName = fileName.substring(lastPos + 1);
            if (path.endsWith("/")) {
                path = path.substring(0, path.length() - 1);
            }
        }
        if ((lastFilePos = fileName.lastIndexOf(".")) > -1) {
            String suffix = fileName.substring(lastFilePos + 1);
            if ("css".equals(suffix = suffix.toLowerCase())) {
                response.setHeader("Content-Type", "text/css; charset=UTF-8");
            } else if ("js".equals(suffix)) {
                response.setHeader("Content-Type", "application/x-javascript; charset=UTF-8");
            } else if ("jpg".equals(suffix) || "jpeg".equals(suffix)) {
                response.setHeader("Content-Type", "image/jpeg");
            } else if ("gif".equals(suffix)) {
                response.setHeader("Content-Type", "image/gif");
            } else if ("png".equals(suffix)) {
                response.setHeader("Content-Type", "image/png");
            } else if ("ico".equals(suffix)) {
                response.setHeader("Content-Type", "image/x-icon");
            } else if ("htm".equals(suffix) || "html".equals(suffix)) {
                response.setHeader("Content-Type", "text/html; charset=UTF-8");
            } else if ("xml".equals(suffix)) {
                response.setHeader("Content-Type", "text/xml; charset=UTF-8");
            } else if ("svg".equals(suffix)) {
                response.setHeader("Content-Type", "image/svg+xml; charset=UTF-8");
            } else if ("svg".equals(suffix)) {
                response.setHeader("Content-Type", "image/svg+xml; charset=UTF-8");
            } else if ("woff".equals(suffix)) {
                response.setHeader("Content-Type", "application/x-font-woff; charset=UTF-8");
            } else if ("woff2".equals(suffix)) {
                response.setHeader("Content-Type", "application/octet-stream");
            } else if ("eot".equals(suffix)) {
                response.setHeader("Content-Type", "application/vnd.ms-fontobject");
            } else if ("ttf".equals(suffix)) {
                response.setHeader("Content-Type", "application/x-font-ttf");
            } else {
                response.setHeader("Content-Type", "application/octet-stream");
            }
        }
        InputStream is = null;
        try {
            String name = "webapp" + File.separator;
            name = path.isEmpty() ? name + fileName : name + path + File.separator + fileName;
            URL url = this.classLoader.getResource(name);
            if (url == null) {
                throw new FileNotFoundException(MessageFormatter.format((String)"file '{}' is not found!", (Object[])new Object[]{name}));
            }
            byte[] temp = new byte[100];
            is = url.openStream();
            int byteReadLen = 0;
            while ((byteReadLen = is.read(temp)) != -1) {
                if (byteReadLen == 100) {
                    response.write(temp);
                    continue;
                }
                byte[] data = new byte[byteReadLen];
                System.arraycopy(temp, 0, data, 0, byteReadLen);
                response.write(data);
            }
            response.setStatus(200);
            bl = true;
        }
        catch (FileNotFoundException e) {
            log.error("file is not found", (Throwable)e);
            response.write(request.getScheme() + "://" + request.getRequestURI() + "?" + request.getQueryString() + " is not found!");
            response.setStatus(404);
            boolean bl2 = false;
            IOUtils.closeQuietly((InputStream)is);
            return bl2;
        }
        catch (Exception e2) {
            log.error("happens unknown error!", (Throwable)e2);
            response.write(request.getScheme() + "://" + request.getRequestURI() + "?" + request.getQueryString() + " server happens unknown error! cause :'" + e2 + "'");
            response.setStatus(500);
            boolean bl3 = false;
            {
                catch (Throwable throwable) {
                    IOUtils.closeQuietly(is);
                    throw throwable;
                }
            }
            IOUtils.closeQuietly((InputStream)is);
            return bl3;
        }
        IOUtils.closeQuietly((InputStream)is);
        return bl;
    }
}

