/*
 * Decompiled with CFR 0.152.
 */
package com.devops4j.embedded.handler;

import com.devops4j.embedded.httpserver.HttpExchange;
import com.devops4j.embedded.httpserver.HttpHandler;
import com.devops4j.embedded.servlet.EmbeddedHttpServletRequest;
import com.devops4j.embedded.servlet.EmbeddedHttpServletResponse;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.Executor;
import javax.servlet.Servlet;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServlet;

public class DelegateHttpHandler
implements HttpHandler {
    Executor executor;
    ClassLoader classLoader;
    final Map<String, HttpServlet> servlets;
    final boolean forceHttps;

    public DelegateHttpHandler(ClassLoader classLoader, Executor executor, Map<String, HttpServlet> servlets, boolean forceHttps) {
        this.classLoader = classLoader;
        this.executor = executor;
        this.servlets = servlets == null ? new HashMap<String, HttpServlet>() : servlets;
        this.forceHttps = forceHttps;
    }

    @Override
    public void handle(HttpExchange exchange) throws IOException {
        final EmbeddedHttpServletRequest request = new EmbeddedHttpServletRequest(exchange);
        final EmbeddedHttpServletResponse response = new EmbeddedHttpServletResponse(exchange);
        this.executor.execute(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                try {
                    if (DelegateHttpHandler.this.forceHttps && request.getScheme().equalsIgnoreCase("http")) {
                        String newUrl = "https://" + request.getServerName() + request.getContextPath();
                        if (!request.getQueryString().isEmpty()) {
                            newUrl = newUrl + "?" + request.getQueryString();
                        }
                        System.out.println(newUrl);
                        response.sendRedirect(newUrl);
                        return;
                    }
                    Servlet servlet = (Servlet)DelegateHttpHandler.this.servlets.get(request.getRequestURI());
                    if (servlet != null) {
                        servlet.service((ServletRequest)request, (ServletResponse)response);
                        response.setStatus(200);
                    } else {
                        response.setStatus(404);
                    }
                }
                catch (ServletException e) {
                    try {
                        response.sendError(500, e.getLocalizedMessage());
                    }
                    catch (IOException e1) {
                        // empty catch block
                    }
                }
                catch (IOException e) {
                    try {
                        response.sendError(500, e.getLocalizedMessage());
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }
                finally {
                    try {
                        response.flushBuffer();
                    }
                    catch (IOException e) {
                        throw new RuntimeException("\u5199\u5165\u7ed3\u679c\u53d1\u751f\u5f02\u5e38", e);
                    }
                }
            }
        });
    }
}

