package com.devops4j.embedded.servlet;

import com.devops4j.embedded.buffer.ByteBuf;
import lombok.Data;

import javax.servlet.ReadListener;
import java.io.IOException;

@Data
class EmbeddedServletInputStream extends javax.servlet.ServletInputStream {
    ByteBuf byteBuf;

    public EmbeddedServletInputStream(ByteBuf byteBuf) {
        this.byteBuf = byteBuf;
    }

    @Override
    public boolean isFinished() {
        return true;
    }

    @Override
    public boolean isReady() {
        return true;
    }

    @Override
    public void setReadListener(ReadListener readListener) {

    }

    @Override
    public int read() throws IOException {
        return byteBuf.getInt();
    }
}